/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.MDC;
import org.apache.log4j.NDC;
import org.jboss.logging.Log4jLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;

final class Log4jLoggerProvider
implements LoggerProvider {
    Log4jLoggerProvider() {
    }

    public Logger getLogger(String name) {
        return new Log4jLogger("".equals(name) ? "ROOT" : name);
    }

    public void clearMdc() {
        MDC.clear();
    }

    public Object getMdc(String key) {
        return MDC.get((String)key);
    }

    public Map<String, Object> getMdcMap() {
        Hashtable map = MDC.getContext();
        return map == null ? Collections.emptyMap() : map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putMdc(String key, Object val) {
        try {
            Object object = MDC.get((String)key);
            return object;
        }
        finally {
            MDC.put((String)key, (Object)val);
        }
    }

    public void removeMdc(String key) {
        MDC.remove((String)key);
    }

    public void clearNdc() {
        NDC.remove();
    }

    public String getNdc() {
        return NDC.get();
    }

    public int getNdcDepth() {
        return NDC.getDepth();
    }

    public String peekNdc() {
        return NDC.peek();
    }

    public String popNdc() {
        return NDC.pop();
    }

    public void pushNdc(String message) {
        NDC.push((String)message);
    }

    public void setNdcMaxDepth(int maxDepth) {
        NDC.setMaxDepth((int)maxDepth);
    }
}

