/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Queue;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.ErrorResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncExpectationVerifier;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.protocol.MessageState;
import org.apache.http.nio.protocol.NullRequestHandler;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class HttpAsyncService
implements NHttpServerEventHandler {
    static final String HTTP_EXCHANGE_STATE = "http.nio.http-exchange-state";
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connectionStrategy;
    private final HttpResponseFactory responseFactory;
    private final HttpAsyncRequestHandlerMapper handlerMapper;
    private final HttpAsyncExpectationVerifier expectationVerifier;
    private final ExceptionLogger exceptionLogger;

    @Deprecated
    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpAsyncRequestHandlerResolver handlerResolver, HttpAsyncExpectationVerifier expectationVerifier, HttpParams params) {
        this(httpProcessor, connStrategy, responseFactory, (HttpAsyncRequestHandlerMapper)new HttpAsyncRequestHandlerResolverAdapter(handlerResolver), expectationVerifier);
    }

    @Deprecated
    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpAsyncRequestHandlerResolver handlerResolver, HttpParams params) {
        this(httpProcessor, connStrategy, (HttpResponseFactory)DefaultHttpResponseFactory.INSTANCE, (HttpAsyncRequestHandlerMapper)new HttpAsyncRequestHandlerResolverAdapter(handlerResolver), null);
    }

    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpAsyncRequestHandlerMapper handlerMapper, HttpAsyncExpectationVerifier expectationVerifier) {
        this(httpProcessor, connStrategy, responseFactory, handlerMapper, expectationVerifier, null);
    }

    public HttpAsyncService(HttpProcessor httpProcessor, ConnectionReuseStrategy connStrategy, HttpResponseFactory responseFactory, HttpAsyncRequestHandlerMapper handlerMapper, HttpAsyncExpectationVerifier expectationVerifier, ExceptionLogger exceptionLogger) {
        this.httpProcessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.connectionStrategy = connStrategy != null ? connStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.handlerMapper = handlerMapper;
        this.expectationVerifier = expectationVerifier;
        this.exceptionLogger = exceptionLogger != null ? exceptionLogger : ExceptionLogger.NO_OP;
    }

    public HttpAsyncService(HttpProcessor httpProcessor, HttpAsyncRequestHandlerMapper handlerMapper) {
        this(httpProcessor, null, null, handlerMapper, null);
    }

    public HttpAsyncService(HttpProcessor httpProcessor, HttpAsyncRequestHandlerMapper handlerMapper, ExceptionLogger exceptionLogger) {
        this(httpProcessor, null, null, handlerMapper, null, exceptionLogger);
    }

    public void connected(NHttpServerConnection conn) {
        State state = new State();
        conn.getContext().setAttribute(HTTP_EXCHANGE_STATE, (Object)state);
    }

    public void closed(NHttpServerConnection conn) {
        State state = (State)conn.getContext().removeAttribute(HTTP_EXCHANGE_STATE);
        if (state != null) {
            state.setTerminated();
            this.closeHandlers(state);
            Cancellable cancellable = state.getCancellable();
            if (cancellable != null) {
                cancellable.cancel();
            }
        }
    }

    public void exception(NHttpServerConnection conn, Exception cause) {
        this.log(cause);
        State state = this.getState((NHttpConnection)conn);
        if (state == null) {
            this.shutdownConnection((NHttpConnection)conn);
            return;
        }
        state.setTerminated();
        this.closeHandlers(state, cause);
        try {
            Queue pipeline;
            PipelineEntry pipelineEntry;
            Incoming incoming;
            Cancellable cancellable = state.getCancellable();
            if (cancellable != null) {
                cancellable.cancel();
            }
            if (cause instanceof SocketException) {
                conn.shutdown();
                return;
            }
            if (cause instanceof SocketTimeoutException) {
                conn.close();
                return;
            }
            if (conn.isResponseSubmitted() || state.getResponseState().compareTo((Enum)MessageState.INIT) > 0) {
                conn.close();
                return;
            }
            HttpRequest request = conn.getHttpRequest();
            if (request == null && (incoming = state.getIncoming()) != null) {
                request = incoming.getRequest();
            }
            if (request == null && (pipelineEntry = (PipelineEntry)(pipeline = state.getPipeline()).poll()) != null) {
                request = pipelineEntry.getRequest();
            }
            if (request != null) {
                conn.resetInput();
                HttpCoreContext context = HttpCoreContext.create();
                HttpAsyncResponseProducer responseProducer = this.handleException(cause, (HttpContext)context);
                HttpResponse response = responseProducer.generateResponse();
                Outgoing outgoing = new Outgoing(request, response, responseProducer, (HttpContext)context);
                state.setResponseState(MessageState.INIT);
                state.setOutgoing(outgoing);
                this.commitFinalResponse(conn, state);
                return;
            }
            conn.close();
        }
        catch (Exception ex) {
            this.shutdownConnection((NHttpConnection)conn);
            this.closeHandlers(state);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            this.log(ex);
        }
    }

    protected HttpResponse createHttpResponse(int status, HttpContext context) {
        return this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, status, context);
    }

    public void requestReceived(NHttpServerConnection conn) throws IOException, HttpException {
        State state = this.getState((NHttpConnection)conn);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getRequestState() == MessageState.READY ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getRequestState());
        HttpRequest request = conn.getHttpRequest();
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.request", (Object)request);
        context.setAttribute("http.connection", (Object)conn);
        this.httpProcessor.process(request, (HttpContext)context);
        HttpAsyncRequestHandler requestHandler = this.getRequestHandler(request);
        HttpAsyncRequestConsumer consumer = requestHandler.processRequest(request, (HttpContext)context);
        consumer.requestReceived(request);
        Incoming incoming = new Incoming(request, requestHandler, consumer, (HttpContext)context);
        state.setIncoming(incoming);
        if (request instanceof HttpEntityEnclosingRequest) {
            if (((HttpEntityEnclosingRequest)request).expectContinue() && state.getResponseState() == MessageState.READY && state.getPipeline().isEmpty() && (!(conn instanceof SessionBufferStatus) || !((SessionBufferStatus)conn).hasBufferedInput())) {
                state.setRequestState(MessageState.ACK_EXPECTED);
                HttpResponse ack = this.createHttpResponse(100, (HttpContext)context);
                if (this.expectationVerifier != null) {
                    conn.suspendInput();
                    conn.suspendOutput();
                    HttpAsyncExchangeImpl httpAsyncExchange = new HttpAsyncExchangeImpl(this, request, ack, state, conn, (HttpContext)context);
                    this.expectationVerifier.verify((HttpAsyncExchange)httpAsyncExchange, (HttpContext)context);
                } else {
                    conn.submitResponse(ack);
                    state.setRequestState(MessageState.BODY_STREAM);
                }
            } else {
                state.setRequestState(MessageState.BODY_STREAM);
            }
        } else {
            this.completeRequest(incoming, conn, state);
        }
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) throws IOException, HttpException {
        State state = this.getState((NHttpConnection)conn);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getRequestState() == MessageState.BODY_STREAM ? 1 : 0) != 0, (String)"Unexpected request state %s", (Object)state.getRequestState());
        Incoming incoming = state.getIncoming();
        Asserts.notNull((Object)incoming, (String)"Incoming request");
        HttpAsyncRequestConsumer consumer = incoming.getConsumer();
        consumer.consumeContent(decoder, (IOControl)conn);
        if (decoder.isCompleted()) {
            this.completeRequest(incoming, conn, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void responseReady(NHttpServerConnection conn) throws IOException, HttpException {
        Outgoing outgoing;
        PipelineEntry pipelineEntry;
        State state = this.getState((NHttpConnection)conn);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getResponseState() == MessageState.READY || state.getResponseState() == MessageState.INIT ? 1 : 0) != 0, (String)"Unexpected response state %s", (Object)state.getResponseState());
        if (state.getRequestState() == MessageState.ACK_EXPECTED) {
            Outgoing outgoing2;
            State state2 = state;
            synchronized (state2) {
                outgoing2 = state.getOutgoing();
                if (outgoing2 == null) {
                    conn.suspendOutput();
                    return;
                }
            }
            HttpResponse response = outgoing2.getResponse();
            int status = response.getStatusLine().getStatusCode();
            if (status == 100) {
                HttpContext context = outgoing2.getContext();
                HttpAsyncResponseProducer responseProducer = outgoing2.getProducer();
                try {
                    response.setEntity(null);
                    conn.requestInput();
                    state.setRequestState(MessageState.BODY_STREAM);
                    state.setOutgoing(null);
                    conn.submitResponse(response);
                    responseProducer.responseCompleted(context);
                    return;
                }
                finally {
                    responseProducer.close();
                }
            } else {
                if (status < 400) throw new HttpException("Invalid response: " + response.getStatusLine());
                conn.resetInput();
                state.setRequestState(MessageState.READY);
                this.commitFinalResponse(conn, state);
            }
            return;
        }
        if (state.getResponseState() == MessageState.READY) {
            Queue pipeline = state.getPipeline();
            pipelineEntry = (PipelineEntry)pipeline.poll();
            if (pipelineEntry == null) {
                conn.suspendOutput();
                return;
            }
            state.setResponseState(MessageState.INIT);
            Object result = pipelineEntry.getResult();
            HttpRequest request = pipelineEntry.getRequest();
            HttpContext context = pipelineEntry.getContext();
            HttpResponse response = this.createHttpResponse(200, context);
            HttpAsyncExchangeImpl httpExchange = new HttpAsyncExchangeImpl(this, request, response, state, conn, context);
            if (result != null) {
                HttpAsyncRequestHandler handler = pipelineEntry.getHandler();
                conn.suspendOutput();
                try {
                    handler.handle(result, (HttpAsyncExchange)httpExchange, context);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    if (!httpExchange.isCompleted()) {
                        httpExchange.submitResponse(this.handleException(ex, context));
                        return;
                    } else {
                        this.log(ex);
                        conn.close();
                    }
                    return;
                }
            } else {
                Exception exception = pipelineEntry.getException();
                HttpAsyncResponseProducer responseProducer = this.handleException((Exception)(exception != null ? exception : new HttpException("Internal error processing request")), context);
                httpExchange.submitResponse(responseProducer);
            }
        }
        if (state.getResponseState() != MessageState.INIT) return;
        pipelineEntry = state;
        synchronized (pipelineEntry) {
            outgoing = state.getOutgoing();
            if (outgoing == null) {
                conn.suspendOutput();
                return;
            }
        }
        HttpResponse response = outgoing.getResponse();
        int status = response.getStatusLine().getStatusCode();
        if (status < 200) throw new HttpException("Invalid response: " + response.getStatusLine());
        this.commitFinalResponse(conn, state);
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) throws HttpException, IOException {
        State state = this.getState((NHttpConnection)conn);
        Asserts.notNull((Object)state, (String)"Connection state");
        Asserts.check((state.getResponseState() == MessageState.BODY_STREAM ? 1 : 0) != 0, (String)"Unexpected response state %s", (Object)state.getResponseState());
        Outgoing outgoing = state.getOutgoing();
        Asserts.notNull((Object)outgoing, (String)"Outgoing response");
        HttpAsyncResponseProducer responseProducer = outgoing.getProducer();
        responseProducer.produceContent(encoder, (IOControl)conn);
        if (encoder.isCompleted()) {
            this.completeResponse(outgoing, conn, state);
        }
    }

    public void endOfInput(NHttpServerConnection conn) throws IOException {
        if (conn.getSocketTimeout() <= 0) {
            conn.setSocketTimeout(1000);
        }
        conn.close();
    }

    public void timeout(NHttpServerConnection conn) throws IOException {
        State state = this.getState((NHttpConnection)conn);
        if (state != null) {
            this.closeHandlers(state, (Exception)new SocketTimeoutException(String.format("%,d milliseconds timeout on connection %s", conn.getSocketTimeout(), conn)));
        }
        if (conn.getStatus() == 0) {
            conn.close();
            if (conn.getStatus() == 1) {
                conn.setSocketTimeout(250);
            }
        } else {
            conn.shutdown();
        }
    }

    private State getState(NHttpConnection conn) {
        return (State)conn.getContext().getAttribute(HTTP_EXCHANGE_STATE);
    }

    protected void log(Exception ex) {
        this.exceptionLogger.log(ex);
    }

    private void shutdownConnection(NHttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException ex) {
            this.log((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeHandlers(State state, Exception ex) {
        HttpAsyncResponseProducer producer;
        HttpAsyncRequestConsumer consumer;
        HttpAsyncRequestConsumer httpAsyncRequestConsumer = consumer = state.getIncoming() != null ? state.getIncoming().getConsumer() : null;
        if (consumer != null) {
            try {
                consumer.failed(ex);
            }
            finally {
                try {
                    consumer.close();
                }
                catch (IOException ioex) {
                    this.log((Exception)ioex);
                }
            }
        }
        HttpAsyncResponseProducer httpAsyncResponseProducer = producer = state.getOutgoing() != null ? state.getOutgoing().getProducer() : null;
        if (producer != null) {
            try {
                producer.failed(ex);
            }
            finally {
                try {
                    producer.close();
                }
                catch (IOException ioex) {
                    this.log((Exception)ioex);
                }
            }
        }
    }

    private void closeHandlers(State state) {
        HttpAsyncResponseProducer producer;
        HttpAsyncRequestConsumer consumer;
        HttpAsyncRequestConsumer httpAsyncRequestConsumer = consumer = state.getIncoming() != null ? state.getIncoming().getConsumer() : null;
        if (consumer != null) {
            try {
                consumer.close();
            }
            catch (IOException ioex) {
                this.log((Exception)ioex);
            }
        }
        HttpAsyncResponseProducer httpAsyncResponseProducer = producer = state.getOutgoing() != null ? state.getOutgoing().getProducer() : null;
        if (producer != null) {
            try {
                producer.close();
            }
            catch (IOException ioex) {
                this.log((Exception)ioex);
            }
        }
    }

    protected HttpAsyncResponseProducer handleException(Exception ex, HttpContext context) {
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        HttpResponse response = this.createHttpResponse(this.toStatusCode(ex, context), context);
        return new ErrorResponseProducer(response, (HttpEntity)new NStringEntity(message, ContentType.DEFAULT_TEXT), false);
    }

    protected int toStatusCode(Exception ex, HttpContext context) {
        int code = ex instanceof MethodNotSupportedException ? 501 : (ex instanceof UnsupportedHttpVersionException ? 505 : (ex instanceof ProtocolException ? 400 : 500));
        return code;
    }

    protected void handleAlreadySubmittedResponse(Cancellable cancellable, HttpContext context) {
        throw new IllegalStateException("Response already submitted");
    }

    protected void handleAlreadySubmittedResponse(HttpAsyncResponseProducer responseProducer, HttpContext context) {
        throw new IllegalStateException("Response already submitted");
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRequest(Incoming incoming, NHttpServerConnection conn, State state) throws IOException {
        PipelineEntry pipelineEntry;
        state.setRequestState(MessageState.READY);
        state.setIncoming(null);
        HttpAsyncRequestConsumer consumer = incoming.getConsumer();
        try {
            HttpContext context = incoming.getContext();
            consumer.requestCompleted(context);
            pipelineEntry = new PipelineEntry(incoming.getRequest(), consumer.getResult(), consumer.getException(), incoming.getHandler(), context);
        }
        finally {
            consumer.close();
        }
        Queue pipeline = state.getPipeline();
        pipeline.add(pipelineEntry);
        if (state.getResponseState() == MessageState.READY) {
            conn.requestOutput();
        }
    }

    private void commitFinalResponse(NHttpServerConnection conn, State state) throws IOException, HttpException {
        Outgoing outgoing = state.getOutgoing();
        Asserts.notNull((Object)outgoing, (String)"Outgoing response");
        HttpRequest request = outgoing.getRequest();
        HttpResponse response = outgoing.getResponse();
        HttpContext context = outgoing.getContext();
        context.setAttribute("http.response", (Object)response);
        this.httpProcessor.process(response, context);
        HttpEntity entity = response.getEntity();
        if (entity != null && !this.canResponseHaveBody(request, response)) {
            response.setEntity(null);
            entity = null;
        }
        conn.submitResponse(response);
        if (entity == null) {
            this.completeResponse(outgoing, conn, state);
        } else {
            state.setResponseState(MessageState.BODY_STREAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeResponse(Outgoing outgoing, NHttpServerConnection conn, State state) throws IOException {
        HttpContext context = outgoing.getContext();
        HttpResponse response = outgoing.getResponse();
        HttpAsyncResponseProducer responseProducer = outgoing.getProducer();
        try {
            responseProducer.responseCompleted(context);
            state.setOutgoing(null);
            state.setCancellable(null);
            state.setResponseState(MessageState.READY);
        }
        finally {
            responseProducer.close();
        }
        if (!this.connectionStrategy.keepAlive(response, context)) {
            conn.close();
        } else {
            conn.requestInput();
        }
    }

    private HttpAsyncRequestHandler<Object> getRequestHandler(HttpRequest request) {
        NullRequestHandler handler = null;
        if (this.handlerMapper != null) {
            handler = this.handlerMapper.lookup(request);
        }
        if (handler == null) {
            handler = NullRequestHandler.INSTANCE;
        }
        return handler;
    }

    public HttpResponseFactory getResponseFactory() {
        return this.responseFactory;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public ConnectionReuseStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public HttpAsyncRequestHandlerMapper getHandlerMapper() {
        return this.handlerMapper;
    }

    public HttpAsyncExpectationVerifier getExpectationVerifier() {
        return this.expectationVerifier;
    }

    public ExceptionLogger getExceptionLogger() {
        return this.exceptionLogger;
    }
}

