/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;

public class ResponseHolder {
    private HttpRequestBase httpRequest;
    private HttpResponse httpResponse;
    private int status;
    private String locationHeader;
    private String responseString;

    public ResponseHolder(HttpRequestBase httpRequest, HttpResponse httpResponse) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.status = httpResponse.getStatusLine().getStatusCode();
        Header h = httpResponse.getFirstHeader("Location");
        this.locationHeader = h == null ? null : h.getValue();
        HttpEntity entity = httpResponse.getEntity();
        try {
            this.responseString = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
        }
        catch (IOException e) {
            this.responseString = null;
        }
    }

    public URI getRequestURI() {
        return this.httpRequest.getURI();
    }

    public int getStatus() {
        return this.status;
    }

    public String getLocationHeader() {
        return this.locationHeader;
    }

    public String getResponseString() {
        return this.responseString;
    }

    public URI getLocationHeaderAsURI() throws URISyntaxException {
        return this.locationHeader != null ? new URI(this.locationHeader) : null;
    }

    public boolean hasEntity() {
        return this.responseString != null;
    }

    public String getLastHeader(String headerName) {
        return this.httpResponse.getLastHeader(headerName).getValue();
    }

    public String readEntity() {
        return this.responseString;
    }

    public String getHeader(String name) {
        Header header = this.httpResponse.getLastHeader(name);
        return header == null ? null : header.getValue();
    }
}

