/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.abstractrecords.PersistenceRecord;
import java.io.PrintWriter;

public class CadaverRecord
extends PersistenceRecord {
    private boolean newStateIsValid;
    private OutputObjectState oldState;
    private int oType;

    public CadaverRecord(OutputObjectState os, ParticipantStore participantStore, StateManager sm) {
        super(os, participantStore, sm);
        this.newStateIsValid = os != null;
        this.oldState = null;
        this.oType = 463;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CadaverRecord::CadaverRecord(" + os + ", " + sm.get_uid() + ")"));
        }
    }

    public boolean propagateOnAbort() {
        return true;
    }

    public int typeIs() {
        return 111;
    }

    public int nestedAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CadaverRecord::nestedAbort() for " + this.order()));
        }
        if (this.oldState != null) {
            this.newStateIsValid = false;
        }
        if (this.oType == 101) {
            tsLogger.i18NLogger.warn_CadaverRecord_1(this.order(), this.getTypeOfObject());
        }
        return 7;
    }

    public int nestedPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CadaverRecord::nestedPrepare() for " + this.order()));
        }
        if (this.newStateIsValid) {
            return super.nestedPrepare();
        }
        return 1;
    }

    public int topLevelAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CadaverRecord::topLevelAbort() for " + this.order()));
        }
        this.newStateIsValid = false;
        if (this.oType == 101) {
            tsLogger.i18NLogger.warn_CadaverRecord_1(this.order(), this.getTypeOfObject());
        }
        return 7;
    }

    public int topLevelCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CadaverRecord::topLevelCommit() for " + this.order()));
        }
        boolean res = true;
        OutputObjectState oState = this.state;
        if (oState != null && this.oType == 111) {
            if (this.targetParticipantStore == null) {
                return 8;
            }
            try {
                res = this.targetParticipantStore.commit_state(oState.stateUid(), oState.type());
            }
            catch (ObjectStoreException e) {
                res = false;
            }
        }
        return res ? 7 : 8;
    }

    public int topLevelPrepare() {
        OutputObjectState oState;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("CadaverRecord::topLevelPrepare() for " + this.order()));
        }
        int tlpOk = 1;
        OutputObjectState outputObjectState = oState = this.newStateIsValid ? this.state : this.oldState;
        if (oState != null) {
            if (this.oType == 111) {
                if (this.targetParticipantStore == null) {
                    return 1;
                }
                try {
                    if (this.targetParticipantStore.write_uncommitted(oState.stateUid(), oState.type(), oState) && this.shadowForced()) {
                        tlpOk = 0;
                    }
                }
                catch (ObjectStoreException e) {
                    e.printStackTrace();
                }
            } else {
                tlpOk = 0;
            }
        }
        return tlpOk;
    }

    public void print(PrintWriter strm) {
        strm.println("Cadaver for:");
        super.print(strm);
    }

    public String type() {
        return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/CadaverRecord";
    }

    public boolean doSave() {
        return this.oType == 111;
    }

    public void merge(AbstractRecord mergewith) {
        this.oType = mergewith.typeIs();
        if (this.oldState != null) {
            if (this.newStateIsValid) {
                this.oldState = null;
            } else {
                this.setValue((Object)this.oldState);
                this.newStateIsValid = true;
            }
        }
        this.oldState = new OutputObjectState((OutputObjectState)mergewith.value());
    }

    public boolean shouldMerge(AbstractRecord ar) {
        return this.order().equals(ar.order()) && (ar.typeIs() == 111 || ar.typeIs() == 101);
    }

    public boolean shouldReplace(AbstractRecord ar) {
        return this.order().equals(ar.order()) && (ar.typeIs() == 111 || ar.typeIs() == 101);
    }

    public CadaverRecord() {
        this.newStateIsValid = false;
        this.oldState = null;
        this.oType = 463;
        this.targetParticipantStore = null;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"CadaverRecord::CadaverRecord ()");
        }
    }
}

