/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ActionManager {
    private static final ActionManager _theManager = new ActionManager();
    private static final Map<Uid, Lifetime> _allActions = new ConcurrentHashMap();

    public static final ActionManager manager() {
        return _theManager;
    }

    public void put(BasicAction act) {
        _allActions.put(act.get_uid(), new Lifetime(this, act));
    }

    public BasicAction get(Uid id) {
        Lifetime lt = (Lifetime)_allActions.get(id);
        if (lt != null) {
            return lt.getAction();
        }
        return null;
    }

    @Deprecated
    public long getTimeAdded(Uid id) {
        Lifetime lt = (Lifetime)_allActions.get(id);
        if (lt != null) {
            return lt.getTimeAdded();
        }
        return 0L;
    }

    public void remove(Uid id) {
        _allActions.remove(id);
    }

    public int getNumberOfInflightTransactions() {
        return _allActions.size();
    }

    private ActionManager() {
    }
}

