/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.MetaInfServicesProvider;
import com.ibm.ws.classloading.internal.AppClassLoader;
import com.ibm.ws.classloading.internal.ClassLoaderRef;
import com.ibm.ws.classloading.internal.ClassLoadingServiceImpl;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.ParentLastClassLoader;
import com.ibm.ws.classloading.internal.SpringLoader;
import com.ibm.ws.classloading.internal.UnifiedClassLoader;
import com.ibm.ws.classloading.internal.util.Keyed;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThreadContextClassLoader
extends UnifiedClassLoader
implements Keyed<String> {
    static final TraceComponent tc;
    private final AtomicReference<Bundle> bundle = new AtomicReference();
    protected final String key;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final ClassLoader appLoader;
    private final ClassLoadingServiceImpl clSvc;
    static final long serialVersionUID = -4347850812332088208L;

    public ThreadContextClassLoader(GatewayClassLoader augLoader, ClassLoader appLoader, String key, ClassLoadingServiceImpl clSvc) {
        this(augLoader, appLoader, key, clSvc, appLoader instanceof AppClassLoader ? new ClassLoaderRef((AppClassLoader)appLoader) : appLoader);
    }

    private ThreadContextClassLoader(GatewayClassLoader augLoader, ClassLoader appLoader, String key, ClassLoadingServiceImpl clSvc, ClassLoader appLoaderRef) {
        super(appLoader instanceof ParentLastClassLoader ? appLoaderRef : augLoader, appLoader instanceof ParentLastClassLoader ? augLoader : appLoaderRef);
        this.bundle.set(augLoader.getBundle());
        this.key = key;
        this.appLoader = appLoaderRef;
        this.clSvc = clSvc;
    }

    private void cleanup() {
        String methodName = "cleanup(): ";
        try {
            final Bundle b = this.bundle.getAndSet(null);
            if (b != null) {
                SecurityManager sm;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cleanup(): Uninstalling bundle location: " + b.getLocation() + ", bundle id: " + b.getBundleId()), (Object[])new Object[0]);
                }
                if ((sm = System.getSecurityManager()) != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){
                        static final long serialVersionUID = -6059637417439228112L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() {
                            try {
                                b.uninstall();
                                return null;
                            }
                            catch (BundleException bundleException) {
                                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.ThreadContextClassLoader$1", (String)"93", (Object)this, (Object[])new Object[0]);
                                return null;
                            }
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ThreadContextClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                        }
                    });
                } else {
                    b.uninstall();
                }
            }
        }
        catch (BundleException bundleException) {
            FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.ThreadContextClassLoader", (String)"102", (Object)this, (Object[])new Object[0]);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.classloading.internal.ThreadContextClassLoader", (String)"103", (Object)this, (Object[])new Object[0]);
        }
    }

    int decrementRefCount() {
        String methodName = "decrementRefCount(): ";
        int count = this.refCount.decrementAndGet();
        if (count < 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"decrementRefCount():  refCount < 0 - too many calls to destroy/cleaup", (Object[])new Object[]{new Throwable("stack trace")});
        }
        if (count == 0) {
            this.cleanup();
        }
        return count;
    }

    int incrementRefCount() {
        return this.refCount.incrementAndGet();
    }

    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> findClass(String className, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        Class<?> c = null;
        try {
            c = super.findClass(className, delegatePolicy, returnNull);
        }
        catch (ClassNotFoundException x) {
            cnfe = x;
        }
        if (c == null) {
            MetaInfServicesProvider metaInfServices = (MetaInfServicesProvider)this.clSvc.metaInfServicesRefs.getService((Object)className);
            Class<?> clazz = c = metaInfServices == null ? null : metaInfServices.getProviderImplClass();
        }
        if (c != null || returnNull) {
            return c;
        }
        throw cnfe;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve, LibertyLoader.DelegatePolicy delegatePolicy, boolean returnNull) throws ClassNotFoundException {
        return super.loadClass(name, resolve, delegatePolicy, returnNull);
    }

    @Override
    protected URL findResource(String name) {
        ConcurrentLinkedQueue<String> providerNames;
        URL url = super.findResource(name);
        if (url == null && (providerNames = this.clSvc.metaInfServicesProviders.get(name)) != null) {
            for (String providerImplClassName : providerNames) {
                ServiceReference ref;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)providerImplClassName, (Object[])new Object[0]);
                }
                if ((ref = this.clSvc.metaInfServicesRefs.getReference((Object)providerImplClassName)) == null) continue;
                url = (URL)ref.getProperty("file.url");
                break;
            }
        }
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> urlEnum = super.findResources(name);
        ConcurrentLinkedQueue<String> providerNames = this.clSvc.metaInfServicesProviders.get(name);
        if (providerNames != null && !providerNames.isEmpty()) {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            while (urlEnum.hasMoreElements()) {
                urls.add(urlEnum.nextElement());
            }
            for (String providerImplClassName : providerNames) {
                ServiceReference ref;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)providerImplClassName, (Object[])new Object[0]);
                }
                if ((ref = this.clSvc.metaInfServicesRefs.getReference((Object)providerImplClassName)) == null) continue;
                urls.add((URL)ref.getProperty("file.url"));
            }
            urlEnum = Collections.enumeration(urls);
        }
        return urlEnum;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    final boolean isFor(ClassLoader classLoader) {
        ClassLoader classLoaderToCompare = this.appLoader;
        if (this.appLoader instanceof ClassLoaderRef) {
            classLoaderToCompare = ((ClassLoaderRef)this.appLoader).getReferent();
        }
        return classLoader == classLoaderToCompare;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(": Application ClassLoader ");
        sb.append(this.appLoader);
        return sb.toString();
    }

    @Override
    @Trivial
    public Class<?> publicDefineClass(String name, byte[] b, ProtectionDomain protectionDomain) {
        if (this.appLoader instanceof SpringLoader) {
            return ((SpringLoader)((Object)this.appLoader)).publicDefineClass(name, b, protectionDomain);
        }
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(ThreadContextClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    }
}

