/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InvalidResponseTypeException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InvalidResponseTypeException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _responseType;
    private String _firstResponseType;
    private String _secondResponseType;

    public OAuth20InvalidResponseTypeException(String responseType) {
        super("unsupported_response_type", "The response_type parameter was invalid: " + responseType, null);
        this._responseType = responseType;
    }

    public OAuth20InvalidResponseTypeException(String msgKey, String responseType) {
        this(msgKey, responseType, null, null);
    }

    public OAuth20InvalidResponseTypeException(String msgKey, String responseType, String firstResponseTypeOption, String secondResponseTypeOption) {
        super("unsupported_response_type", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{responseType, firstResponseTypeOption, secondResponseTypeOption}), null);
        this._msgKey = msgKey;
        this._responseType = responseType;
        this._firstResponseType = firstResponseTypeOption;
        this._secondResponseType = secondResponseTypeOption;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        if (this._firstResponseType == null || this._secondResponseType == null) {
            return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._responseType, (Locale)locale, (String)encoding));
        }
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode((String)this._responseType, (Locale)locale, (String)encoding), WebUtils.encode((String)this._firstResponseType, (Locale)locale, (String)encoding), WebUtils.encode((String)this._secondResponseType, (Locale)locale, (String)encoding));
    }

    public String getResponseType() {
        return this._responseType;
    }
}

