/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.OpenIDException;

public class OpenID4JavaUtils {
    private static Log _log = LogFactory.getLog(OpenID4JavaUtils.class);
    private static final Properties _appProperties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String name) {
        Properties p = null;
        InputStream is = OpenIDException.class.getResourceAsStream(name);
        if (is != null) {
            p = new Properties();
            try {
                p.load(is);
            }
            catch (IOException e) {
                _log.error((Object)("Load properties from " + name + " failed."), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _log.warn((Object)"Error closing resource stream.", (Throwable)e);
                }
            }
        } else {
            _log.debug((Object)("Resource " + name + " not found."));
        }
        return p;
    }

    public static String getProperty(String key) {
        return _appProperties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return _appProperties.getProperty(key, defaultValue);
    }

    private OpenID4JavaUtils() {
    }

    static {
        _appProperties.putAll((Map<?, ?>)OpenID4JavaUtils.loadProperties("openid4java-default.properties"));
        Properties custom = OpenID4JavaUtils.loadProperties("/openid4java.properties");
        if (custom != null) {
            _appProperties.putAll((Map<?, ?>)custom);
        }
    }
}

