/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.internal.logging.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.List;
import java.util.Optional;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LoggingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(LoggingFilter.class, (String)"RESTfulWS", (String)"io.openliberty.restfulWS.internal.logging.filter.nls.LoggingFilter");
    private static final String LS = System.lineSeparator();
    private static final String REQUEST_TEMPLATE = Tr.formatMessage((TraceComponent)tc, (String)"HTTP_REQUEST", (Object[])new Object[0]) + LS + "> %s %s" + LS + LS + "%s" + LS + LS + "%s";
    private static final String RESPONSE_TEMPLATE = Tr.formatMessage((TraceComponent)tc, (String)"HTTP_REQUEST", (Object[])new Object[0]) + LS + "< %d %s" + LS + LS + "%s" + LS + LS + "%s";
    private static final String UNLOGGED = Tr.formatMessage((TraceComponent)tc, (String)"UNLOGGED", (Object[])new Object[0]);
    private static final String NO_ENTITY = Tr.formatMessage((TraceComponent)tc, (String)"NO_ENTITY", (Object[])new Object[0]);
    private final boolean LOG_ENTITY = AccessController.doPrivileged(() -> Boolean.getBoolean("io.openliberty.restfulWS.logging.filter.logHTTPEntities"));
    @Context
    Providers providers;
    static final long serialVersionUID = 2875920374263599063L;

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        String entity;
        String httpMethod = reqCtx.getMethod();
        StringBuilder sb = new StringBuilder();
        UriInfo uriInfo = reqCtx.getUriInfo();
        sb.append(uriInfo.getBaseUri()).append(" ").append(uriInfo.getPath());
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        if (!queryParams.isEmpty()) {
            sb.append("?");
            for (Object e : queryParams.entrySet()) {
                for (String value : (List)e.getValue()) {
                    sb.append((String)e.getKey()).append("=").append(value).append("&");
                }
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        String path = sb.toString();
        sb = new StringBuilder();
        for (String headerName : reqCtx.getHeaders().keySet()) {
            sb.append(headerName).append(": ").append(reqCtx.getHeaderString(headerName)).append(LS);
        }
        String headers = sb.toString();
        if (!this.LOG_ENTITY) {
            entity = UNLOGGED;
        } else if (!reqCtx.hasEntity()) {
            entity = NO_ENTITY;
        } else {
            byte[] entityBytes = LoggingFilter.toByteArray(reqCtx.getEntityStream());
            reqCtx.setEntityStream((InputStream)new ByteArrayInputStream(entityBytes));
            entity = new String(entityBytes, LoggingFilter.charset(reqCtx.getMediaType()));
        }
        Tr.info((TraceComponent)tc, (String)String.format(REQUEST_TEMPLATE, httpMethod, path, headers, entity), (Object[])new Object[0]);
    }

    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext respCtx) throws IOException {
        String entity;
        int responseCode = respCtx.getStatusInfo().getStatusCode();
        String responsePhrase = respCtx.getStatusInfo().getReasonPhrase();
        StringBuilder sb = new StringBuilder();
        MultivaluedMap httpHeaders = respCtx.getHeaders();
        for (String headerName : httpHeaders.keySet()) {
            sb.append(headerName).append(": ").append(respCtx.getHeaderString(headerName)).append(LS);
        }
        String headers = sb.toString();
        if (!this.LOG_ENTITY) {
            entity = UNLOGGED;
        } else if (!respCtx.hasEntity()) {
            entity = NO_ENTITY;
        } else {
            Object entityObj = respCtx.getEntity();
            Class entityClass = respCtx.getEntityClass();
            Annotation[] entityAnnotations = respCtx.getEntityAnnotations();
            Type entityType = respCtx.getEntityType();
            MediaType entityMediaType = respCtx.getMediaType();
            MessageBodyWriter mbw = this.providers.getMessageBodyWriter(entityClass, entityType, entityAnnotations, entityMediaType);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            mbw.writeTo(entityObj, entityClass, entityType, entityAnnotations, entityMediaType, httpHeaders, (OutputStream)baos);
            entity = new String(baos.toByteArray(), LoggingFilter.charset(entityMediaType));
        }
        Tr.info((TraceComponent)tc, (String)String.format(RESPONSE_TEMPLATE, responseCode, responsePhrase, headers, entity), (Object[])new Object[0]);
    }

    private static String charset(MediaType mt) {
        return Optional.ofNullable((String)mt.getParameters().get("charset")).orElse("UTF-8");
    }

    private static byte[] toByteArray(InputStream original) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((len = original.read(buf)) > -1) {
            baos.write(buf, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }
}

