/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.typesafe.impl.json.GraphQlClientValueException;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;

class JsonNumberReader
extends Reader<JsonNumber> {
    JsonNumberReader(TypeInfo type, Location location, JsonNumber value) {
        super(type, location, value);
    }

    @Override
    Object read() {
        try {
            return this.read(this.location, (JsonNumber)this.value, this.type.getRawType());
        }
        catch (ArithmeticException e) {
            throw new GraphQlClientValueException(this.location, this.value, e);
        }
    }

    private Object read(Location location, JsonNumber value, Class<?> rawType) {
        if (Byte.TYPE.equals(rawType) || Byte.class.equals(rawType)) {
            return (byte)this.readIntBetween(location, value, -128, 127);
        }
        if (Character.TYPE.equals(rawType) || Character.class.equals(rawType)) {
            return Character.valueOf((char)this.readIntBetween(location, value, 0, 65535));
        }
        if (Short.TYPE.equals(rawType) || Short.class.equals(rawType)) {
            return (short)this.readIntBetween(location, value, Short.MIN_VALUE, Short.MAX_VALUE);
        }
        if (Integer.TYPE.equals(rawType) || Integer.class.equals(rawType)) {
            return value.intValueExact();
        }
        if (Long.TYPE.equals(rawType) || Long.class.equals(rawType)) {
            return value.longValueExact();
        }
        if (Float.TYPE.equals(rawType) || Float.class.equals(rawType)) {
            return Float.valueOf((float)value.doubleValue());
        }
        if (Double.TYPE.equals(rawType) || Double.class.equals(rawType)) {
            return value.doubleValue();
        }
        if (BigInteger.class.equals(rawType)) {
            return value.bigIntegerValueExact();
        }
        if (BigDecimal.class.equals(rawType)) {
            return value.bigDecimalValue();
        }
        throw new GraphQlClientValueException(location, value);
    }

    private int readIntBetween(Location location, JsonNumber value, int minValue, int maxValue) {
        int intValue = value.intValueExact();
        GraphQlClientValueException.check(location, value, intValue >= minValue);
        GraphQlClientValueException.check(location, value, intValue <= maxValue);
        return intValue;
    }
}

