/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class IdToObjectMap {
    private static final TraceComponent tc = SibTr.register(IdToObjectMap.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private HashMap map = new HashMap();
    private IntegerKey captiveComparitorKey = new IntegerKey(0);

    public void put(int key, Object value) throws SIErrorException {
        IntegerKey intKey;
        Object oldValue;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("key: " + key + "value: " + value));
        }
        if ((oldValue = this.map.put(intKey = new IntegerKey(key), value)) != null) {
            this.map.put(intKey, oldValue);
            throw new SIErrorException(nls.getFormattedMessage("KEY_IN_USE_SICO2058", new Object[]{"" + key}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    public Object get(int key) throws SIErrorException {
        Object retObject;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("key: " + key));
        }
        this.captiveComparitorKey.setValue(key);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("captiveComparitorKey: " + this.captiveComparitorKey));
        }
        if ((retObject = this.map.get(this.captiveComparitorKey)) == null) {
            throw new SIErrorException(nls.getFormattedMessage("NO_SUCH_KEY_SICO2059", new Object[]{"" + key}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get");
        }
        return retObject;
    }

    public Object remove(int key) throws SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)("" + key));
        }
        this.captiveComparitorKey.setValue(key);
        Object retObject = this.map.remove(this.captiveComparitorKey);
        if (retObject == null) {
            throw new SIErrorException(nls.getFormattedMessage("NO_SUCH_KEY_SICO2059", new Object[]{"" + key}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
        return retObject;
    }

    public Iterator iterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"iterator");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"iterator");
        }
        return this.map.values().iterator();
    }

    public String toString() {
        Collection values = this.map.values();
        Iterator i = values.iterator();
        StringBuffer retValue = new StringBuffer("");
        while (i.hasNext()) {
            retValue.append(i.next().toString() + "\n");
        }
        return retValue.toString();
    }

    public boolean containsKey(int id) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)("" + id));
        }
        this.captiveComparitorKey.setValue(id);
        boolean result = this.map.containsKey(this.captiveComparitorKey);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", (Object)("" + result));
        }
        return result;
    }

    private class IntegerKey {
        private int integer;

        public IntegerKey(int integer) {
            this.integer = integer;
        }

        public boolean equals(Object obj) {
            boolean returnValue = false;
            if (obj instanceof IntegerKey) {
                returnValue = ((IntegerKey)obj).integer == this.integer;
            }
            return returnValue;
        }

        public int hashCode() {
            return this.integer;
        }

        public void setValue(int value) {
            this.integer = value;
        }
    }
}

