/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.StoppableThread;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.StoppableThreadCache;
import com.ibm.ws.sib.utils.ras.SibTr;

class DeletePubSubMsgsThread
implements Runnable,
StoppableThread {
    private static final TraceComponent tc = SibTr.register(DestinationManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc_cwsik = SibTr.register(new Object(){}.getClass(), (String)"SIBProcessor", (String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private final MessageProcessor messageProcessor;
    private volatile boolean hasToStop = false;

    DeletePubSubMsgsThread(MessageProcessor mp) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DeletePubSubMsgsThread", (Object)new Object[]{mp});
        }
        this.messageProcessor = mp;
        this.messageProcessor.getStoppableThreadCache().registerThread(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DeletePubSubMsgsThread", (Object)this);
        }
    }

    public boolean HasToStop() {
        return this.hasToStop;
    }

    @Override
    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"run");
        }
        DestinationManager destinationManager = this.messageProcessor.getDestinationManager();
        DestinationTypeFilter destFilter = new DestinationTypeFilter();
        destFilter.QUEUE = Boolean.FALSE;
        DestinationIndex destinationIndex = destinationManager.getDestinationIndex();
        SIMPIterator itr = destinationIndex.iterator(destFilter);
        while (itr.hasNext() && !this.HasToStop()) {
            BaseDestinationHandler dh = (BaseDestinationHandler)itr.next();
            if (!dh.isPubSub() || dh.isCorruptOrIndoubt() || dh.isDeleted() || dh.isTemporary()) continue;
            dh.deleteMsgsWithNoReferences();
        }
        itr.finished();
        if (this.messageProcessor.getStoppableThreadCache().getThreads().contains(this)) {
            this.messageProcessor.getStoppableThreadCache().deregisterThread(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"run");
        }
    }

    @Override
    public void stopThread(StoppableThreadCache cache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopThread");
        }
        this.hasToStop = true;
        cache.deregisterThread(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopThread");
        }
    }
}

