/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.jaxrs.impl.FeatureContextImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ConfigurableImpl<C extends Configurable<C>>
implements Configurable<C>,
AutoCloseable {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurableImpl.class);
    private static final Class<?>[] RESTRICTED_CLASSES_IN_SERVER = new Class[]{ClientRequestFilter.class, ClientResponseFilter.class};
    private static final Class<?>[] RESTRICTED_CLASSES_IN_CLIENT = new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class};
    private ConfigurationImpl config;
    private final C configurable;
    private final ClassLoader classLoader;
    private final Class<?>[] restrictedContractTypes;
    private final Collection<Object> instantiatorInstances;
    private volatile Instantiator instantiator;
    static final long serialVersionUID = 7594531559253121950L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, RuntimeType rt) {
        this(configurable, new ConfigurationImpl(rt));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, rt});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, Configuration config) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, config});
        }
        this.instantiatorInstances = new ArrayList<Object>();
        this.configurable = configurable;
        this.config = config instanceof ConfigurationImpl ? (ConfigurationImpl)config : new ConfigurationImpl(config);
        this.classLoader = this.getContextClassLoader();
        Class<?>[] classArray = this.restrictedContractTypes = RuntimeType.CLIENT.equals((Object)config.getRuntimeType()) ? RESTRICTED_CLASSES_IN_CLIENT : RESTRICTED_CLASSES_IN_SERVER;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, RuntimeType rt, Class<?>[] supportedProviderClasses) {
        this(configurable, rt);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, rt, supportedProviderClasses});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ConfigurableImpl(C configurable, Class<?>[] supportedProviderClasses, Configuration config) {
        this(configurable, config);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", new Object[]{configurable, supportedProviderClasses, config});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static Class<?>[] getImplementedContracts(Object provider, Class<?>[] restrictedClasses) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getImplementedContracts", new Object[]{provider, restrictedClasses});
        }
        Class<?> providerClass = provider instanceof Class ? (Class<?>)provider : provider.getClass();
        Set<Class<?>> interfaces = ConfigurableImpl.collectAllInterfaces(providerClass);
        List<Class> implementedContracts = interfaces.stream().filter(el -> Arrays.stream(restrictedClasses).noneMatch(el::equals)).collect(Collectors.toList());
        Class[] classArray = implementedContracts.toArray(new Class[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classArray = classArray;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getImplementedContracts", classArray);
        }
        return classArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Set<Class<?>> collectAllInterfaces(Class<?> providerClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectAllInterfaces", new Object[]{providerClass});
        }
        HashSet interfaces = new HashSet();
        do {
            for (Class<?> anInterface : providerClass.getInterfaces()) {
                ConfigurableImpl.collectInterfaces(interfaces, anInterface);
            }
        } while ((providerClass = providerClass.getSuperclass()) != null && providerClass != Object.class);
        HashSet hashSet = interfaces;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectAllInterfaces", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void collectInterfaces(Set<Class<?>> interfaces, Class<?> anInterface) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectInterfaces", new Object[]{interfaces, anInterface});
        }
        interfaces.add(anInterface);
        for (Class<?> superInterface : anInterface.getInterfaces()) {
            ConfigurableImpl.collectInterfaces(interfaces, superInterface);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "collectInterfaces");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected C getConfigurable() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfigurable", new Object[0]);
        }
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfigurable", c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "close", new Object[0]);
        }
        Collection<Object> collection = this.instantiatorInstances;
        synchronized (collection) {
            block7: {
                if (!this.instantiatorInstances.isEmpty()) break block7;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "close");
                }
                return;
            }
            this.instantiatorInstances.forEach(this.instantiator::release);
            this.instantiatorInstances.clear();
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Configuration getConfiguration() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfiguration", new Object[0]);
        }
        ConfigurationImpl configurationImpl = this.config;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            configurationImpl = configurationImpl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getConfiguration", configurationImpl);
        }
        return configurationImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C property(String name, Object value) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "property", new Object[]{name, value});
        }
        this.config.setProperty(name, value);
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "property", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider});
        }
        C c = this.register(provider, AnnotationUtils.getBindingPriority(provider.getClass()));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, int bindingPriority) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, bindingPriority});
        }
        if (Instantiator.class.isInstance(provider)) {
            ConfigurableImpl configurableImpl = this;
            synchronized (configurableImpl) {
                this.instantiator = (Instantiator)Instantiator.class.cast(provider);
            }
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
            }
            return c;
        }
        C c = this.doRegister(provider, bindingPriority, ConfigurableImpl.getImplementedContracts(provider, this.restrictedContractTypes));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, contracts});
        }
        C c = this.doRegister(provider, 5000, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{provider, contracts});
        }
        C c = this.doRegister(provider, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass});
        }
        C c = this.register(providerClass, AnnotationUtils.getBindingPriority(providerClass));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, int bindingPriority) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, bindingPriority});
        }
        C c = this.doRegister(this.createProvider(providerClass), bindingPriority, ConfigurableImpl.getImplementedContracts(providerClass, this.restrictedContractTypes));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, contracts});
        }
        C c = this.doRegister(providerClass, 5000, contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public C register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", new Object[]{providerClass, contracts});
        }
        C c = this.register(this.createProvider(providerClass), contracts);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "register", c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Instantiator getInstantiator() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", new Object[0]);
        }
        if (this.instantiator != null) {
            Instantiator instantiator = this.instantiator;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                instantiator = instantiator;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", instantiator);
            }
            return instantiator;
        }
        ConfigurableImpl configurableImpl = this;
        synchronized (configurableImpl) {
            if (this.instantiator != null) {
                Instantiator instantiator = this.instantiator;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    instantiator = instantiator;
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", instantiator);
                }
                return instantiator;
            }
            Iterator<Instantiator> instantiators = ServiceLoader.load(Instantiator.class, this.classLoader).iterator();
            this.instantiator = instantiators.hasNext() ? instantiators.next() : ConfigurationImpl::createProvider;
        }
        Instantiator instantiator = this.instantiator;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            instantiator = instantiator;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getInstantiator", instantiator);
        }
        return instantiator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ClassLoader getContextClassLoader() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getContextClassLoader", new Object[0]);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                static final long serialVersionUID = 5917786441619425933L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ClassLoader run() {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    return loader != null ? loader : ClassLoader.getSystemClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.impl.ConfigurableImpl$1", 1.class, null, null);
                }
            });
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                classLoader = classLoader;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getContextClassLoader", classLoader);
            }
            return classLoader;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = loader != null ? loader : ClassLoader.getSystemClassLoader();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "getContextClassLoader", classLoader);
        }
        return classLoader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private C doRegister(Object provider, int bindingPriority, Class<?> ... contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", new Object[]{provider, bindingPriority, contracts});
        }
        if (contracts == null || contracts.length == 0) {
            LOG.warning("Null, empty or invalid contracts specified for " + provider + "; ignoring.");
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
            }
            return c;
        }
        C c = this.doRegister(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private C doRegister(Object provider, Map<Class<?>, Integer> contracts) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", new Object[]{provider, contracts});
        }
        if (!this.checkConstraints(provider)) {
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
            }
            return c;
        }
        if (provider instanceof Feature) {
            Feature feature = (Feature)provider;
            boolean enabled = feature.configure((FeatureContext)new FeatureContextImpl(this));
            this.config.setFeature(feature, enabled);
            C c = this.configurable;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                c = c;
                LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
            }
            return c;
        }
        this.config.register(provider, contracts);
        C c = this.configurable;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            c = c;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "doRegister", c);
        }
        return c;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean checkConstraints(Object provider) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", new Object[]{provider});
        }
        Class<?> providerClass = provider.getClass();
        ConstrainedTo providerConstraint = providerClass.getAnnotation(ConstrainedTo.class);
        if (providerConstraint != null) {
            Class<?>[] restrictedInterfaces;
            RuntimeType currentRuntime = this.config.getRuntimeType();
            RuntimeType providerRuntime = providerConstraint.value();
            if (!providerRuntime.equals((Object)currentRuntime)) {
                LOG.warning("Provider " + provider + " cannot be registered in this " + currentRuntime + " runtime because it is constrained to " + providerRuntime + " runtimes.");
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", bl);
                }
                return bl;
            }
            for (Class<?> restrictedContract : restrictedInterfaces = RuntimeType.CLIENT.equals((Object)providerRuntime) ? RESTRICTED_CLASSES_IN_CLIENT : RESTRICTED_CLASSES_IN_SERVER) {
                if (!restrictedContract.isAssignableFrom(providerClass)) continue;
                RuntimeType opposite = RuntimeType.CLIENT.equals((Object)providerRuntime) ? RuntimeType.SERVER : RuntimeType.CLIENT;
                LOG.warning("Provider " + providerClass.getName() + " is invalid - it is constrained to " + providerRuntime + " runtimes but implements a " + opposite + " interface ");
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", bl);
                }
                return bl;
            }
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "checkConstraints", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object createProvider(Class<?> providerClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "createProvider", new Object[]{providerClass});
        }
        Object instance = this.getInstantiator().create(providerClass);
        Collection<Object> collection = this.instantiatorInstances;
        synchronized (collection) {
            this.instantiatorInstances.add(instance);
        }
        Object object = instance;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxrs.impl.ConfigurableImpl", "createProvider", object);
        }
        return object;
    }

    public static interface Instantiator {
        public <T> Object create(Class<T> var1);

        default public void release(Object instance) {
        }
    }
}

