/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.internal.connpool;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.connectionpool.monitor.metrics.ConnectionPoolMetricAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.context.Context;
import java.time.Duration;
import java.util.Arrays;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ConnectionPoolMetricAdapter.class}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class MPTelemetryConnectionPoolMetricsAdapterImpl
implements ConnectionPoolMetricAdapter {
    private static final TraceComponent tc = Tr.register(MPTelemetryConnectionPoolMetricsAdapterImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final String INSTR_SCOPE = "io.openliberty.monitor.metrics";
    private static final double NANO_CONVERSION = 1.0E-9;
    static final long serialVersionUID = -2192444937323911790L;

    public void updateHistogramMetric(String metricName, String description, String poolName, Duration duration) {
        OpenTelemetry otelInstance = OpenTelemetryAccessor.getOpenTelemetryInfo().getOpenTelemetry();
        if (otelInstance == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)String.format("Unable to resolve an OpenTelemetry instance for the ConnectionPool [%s]", poolName), (Object[])new Object[0]);
            }
            return;
        }
        Double[] bucketBoundaries = new Double[]{0.001, 0.005, 0.01, 0.05, 0.1, 0.5, 1.0, 5.0, 10.0};
        DoubleHistogram dHistogram = otelInstance.getMeterProvider().get(INSTR_SCOPE).histogramBuilder(metricName).setUnit("s").setDescription(description).setExplicitBucketBoundariesAdvice(Arrays.asList(bucketBoundaries)).build();
        Context ctx = Context.current();
        double seconds = (double)duration.toNanos() * 1.0E-9;
        dHistogram.record(seconds, Attributes.builder().put("io.openliberty.datasource.name", poolName).build(), ctx);
    }

    public void updateWaitTimeMetrics(String poolName, Duration duration) {
        this.updateHistogramMetric("io.openliberty.connection_pool.connection.wait_time", Tr.formatMessage((TraceComponent)tc, (String)"connectionpool.connection.useTime.description", (Object[])new Object[0]), poolName, duration);
    }

    public void updateInUseTimeMetrics(String poolName, Duration duration) {
        this.updateHistogramMetric("io.openliberty.connection_pool.connection.use_time", Tr.formatMessage((TraceComponent)tc, (String)"connectionpool.connection.waitTime.description", (Object[])new Object[0]), poolName, duration);
    }
}

