/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.artifact.proxy.BatchletProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.controller.impl.SingleThreadedStepControllerImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Batchlet;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class BatchletStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = BatchletStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private BatchletProxy batchletProxy;
    static final long serialVersionUID = -6876556096391980894L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchletStepControllerImpl(RuntimeWorkUnitExecution runtimeWorkUnitExecution, Step step) {
        super(runtimeWorkUnitExecution, step);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl", "<init>", new Object[]{runtimeWorkUnitExecution, step});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void invokeBatchlet(Batchlet batchlet) throws BatchContainerServiceException {
        String batchletId = batchlet.getRef();
        List<Property> propList = batchlet.getProperties() == null ? null : batchlet.getProperties().getPropertyList();
        String sourceMethod = "invokeBatchlet";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod, batchletId);
        }
        InjectionReferences injectionRef = new InjectionReferences(this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.runtimeStepExecution, propList);
        try {
            this.batchletProxy = ProxyFactory.createBatchletProxy(batchletId, injectionRef, this.runtimeStepExecution);
        }
        catch (ArtifactValidationException artifactValidationException) {
            void e;
            FFDCFilter.processException((Throwable)artifactValidationException, (String)"com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl", (String)"62", (Object)this, (Object[])new Object[]{batchlet});
            throw new BatchContainerServiceException("Cannot create the batchlet [" + batchletId + "]", (Throwable)e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Batchlet is loaded and validated: " + this.batchletProxy);
        }
        if (this.wasStopIssuedOnJob()) {
            logger.fine("Exit without executing batchlet since stop() request has been received.");
        } else {
            logger.fine("Starting process() for the Batchlet Artifact");
            String processRetVal = this.batchletProxy.process();
            logger.fine("Set process() return value = " + processRetVal + " for possible use as exitStatus");
            this.runtimeStepExecution.setBatchletProcessRetVal(processRetVal);
            logger.exiting(sourceClass, sourceMethod, processRetVal == null ? "<null>" : processRetVal);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void invokeCoreStep() throws BatchContainerServiceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl", "invokeCoreStep", new Object[0]);
        }
        try {
            this.invokeBatchlet(this.getStep().getBatchlet());
        }
        finally {
            this.invokeCollectorIfPresent();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl", "invokeCoreStep");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl", "stop", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            if (this.isStepStartingOrStarted()) {
                this.markStepStopping();
                if (this.batchletProxy != null) {
                    this.batchletProxy.stop();
                }
            } else {
                logger.fine("Ignoring stop, since step not in a state which has a valid status (might not be far enough along to have a state yet)");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.BatchletStepControllerImpl", "stop");
        }
    }
}

