/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.application.ResourceDependency;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.application.StateManagerImpl;
import org.apache.myfaces.component.ComponentResourceContainer;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.lifecycle.DefaultRestoreViewSupport;
import org.apache.myfaces.lifecycle.RestoreViewSupport;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.view.facelets.ELExpressionCacheMode;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.pool.ViewEntry;
import org.apache.myfaces.view.facelets.pool.ViewPool;
import org.apache.myfaces.view.facelets.pool.ViewPoolFactory;
import org.apache.myfaces.view.facelets.pool.ViewStructureMetadata;
import org.apache.myfaces.view.facelets.pool.impl.ViewPoolFactoryImpl;
import org.apache.myfaces.view.facelets.tag.jsf.FaceletState;

public class ViewPoolProcessor {
    private static final String INSTANCE = "oam.ViewPoolProcessor";
    public static final String ENABLE_VIEW_POOL = "oamEnableViewPool";
    public static final String FORCE_HARD_RESET = "oam.ViewPool.forceHardReset";
    public static final String DISPOSE_VIEW_NAVIGATION = "oam.ViewPool.disposeViewOnNavigation";
    public static final String RESET_SAVE_STATE_MODE_KEY = "oam.view.resetSaveStateMode";
    public static final int RESET_MODE_OFF = 0;
    public static final int RESET_MODE_SOFT = 1;
    public static final int RESET_MODE_HARD = 2;
    public static final String INVOKE_DEFERRED_NAVIGATION = "oam.invoke.navigation";
    private ViewPoolFactory viewPoolFactory;
    private RestoreViewSupport restoreViewSupport;
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = StateManagerImpl.class.getName() + ".SERIALIZED_VIEW";

    public ViewPoolProcessor(FacesContext context) {
        this.viewPoolFactory = new ViewPoolFactoryImpl(context);
        this.restoreViewSupport = new DefaultRestoreViewSupport(context);
    }

    public static ViewPoolProcessor getInstance(FacesContext context) {
        return (ViewPoolProcessor)context.getExternalContext().getApplicationMap().get(INSTANCE);
    }

    public static void initialize(FacesContext context) {
        if (context.isProjectStage(ProjectStage.Production)) {
            long refreshPeriod;
            boolean initialize = true;
            String elMode = WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), "org.apache.myfaces.CACHE_EL_EXPRESSIONS", ELExpressionCacheMode.noCache.name());
            if (!elMode.equals(ELExpressionCacheMode.alwaysRecompile.name())) {
                Logger.getLogger(ViewPoolProcessor.class.getName()).log(Level.INFO, "org.apache.myfaces.CACHE_EL_EXPRESSIONS web config parameter is set to \"" + (elMode == null ? "none" : elMode) + "\". To enable view pooling this param must be set to \"alwaysRecompile\". View Pooling disabled.");
                initialize = false;
            }
            if ((refreshPeriod = WebConfigParamUtils.getLongInitParameter(context.getExternalContext(), FaceletViewDeclarationLanguage.PARAMS_REFRESH_PERIOD, -1L)) != -1L) {
                Logger.getLogger(ViewPoolProcessor.class.getName()).log(Level.INFO, "javax.faces.FACELETS_REFRESH_PERIOD web config parameter is set to \"" + Long.toString(refreshPeriod) + "\". To enable view pooling this param must be set to \"-1\". View Pooling disabled.");
                initialize = false;
            }
            if (MyfacesConfig.getCurrentInstance((ExternalContext)context.getExternalContext()).isStrictJsf2FaceletsCompatibility()) {
                Logger.getLogger(ViewPoolProcessor.class.getName()).log(Level.INFO, "org.apache.myfaces.STRICT_JSF_2_FACELETS_COMPATIBILITY web config parameter is set to \"true\". To enable view pooling this param  must be set to \"false\". View Pooling disabled.");
                initialize = false;
            }
            if (initialize) {
                ViewPoolProcessor processor = new ViewPoolProcessor(context);
                context.getExternalContext().getApplicationMap().put(INSTANCE, processor);
            }
        }
    }

    public ViewPool getViewPool(FacesContext context, UIViewRoot root) {
        if (root.isTransient()) {
            return null;
        }
        Boolean enableViewPool = (Boolean)root.getAttributes().get(ENABLE_VIEW_POOL);
        if (enableViewPool != null && !Boolean.TRUE.equals(enableViewPool)) {
            return null;
        }
        return this.viewPoolFactory.getViewPool(context, root);
    }

    public boolean isViewPoolEnabledForThisView(FacesContext context, UIViewRoot root) {
        if (root == null || root.isTransient()) {
            return false;
        }
        Boolean enableViewPool = (Boolean)root.getAttributes().get(ENABLE_VIEW_POOL);
        if (enableViewPool != null) {
            return Boolean.TRUE.equals(enableViewPool);
        }
        ViewPool viewPool = this.getViewPool(context, root);
        return viewPool != null;
    }

    public boolean isViewPoolStrategyAllowedForThisView(FacesContext context, UIViewRoot root) {
        if (root.getViewId() == null) {
            return false;
        }
        if (root.isTransient()) {
            return false;
        }
        if (!this.isViewPoolEnabledForThisView(context, root)) {
            return false;
        }
        ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, root.getViewId());
        if (vdl == null) {
            return false;
        }
        if (!"java.faces.Facelets".equals(vdl.getId())) {
            return false;
        }
        return vdl.getStateManagementStrategy(context, root.getViewId()) != null;
    }

    public void setViewPoolDisabledOnThisView(FacesContext context, UIViewRoot root, boolean value) {
        root.getAttributes().put(ENABLE_VIEW_POOL, !value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneAndRestoreView(FacesContext context, UIViewRoot newView, ViewEntry entry, ViewStructureMetadata metadata) {
        Map viewScopeMap;
        UIViewRoot oldView = entry.getViewRoot();
        Object viewState = metadata.getViewRootState();
        UIComponent metadataFacet = newView.getFacet("javax_faces_metadata");
        if (viewState == null) {
            oldView.clearInitialState();
            viewState = oldView.saveState(context);
        }
        Object newViewState = (viewScopeMap = newView.getViewMap(false)) != null && !viewScopeMap.isEmpty() ? newView.saveState(context) : null;
        boolean oldProcessingEvents = context.isProcessingEvents();
        context.setProcessingEvents(false);
        try {
            RequestViewContext rcv;
            if (oldView.getFacetCount() > 0) {
                ArrayList facetKeys = new ArrayList();
                facetKeys.addAll(oldView.getFacets().keySet());
                for (String string : facetKeys) {
                    if (metadataFacet != null && "javax_faces_metadata".equals(string) && !PhaseId.RESTORE_VIEW.equals(context.getCurrentPhaseId())) {
                        newView.getFacets().put(string, metadataFacet);
                        continue;
                    }
                    UIComponent facet = (UIComponent)oldView.getFacets().remove(string);
                    newView.getFacets().put(string, facet);
                }
            }
            if (oldView.getChildCount() > 0) {
                Iterator it = oldView.getChildren().iterator();
                while (it.hasNext()) {
                    UIComponent c = (UIComponent)it.next();
                    it.remove();
                    newView.getChildren().add(c);
                }
            }
            newView.restoreState(context, viewState);
            newView.markInitialState();
            if (!PhaseId.RESTORE_VIEW.equals(context.getCurrentPhaseId())) {
                this.restoreViewSupport.processComponentBinding(context, (UIComponent)newView);
                if (viewScopeMap != null && !viewScopeMap.isEmpty()) {
                    Map newViewScopeMap = newView.getViewMap(false);
                    if (newViewScopeMap == null) {
                        newView.restoreViewScopeState(context, newViewState);
                    } else {
                        for (Map.Entry entry2 : viewScopeMap.entrySet()) {
                            newViewScopeMap.put(entry2.getKey(), entry2.getValue());
                        }
                    }
                }
            }
            if ((rcv = RequestViewContext.getCurrentInstance(context, newView, false)) != null) {
                rcv.setRequestViewMetadata(metadata.getRequestViewMetadata().cloneInstance());
            } else {
                RequestViewContext.setCurrentInstance(context, newView, RequestViewContext.newInstance(metadata.getRequestViewMetadata().cloneInstance()));
            }
        }
        finally {
            context.setProcessingEvents(oldProcessingEvents);
        }
    }

    public void storeViewStructureMetadata(FacesContext context, UIViewRoot root) {
        ViewPool viewPool = this.getViewPool(context, root);
        if (viewPool != null) {
            boolean isDynamic;
            FaceletState faceletState = (FaceletState)root.getAttributes().get("oam.FACELET_STATE_INSTANCE");
            boolean bl = isDynamic = faceletState != null ? faceletState.isDynamic() : false;
            if (!isDynamic) {
                viewPool.storeStaticViewStructureMetadata(context, root, faceletState);
            } else {
                viewPool.storeDynamicViewStructureMetadata(context, root, faceletState);
            }
        }
    }

    public ViewStructureMetadata retrieveViewStructureMetadata(FacesContext context, UIViewRoot root) {
        ViewPool viewPool = this.getViewPool(context, root);
        if (viewPool != null) {
            boolean isDynamic;
            FaceletState faceletState = (FaceletState)root.getAttributes().get("oam.FACELET_STATE_INSTANCE");
            boolean bl = isDynamic = faceletState != null ? faceletState.isDynamic() : false;
            if (!isDynamic) {
                return viewPool.retrieveStaticViewStructureMetadata(context, root);
            }
            return viewPool.retrieveDynamicViewStructureMetadata(context, root, faceletState);
        }
        return null;
    }

    public void pushResetableView(FacesContext context, UIViewRoot view, FaceletState faceletViewState) {
        ViewPool viewPool = this.getViewPool(context, view);
        if (viewPool != null) {
            boolean isDynamic;
            boolean bl = isDynamic = faceletViewState != null ? faceletViewState.isDynamic() : false;
            if (!isDynamic) {
                this.clearTransientAndNonFaceletComponentsForStaticView(context, view);
                viewPool.pushStaticStructureView(context, view);
            } else {
                ViewStructureMetadata viewStructureMetadata = viewPool.retrieveDynamicViewStructureMetadata(context, view, faceletViewState);
                if (viewStructureMetadata != null) {
                    this.clearTransientAndNonFaceletComponentsForDynamicView(context, view, viewStructureMetadata);
                    viewPool.pushDynamicStructureView(context, view, faceletViewState);
                }
            }
        }
    }

    public void pushPartialView(FacesContext context, UIViewRoot view, FaceletState faceletViewState, int count) {
        ViewPool viewPool = this.getViewPool(context, view);
        if (viewPool != null && viewPool.isWorthToRecycleThisView(context, view)) {
            ViewStructureMetadata viewStructureMetadata = null;
            viewStructureMetadata = faceletViewState == null ? viewPool.retrieveStaticViewStructureMetadata(context, view) : viewPool.retrieveDynamicViewStructureMetadata(context, view, faceletViewState);
            if (viewStructureMetadata != null) {
                ClearPartialTreeContext ptc = new ClearPartialTreeContext();
                this.clearTransientAndRemoveNonResetableComponents(context, ptc, view, viewStructureMetadata);
                int reusableCount = ptc.getCount();
                float factor = (float)reusableCount / (float)count;
                if (factor > 0.3f) {
                    viewPool.pushPartialStructureView(context, view);
                }
            }
        }
    }

    protected void clearTransientAndNonFaceletComponentsForStaticView(FacesContext context, UIViewRoot root) {
        this.clearTransientAndNonFaceletComponents(context, (UIComponent)root);
    }

    public void clearTransientAndNonFaceletComponentsForDynamicView(FacesContext context, UIViewRoot root, ViewStructureMetadata viewStructureMetadata) {
        int childCount = root.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)root.getChildren().get(i);
                if (child != null && child.isTransient() && child.getAttributes().get("oam.vf.MARK_ID") == null) {
                    root.getChildren().remove(i);
                    --i;
                    --childCount;
                    continue;
                }
                if (child.getChildCount() <= 0 && child.getFacets().isEmpty()) continue;
                this.clearTransientAndNonFaceletComponents(context, child);
            }
        }
        this.clearTransientAndNonFaceletComponentsForDynamicViewUIViewRootFacets(context, root, viewStructureMetadata);
    }

    private void clearTransientAndNonFaceletComponentsForDynamicViewUIViewRootFacets(FacesContext context, UIViewRoot root, ViewStructureMetadata viewStructureMetadata) {
        if (root.getFacetCount() > 0) {
            Map facets = root.getFacets();
            Iterator itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (fc != null && !(fc instanceof ComponentResourceContainer)) {
                    if (fc.isTransient() && fc.getAttributes().get("oam.vf.MARK_ID") == null) {
                        itr.remove();
                        continue;
                    }
                    if (fc.getChildCount() <= 0 && fc.getFacets().isEmpty()) continue;
                    this.clearTransientAndNonFaceletComponents(context, fc);
                    continue;
                }
                if (fc == null || fc.getId() == null || !fc.getId().startsWith("javax_faces_location_")) continue;
                String target = fc.getId().substring("javax_faces_location_".length());
                Map<String, List<ResourceDependency>> addedResources = viewStructureMetadata.getRequestViewMetadata().getResourceDependencyAnnotations(context);
                List<ResourceDependency> resourceDependencyList = addedResources != null ? addedResources.get(target) : null;
                this.clearComponentResourceContainer(context, fc, resourceDependencyList);
            }
        }
    }

    private void clearComponentResourceContainer(FacesContext context, UIComponent component, List<ResourceDependency> resourceDependencyList) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                String id = (String)child.getAttributes().get("oam.vf.MARK_ID");
                if (child != null && child.isTransient() && id == null) {
                    component.getChildren().remove(i);
                    --i;
                    --childCount;
                    continue;
                }
                if (id != null) continue;
                Object[] rdk = (Object[])child.getAttributes().get("oam.component.resource.RDK");
                if (rdk != null) {
                    boolean found = false;
                    String library = (String)rdk[0];
                    String name = (String)rdk[1];
                    if (resourceDependencyList != null) {
                        for (ResourceDependency resource : resourceDependencyList) {
                            if (library == null && resource.library() == null) {
                                if (name == null || !name.equals(resource.name())) continue;
                                found = true;
                                break;
                            }
                            if (library == null || !library.equals(resource.library()) || name == null || !name.equals(resource.name())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    component.getChildren().remove(i);
                    --i;
                    --childCount;
                    continue;
                }
                if (child.getChildCount() <= 0 && child.getFacets().isEmpty()) continue;
                this.clearTransientAndNonFaceletComponents(context, child);
            }
        }
    }

    private void clearTransientAndNonFaceletComponents(FacesContext context, UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                if (child != null && child.isTransient() && child.getAttributes().get("oam.vf.MARK_ID") == null) {
                    component.getChildren().remove(i);
                    --i;
                    --childCount;
                    continue;
                }
                if (child.getChildCount() <= 0 && child.getFacets().isEmpty()) continue;
                this.clearTransientAndNonFaceletComponents(context, child);
            }
        }
        if (component.getFacetCount() > 0) {
            Map facets = component.getFacets();
            Iterator itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                if (fc != null && fc.isTransient() && fc.getAttributes().get("oam.vf.MARK_ID") == null) {
                    itr.remove();
                    continue;
                }
                if (fc.getChildCount() <= 0 && fc.getFacets().isEmpty()) continue;
                this.clearTransientAndNonFaceletComponents(context, fc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTransientAndRemoveNonResetableComponents(FacesContext context, ClearPartialTreeContext ptc, UIViewRoot root, ViewStructureMetadata viewStructureMetadata) {
        int childCount = root.getChildCount();
        try {
            root.getAttributes().put(RESET_SAVE_STATE_MODE_KEY, 2);
            if (childCount > 0) {
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)root.getChildren().get(i);
                    boolean containsFaceletId = child.getAttributes().containsKey("oam.vf.MARK_ID");
                    if (child != null && child.isTransient() && !containsFaceletId) {
                        root.getChildren().remove(i);
                        --i;
                        --childCount;
                        continue;
                    }
                    if (child.getAttributes().containsKey("oam.vf.addedByHandler")) {
                        root.getChildren().remove(i);
                        --i;
                        --childCount;
                        continue;
                    }
                    if (containsFaceletId || child.getAttributes().containsKey("oam.vf.addedByHandler")) {
                        if (!child.isTransient()) {
                            Object state = child.saveState(context);
                            if (state == null) {
                                if (child.getChildCount() > 0 || !child.getFacets().isEmpty()) {
                                    this.clearTransientAndRemoveNonResetableComponents(context, ptc, child);
                                }
                                ptc.incrementCount();
                                continue;
                            }
                            root.getChildren().remove(i);
                            --i;
                            --childCount;
                            continue;
                        }
                        ptc.incrementCount();
                        continue;
                    }
                    root.getChildren().remove(i);
                    --i;
                    --childCount;
                }
            }
            this.clearTransientAndNonFaceletComponentsForDynamicViewUIViewRootFacets(context, root, viewStructureMetadata);
        }
        finally {
            root.getAttributes().put(RESET_SAVE_STATE_MODE_KEY, 0);
        }
    }

    private void clearTransientAndRemoveNonResetableComponents(FacesContext context, ClearPartialTreeContext ptc, UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                boolean containsFaceletId = child.getAttributes().containsKey("oam.vf.MARK_ID");
                if (child != null && child.isTransient() && !containsFaceletId) {
                    component.getChildren().remove(i);
                    --i;
                    --childCount;
                    continue;
                }
                if (child.getAttributes().containsKey("oam.vf.addedByHandler")) {
                    component.getChildren().remove(i);
                    --i;
                    --childCount;
                    continue;
                }
                if (containsFaceletId || child.getAttributes().containsKey("oam.vf.addedByHandler")) {
                    if (!child.isTransient()) {
                        Object state = child.saveState(context);
                        if (state == null) {
                            if (child.getChildCount() > 0 || !child.getFacets().isEmpty()) {
                                this.clearTransientAndRemoveNonResetableComponents(context, ptc, child);
                            }
                            ptc.incrementCount();
                            continue;
                        }
                        component.getChildren().remove(i);
                        --i;
                        --childCount;
                        continue;
                    }
                    ptc.incrementCount();
                    continue;
                }
                component.getChildren().remove(i);
                --i;
                --childCount;
            }
        }
        if (component.getFacetCount() > 0) {
            Map facets = component.getFacets();
            Iterator itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent fc = (UIComponent)itr.next();
                boolean containsFaceletId = fc.getAttributes().containsKey("oam.vf.MARK_ID");
                if (fc != null && fc.isTransient() && !containsFaceletId) {
                    itr.remove();
                    continue;
                }
                if (fc.getAttributes().containsKey("oam.vf.addedByHandler")) {
                    itr.remove();
                    continue;
                }
                if (containsFaceletId || fc.getAttributes().containsKey("oam.vf.addedByHandler")) {
                    if (!fc.isTransient()) {
                        Object state = fc.saveState(context);
                        if (state == null) {
                            if (fc.getChildCount() > 0 || !fc.getFacets().isEmpty()) {
                                this.clearTransientAndRemoveNonResetableComponents(context, ptc, fc);
                            }
                            ptc.incrementCount();
                            continue;
                        }
                        itr.remove();
                        continue;
                    }
                    ptc.incrementCount();
                    continue;
                }
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDeferredNavigation(FacesContext facesContext) {
        Object[] command = (Object[])facesContext.getAttributes().get(INVOKE_DEFERRED_NAVIGATION);
        if (command != null) {
            try {
                facesContext.getAttributes().put(DISPOSE_VIEW_NAVIGATION, Boolean.TRUE);
                NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
                if (command.length == 3) {
                    navigationHandler.handleNavigation(facesContext, (String)command[0], (String)command[1], (String)command[2]);
                } else {
                    navigationHandler.handleNavigation(facesContext, (String)command[0], (String)command[1]);
                }
                facesContext.renderResponse();
                facesContext.getAttributes().remove(INVOKE_DEFERRED_NAVIGATION);
            }
            finally {
                facesContext.getAttributes().remove(DISPOSE_VIEW_NAVIGATION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeView(FacesContext facesContext, UIViewRoot root) {
        StateManagementStrategy sms;
        ViewDeclarationLanguage vdl;
        if (root == null) {
            return;
        }
        String viewId = root.getViewId();
        if (viewId == null) {
            return;
        }
        Application app = facesContext.getApplication();
        if (app == null) {
            return;
        }
        ViewHandler viewHandler = app.getViewHandler();
        if (viewHandler == null) {
            return;
        }
        if (Boolean.TRUE.equals(facesContext.getAttributes().get(DISPOSE_VIEW_NAVIGATION)) && (vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, root.getViewId())) != null && "java.faces.Facelets".equals(vdl.getId()) && (sms = vdl.getStateManagementStrategy(facesContext, root.getId())) != null) {
            facesContext.getAttributes().put(FORCE_HARD_RESET, Boolean.TRUE);
            try {
                Object object = sms.saveView(facesContext);
            }
            finally {
                facesContext.getAttributes().remove(FORCE_HARD_RESET);
            }
            facesContext.getAttributes().remove(SERIALIZED_VIEW_REQUEST_ATTR);
        }
    }

    private static class ClearPartialTreeContext {
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        public int incrementCount() {
            return this.count++;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

