/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.server.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.security.csiv2.CommonCfg;
import com.ibm.ws.security.csiv2.server.config.tss.ServerLTPAMechConfig;
import com.ibm.ws.security.csiv2.trust.TrustedIDEvaluatorImpl;
import com.ibm.ws.security.csiv2.util.SecurityServices;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.transport.iiop.security.config.tss.OptionsKey;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechListConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSGSSUPMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTAbsent;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTAnonymous;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTDistinguishedName;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTPrincipalNameGSSUP;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTX509CertChain;
import com.ibm.ws.transport.iiop.security.config.tss.TSSNULLASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSNULLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omg.CSIIOP.TransportAddress;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServerConfigHelper
extends CommonCfg {
    private static TraceComponent tc = Tr.register(ServerConfigHelper.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.server.internal.resources.CSIv2ServerContainerMessages");
    public static final String KEY_POLICY = "serverPolicy";
    private static final String TYPE = "com.ibm.ws.security.csiv2.serverPolicyCSIV2";
    public static final String KEY_TRUSTED_IDENTITIES = "trustedIdentities";
    private final Authenticator authenticator;
    private final TokenManager tokenManager;
    private final UnauthenticatedSubjectService unauthenticatedSubjectService;
    private final String targetName;
    static final long serialVersionUID = -1795192382059217169L;

    public ServerConfigHelper(Authenticator authenticator, TokenManager tokenManager, UnauthenticatedSubjectService unauthenticatedSubjectService, String targetName, String defaultAlias) {
        super(defaultAlias);
        this.authenticator = authenticator;
        this.targetName = targetName;
        this.tokenManager = tokenManager;
        this.unauthenticatedSubjectService = unauthenticatedSubjectService;
    }

    public TSSConfig getTSSConfig(Map<String, Object> properties, Map<String, List<TransportAddress>> addrMap) throws Exception {
        TSSConfig tssConfig = new TSSConfig();
        ServerConfigHelper.printTrace((String)"IIOP Server Policy", null, (int)0);
        CommonCfg.PolicyData policyData = this.extractPolicyData(properties, KEY_POLICY, TYPE);
        if (policyData != null) {
            ServerConfigHelper.printTrace((String)"CSIV2", null, (int)1);
            TSSCompoundSecMechListConfig mechListConfig = tssConfig.getMechListConfig();
            mechListConfig.setStateful(policyData.stateful);
            ServerConfigHelper.printTrace((String)"Stateful", (Object)mechListConfig.isStateful(), (int)2);
            this.populateSecMechList(mechListConfig, policyData.layersData, addrMap);
        }
        return tssConfig;
    }

    private void populateSecMechList(TSSCompoundSecMechListConfig mechListConfig, List<CommonCfg.LayersData> layersList, Map<String, List<TransportAddress>> addrMap) throws Exception {
        for (CommonCfg.LayersData mech : layersList) {
            Map<String, TSSCompoundSecMechConfig> tssCompoundSecMechConfigs = this.extractCompoundSecMech(mech, addrMap);
            for (Map.Entry<String, TSSCompoundSecMechConfig> entry : tssCompoundSecMechConfigs.entrySet()) {
                mechListConfig.add(entry.getValue(), entry.getKey());
            }
        }
    }

    protected Map<String, TSSCompoundSecMechConfig> extractCompoundSecMech(CommonCfg.LayersData mechInfo, Map<String, List<TransportAddress>> addrMap) throws Exception {
        ServerConfigHelper.printTrace((String)"Layers", null, (int)1);
        LinkedHashMap<String, TSSCompoundSecMechConfig> compoundSecMechConfigs = new LinkedHashMap<String, TSSCompoundSecMechConfig>();
        this.setAuthenticationLayerConfig(compoundSecMechConfigs, mechInfo);
        this.setTransportLayerConfig(compoundSecMechConfigs, mechInfo, addrMap);
        this.setAttributeLayerConfig(compoundSecMechConfigs, mechInfo);
        return compoundSecMechConfigs;
    }

    private void setTransportLayerConfig(Map<String, TSSCompoundSecMechConfig> compoundSecMechConfigs, CommonCfg.LayersData mechInfo, Map<String, List<TransportAddress>> addrMap) throws SSLException {
        Object tssTransportMechConfig;
        Map transportLayerProperties = mechInfo.transportLayer;
        if (transportLayerProperties != null) {
            ServerConfigHelper.printTrace((String)"Transport Layer", null, (int)2);
            boolean sslEnabled = (Boolean)transportLayerProperties.get("sslEnabled");
            String sslAliasName = (String)transportLayerProperties.get("sslRef");
            tssTransportMechConfig = sslEnabled && !"".equals(sslAliasName) ? this.extractSSLTransport(transportLayerProperties, addrMap) : new TSSNULLTransportConfig();
        } else {
            tssTransportMechConfig = new TSSNULLTransportConfig();
        }
        Iterator<Map.Entry<String, TSSCompoundSecMechConfig>> entries = compoundSecMechConfigs.entrySet().iterator();
        while (entries.hasNext()) {
            TSSCompoundSecMechConfig compoundSecMechConfig = entries.next().getValue();
            compoundSecMechConfig.setTransport_mech((TSSTransportMechConfig)tssTransportMechConfig);
        }
    }

    private TSSTransportMechConfig extractSSLTransport(Map<String, Object> transportLayerProperties, Map<String, List<TransportAddress>> addrMap) throws SSLException {
        String sslAliasName = (String)transportLayerProperties.get("sslRef");
        if (sslAliasName == null) {
            sslAliasName = this.defaultAlias;
        }
        OptionsKey options = SecurityServices.getSSLConfig().getAssociationOptions(sslAliasName);
        TSSSSLTransportConfig transportLayerConfig = new TSSSSLTransportConfig(this.authenticator);
        transportLayerConfig.setSupports(options.supports);
        transportLayerConfig.setRequires(options.requires);
        List<TransportAddress> addresses = addrMap.get(sslAliasName);
        if (addresses == null) {
            if (addrMap.size() == 1) {
                String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_SERVER_TRANSPORT_NO_SSL_CONFIGS_IN_IIOP_ENDPOINT", (Object[])new Object[]{sslAliasName});
                throw new IllegalStateException(messageFromBundle);
            }
            String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_SERVER_TRANSPORT_MISMATCHED_SSL_CONFIG", (Object[])new Object[]{sslAliasName});
            throw new IllegalStateException(messageFromBundle);
        }
        transportLayerConfig.setTransportAddresses(addresses);
        return transportLayerConfig;
    }

    private void setAuthenticationLayerConfig(Map<String, TSSCompoundSecMechConfig> compoundSecMechConfigs, CommonCfg.LayersData mechInfo) {
        Map authenticationLayerProperties = mechInfo.authenticationLayer;
        if (authenticationLayerProperties != null) {
            ServerConfigHelper.printTrace((String)"Authentication Layer", null, (int)2);
            Map<String, TSSASMechConfig> tssasMechConfigs = this.extractASMech(authenticationLayerProperties);
            for (Map.Entry<String, TSSASMechConfig> entry : tssasMechConfigs.entrySet()) {
                TSSCompoundSecMechConfig compoundSecMechConfig = new TSSCompoundSecMechConfig();
                compoundSecMechConfig.setAs_mech(entry.getValue());
                compoundSecMechConfigs.put(entry.getKey(), compoundSecMechConfig);
            }
        } else {
            TSSCompoundSecMechConfig compoundSecMechConfig = new TSSCompoundSecMechConfig();
            compoundSecMechConfig.setAs_mech((TSSASMechConfig)new TSSNULLASMechConfig());
            compoundSecMechConfigs.put("oid:2.23.130.1.1.1", compoundSecMechConfig);
        }
    }

    private Map<String, TSSASMechConfig> extractASMech(Map<String, Object> authenticationLayerProperties) {
        LinkedHashMap<String, TSSASMechConfig> tssasMechConfigs = new LinkedHashMap<String, TSSASMechConfig>();
        ArrayList<String> configuredMechanisms = new ArrayList<String>();
        String establishTrustInClient = (String)authenticationLayerProperties.get("establishTrustInClient");
        boolean required = false;
        if ("Required".equals(establishTrustInClient)) {
            required = true;
        } else if ("Never".equals(establishTrustInClient)) {
            Tr.warning((TraceComponent)tc, (String)"CSIv2_COMMON_AUTH_LAYER_DISABLED", (Object[])new Object[]{establishTrustInClient});
            tssasMechConfigs.put("oid:2.23.130.1.1.1", (TSSASMechConfig)new TSSNULLASMechConfig());
            return tssasMechConfigs;
        }
        List mechanisms = this.getAsMechanisms(authenticationLayerProperties);
        if (mechanisms.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"CSIv2_SERVER_AUTH_MECHANISMS_NULL", (Object[])new Object[0]);
            tssasMechConfigs.put("oid:2.23.130.1.1.1", (TSSASMechConfig)new TSSNULLASMechConfig());
        } else {
            for (String mech : mechanisms) {
                if (configuredMechanisms.contains(mech.toUpperCase())) continue;
                if (mech.equalsIgnoreCase("LTPA")) {
                    tssasMechConfigs.put("oid:1.3.18.0.2.30.2", new ServerLTPAMechConfig(this.authenticator, this.tokenManager, this.targetName, required));
                } else if (mech.equalsIgnoreCase("GSSUP")) {
                    tssasMechConfigs.put("oid:2.23.130.1.1.1", (TSSASMechConfig)new TSSGSSUPMechConfig(this.authenticator, this.targetName, required));
                } else {
                    Tr.warning((TraceComponent)tc, (String)"CSIv2_SERVER_AUTH_MECHANISM_INVALID", (Object[])new Object[]{mech});
                }
                configuredMechanisms.add(mech.toUpperCase());
            }
            if (tssasMechConfigs.isEmpty()) {
                tssasMechConfigs.put("oid:2.23.130.1.1.1", (TSSASMechConfig)new TSSNULLASMechConfig());
            }
        }
        return tssasMechConfigs;
    }

    private void setAttributeLayerConfig(Map<String, TSSCompoundSecMechConfig> compoundSecMechConfigs, CommonCfg.LayersData mechInfo) {
        TSSSASMechConfig sasMechConfig = null;
        Map attributeLayerProperties = mechInfo.attributeLayer;
        if (attributeLayerProperties != null) {
            ServerConfigHelper.printTrace((String)"Attribute Layer", null, (int)2);
            sasMechConfig = this.extractSASMech(attributeLayerProperties);
        } else {
            sasMechConfig = new TSSSASMechConfig((TrustedIDEvaluator)new TrustedIDEvaluatorImpl());
            sasMechConfig.addIdentityToken((TSSSASIdentityToken)new TSSITTAbsent());
        }
        Iterator<Map.Entry<String, TSSCompoundSecMechConfig>> entries = compoundSecMechConfigs.entrySet().iterator();
        while (entries.hasNext()) {
            TSSCompoundSecMechConfig compoundSecMechConfig = entries.next().getValue();
            compoundSecMechConfig.setSas_mech(sasMechConfig);
        }
    }

    private TSSSASMechConfig extractSASMech(Map<String, Object> attributeLayerProperties) {
        boolean identityAssertionEnabled = (Boolean)attributeLayerProperties.get("identityAssertionEnabled");
        String[] identityAssertionTypes = (String[])attributeLayerProperties.get("identityAssertionTypes");
        String pipeSeparatedTrustedIdentities = (String)attributeLayerProperties.get(KEY_TRUSTED_IDENTITIES);
        TrustedIDEvaluatorImpl trustedIDEvaluator = new TrustedIDEvaluatorImpl(pipeSeparatedTrustedIdentities);
        TSSSASMechConfig sasMechConfig = new TSSSASMechConfig((TrustedIDEvaluator)trustedIDEvaluator);
        sasMechConfig.addIdentityToken((TSSSASIdentityToken)new TSSITTAbsent());
        if (identityAssertionEnabled) {
            for (String assertionType : identityAssertionTypes) {
                if ("ITTAnonymous".equals(assertionType)) {
                    sasMechConfig.addIdentityToken((TSSSASIdentityToken)new TSSITTAnonymous(this.unauthenticatedSubjectService));
                    continue;
                }
                if ("ITTPrincipalName".equals(assertionType)) {
                    sasMechConfig.addIdentityToken((TSSSASIdentityToken)new TSSITTPrincipalNameGSSUP(this.authenticator, this.targetName));
                    continue;
                }
                if ("ITTX509CertChain".equals(assertionType)) {
                    sasMechConfig.addIdentityToken((TSSSASIdentityToken)new TSSITTX509CertChain(this.authenticator));
                    continue;
                }
                if (!"ITTDistinguishedName".equals(assertionType)) continue;
                sasMechConfig.addIdentityToken((TSSSASIdentityToken)new TSSITTDistinguishedName(this.authenticator));
            }
        }
        return sasMechConfig;
    }

    public Set<String> extractSslRefs(Map<String, Object> properties) {
        Set sslRefs = this.extractSslRefs(properties, KEY_POLICY, TYPE);
        return sslRefs;
    }
}

