/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.source;

import com.ibm.websphere.logging.hpel.LogRecordContext;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.RoutedMessage;
import com.ibm.ws.logging.collector.CollectorJsonHelpers;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.internal.WsLogRecord;
import com.ibm.ws.logging.synch.ThreadLocalHandler;
import com.ibm.ws.logging.utils.LogFormatUtils;
import com.ibm.ws.logging.utils.SequenceNumber;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.Source;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;

public class TraceSource
implements Source {
    private static final TraceComponent tc = Tr.register(TraceSource.class, null, null);
    private final SequenceNumber sequenceNumber = new SequenceNumber();
    private final String sourceName = "com.ibm.ws.logging.source.trace";
    private final String location = "memory";
    private BufferManager bufferMgr = null;

    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Activating " + this, new Object[0]);
        }
    }

    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, " Deactivating " + this, " reason = " + reason);
        }
    }

    @Override
    public void setBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = bufferMgr;
    }

    @Override
    public void unsetBufferManager(BufferManager bufferMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Un-setting buffer manager " + this, new Object[0]);
        }
        this.bufferMgr = null;
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    @Override
    public String getSourceName() {
        return "com.ibm.ws.logging.source.trace";
    }

    @Override
    public String getLocation() {
        return "memory";
    }

    public void publish(RoutedMessage routedMessage, Object id) {
        if (!ThreadLocalHandler.get().booleanValue() && routedMessage.getLogRecord() != null && this.bufferMgr != null) {
            this.bufferMgr.add(this.parse(routedMessage, id));
        }
    }

    public LogTraceData parse(RoutedMessage routedMessage, Object id) {
        Map<String, String> extMap;
        LogTraceData traceData = new LogTraceData();
        LogRecord logRecord = routedMessage.getLogRecord();
        long datetimeValue = logRecord.getMillis();
        traceData.setDatetime(datetimeValue);
        traceData.setMessageId(null);
        traceData.setThreadId(logRecord.getThreadID());
        traceData.setModule(logRecord.getLoggerName());
        traceData.setSeverity(LogFormatUtils.mapLevelToType(logRecord));
        traceData.setLoglevel(LogFormatUtils.mapLevelToRawType(logRecord));
        traceData.setMethodName(logRecord.getSourceMethodName());
        traceData.setClassName(logRecord.getSourceClassName());
        traceData.setLevelValue(logRecord.getLevel().intValue());
        String threadName = Thread.currentThread().getName();
        traceData.setThreadName(threadName);
        WsLogRecord wsLogRecord = this.getWsLogRecord(logRecord);
        KeyValuePairList extensions = null;
        if (wsLogRecord != null) {
            traceData.setCorrelationId(wsLogRecord.getCorrelationId());
            traceData.setOrg(wsLogRecord.getOrganization());
            traceData.setProduct(wsLogRecord.getProduct());
            traceData.setComponent(wsLogRecord.getComponent());
            if (wsLogRecord.getExtensions() != null) {
                extensions = new KeyValuePairList("extensions");
                extMap = wsLogRecord.getExtensions();
                for (Map.Entry<Object, Object> entry : extMap.entrySet()) {
                    CollectorJsonHelpers.handleExtensions(extensions, (String)entry.getKey(), (String)entry.getValue());
                }
            }
            traceData.setTr(wsLogRecord.isTr());
        } else {
            extMap = new HashMap<String, String>();
            LogRecordContext.getExtensions(extMap);
            if (!extMap.isEmpty()) {
                extensions = new KeyValuePairList("extensions");
                for (Map.Entry entry : extMap.entrySet()) {
                    CollectorJsonHelpers.handleExtensions(extensions, (String)entry.getKey(), (String)entry.getValue());
                }
            }
            traceData.setTr(false);
        }
        traceData.setRawSequenceNumber(this.sequenceNumber.getRawSequenceNumber());
        String verboseMessage = routedMessage.getFormattedVerboseMsg();
        if (verboseMessage == null) {
            traceData.setMessage(logRecord.getMessage());
        } else {
            traceData.setMessage(verboseMessage);
        }
        traceData.setExtensions(extensions);
        if (id != null) {
            int objid = System.identityHashCode(id);
            traceData.setObjectId(objid);
        }
        traceData.setSourceName("com.ibm.ws.logging.source.trace");
        Throwable thrown = logRecord.getThrown();
        if (thrown != null) {
            String string = DataFormatHelper.throwableToString(thrown);
            traceData.setStackTrace(string);
            String s = thrown.getLocalizedMessage();
            if (s == null) {
                s = thrown.toString();
            }
            traceData.setStackTraceLocalized(s);
            String exceptionName = thrown.getClass().getName();
            if (exceptionName != null) {
                traceData.setExceptionName(exceptionName);
            }
        }
        return traceData;
    }

    private WsLogRecord getWsLogRecord(LogRecord logRecord) {
        return logRecord instanceof WsLogRecord ? (WsLogRecord)logRecord : null;
    }
}

