/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.util.MathUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.diagnostics.IntrospectionWriter;
import java.io.Serializable;

final class BeanIdCache {
    private volatile BeanId[] ivBuckets;
    private int ivCacheFinds = 0;
    private int ivCacheHits = 0;
    private static final TraceComponent tc = Tr.register(BeanIdCache.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    public BeanIdCache(int numBuckets) {
        numBuckets = MathUtil.findNextPrime((int)numBuckets);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<init> (" + numBuckets + ")"), (Object[])new Object[0]);
        }
        this.ivBuckets = new BeanId[numBuckets];
    }

    public BeanId find(BeanId beanId) {
        BeanId[] buckets = this.ivBuckets;
        BeanId element = buckets[(beanId.hashValue & Integer.MAX_VALUE) % buckets.length];
        if (element == null || !element.equals(beanId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ++this.ivCacheFinds;
                Tr.debug((TraceComponent)tc, (String)("BeanId not found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds), (Object[])new Object[0]);
            }
            element = beanId;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ++this.ivCacheFinds;
            ++this.ivCacheHits;
            Tr.debug((TraceComponent)tc, (String)("BeanId found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds), (Object[])new Object[0]);
        }
        return element;
    }

    public BeanId find(EJSHome home, Serializable pkey, boolean isHome) {
        BeanId[] buckets = this.ivBuckets;
        int hashValue = BeanId.computeHashValue(home.j2eeName, pkey, isHome);
        BeanId element = buckets[(hashValue & Integer.MAX_VALUE) % buckets.length];
        if (element == null || !element.equals(home, pkey, isHome)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ++this.ivCacheFinds;
                Tr.debug((TraceComponent)tc, (String)("BeanId not found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds), (Object[])new Object[0]);
            }
            element = new BeanId(home, pkey, isHome);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ++this.ivCacheFinds;
            ++this.ivCacheHits;
            Tr.debug((TraceComponent)tc, (String)("BeanId found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds), (Object[])new Object[0]);
        }
        return element;
    }

    public void add(BeanId beanId) {
        BeanId[] buckets = this.ivBuckets;
        buckets[(beanId.hashValue & Integer.MAX_VALUE) % buckets.length] = beanId;
    }

    public void removeAll(EJSHome home) {
        BeanId[] buckets = this.ivBuckets;
        for (int i = 0; i < buckets.length; ++i) {
            BeanId element = buckets[i];
            if (element == null || element.home != home) continue;
            buckets[i] = null;
        }
    }

    public void setSize(int cacheSize) {
        if (this.ivBuckets.length != cacheSize) {
            this.ivBuckets = new BeanId[cacheSize];
        }
    }

    public void introspect(IntrospectionWriter writer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            writer.println("BeanIdCache : size = " + this.ivBuckets.length + ", hits/find = " + this.ivCacheHits + "/" + this.ivCacheFinds);
        } else {
            writer.println("BeanIdCache : size = " + this.ivBuckets.length);
        }
    }
}

