/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.concurrent.internal.cdi.interceptor.ScheduleCronTrigger;
import io.openliberty.concurrent.internal.cdi.interceptor.ScheduledAsyncMethod;
import io.openliberty.concurrent.internal.messages.ConcurrencyNLS;
import jakarta.annotation.Priority;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.Schedule;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@Asynchronous
@Interceptor
@Priority(value=5)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AsyncInterceptor
implements Serializable {
    private static final long serialVersionUID = 7447792334053278336L;
    private static final TraceComponent tc = Tr.register(AsyncInterceptor.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");

    @AroundInvoke
    @FFDCIgnore(value={ClassCastException.class, NamingException.class})
    public Object intercept(InvocationContext invocation) throws Exception {
        WSManagedExecutorService managedExecutor;
        Object executor;
        CompletableFuture<?> future;
        Schedule[] schedules;
        Method method = invocation.getMethod();
        Asynchronous anno = (Asynchronous)invocation.getInterceptorBinding(Asynchronous.class);
        Schedule[] scheduleArray = schedules = anno == null ? new Schedule[]{} : anno.runAt();
        if (schedules.length > 0 && (future = ScheduledAsyncMethod.inlineExecutionFuture.get()) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"inline subsequent execution of scheduled async method", (Object[])new Object[0]);
            }
            return this.invoke(invocation, future);
        }
        AsyncInterceptor.validateTransactional(invocation);
        if (method.getDeclaringClass().getAnnotation(Asynchronous.class) != null) {
            throw new UnsupportedOperationException(ConcurrencyNLS.getMessage((String)"CWWKC1401.class.anno.disallowed", (Object[])new Object[]{"@Asynchronous", method.getDeclaringClass().getName()}));
        }
        Class<?> returnType = method.getReturnType();
        if (!(returnType.equals(CompletableFuture.class) || returnType.equals(CompletionStage.class) || returnType.equals(Void.TYPE))) {
            throw new UnsupportedOperationException(ConcurrencyNLS.getMessage((String)"CWWKC1400.unsupported.return.type", (Object[])new Object[]{returnType, method.getName(), method.getClass().getName(), "@Asynchronous", "[CompletableFuture, CompletionStage, void]"}));
        }
        try {
            executor = InitialContext.doLookup(anno.executor());
        }
        catch (NamingException x) {
            throw new RejectedExecutionException(x);
        }
        try {
            managedExecutor = (WSManagedExecutorService)executor;
        }
        catch (ClassCastException x) {
            TreeSet<String> interfaces = new TreeSet<String>();
            for (Class<?> c = executor.getClass(); c != null; c = c.getSuperclass()) {
                for (Class<?> i : executor.getClass().getInterfaces()) {
                    interfaces.add(i.getName());
                }
            }
            throw new RejectedExecutionException(ConcurrencyNLS.getMessage((String)"CWWKC1402.not.managed.executor", (Object[])new Object[]{"@Asynchronous", method.getName(), method.getClass().getName(), anno.executor(), executor.getClass().getName(), interfaces}), x);
        }
        if (schedules.length == 0) {
            return managedExecutor.newAsyncMethod(this::invoke, (Object)invocation);
        }
        ArrayList<Long> skipIfLateBySeconds = new ArrayList<Long>();
        ArrayList<ScheduleCronTrigger> triggers = new ArrayList<ScheduleCronTrigger>();
        for (Schedule schedule : schedules) {
            skipIfLateBySeconds.add(schedule.skipIfLateBy());
            triggers.add(ScheduleCronTrigger.create(schedule));
        }
        return new ScheduledAsyncMethod((InvocationContext)invocation, (AsyncInterceptor)this, (WSManagedExecutorService)managedExecutor, triggers, skipIfLateBySeconds).future;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public <T> CompletionStage<T> invoke(InvocationContext invocation, CompletableFuture<T> future) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("invoke " + invocation.getMethod().getName()), (Object[])new Object[]{invocation, future});
        }
        Asynchronous.Result.setFuture(future);
        try {
            CompletionStage asyncMethodResultStage = (CompletionStage)invocation.proceed();
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)("invoke " + invocation.getMethod().getName()), (Object)asyncMethodResultStage);
            }
            CompletionStage completionStage = asyncMethodResultStage;
            return completionStage;
        }
        catch (Throwable x) {
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)("invoke " + invocation.getMethod().getName()), (Object)x);
            }
            throw x instanceof CompletionException ? (CompletionException)x : new CompletionException(x);
        }
        finally {
            Asynchronous.Result.setFuture(null);
        }
    }

    @Trivial
    private static void validateTransactional(InvocationContext invocation) throws UnsupportedOperationException {
        Transactional tx = (Transactional)invocation.getInterceptorBinding(Transactional.class);
        if (tx != null) {
            switch (tx.value()) {
                case NOT_SUPPORTED: 
                case REQUIRES_NEW: {
                    break;
                }
                default: {
                    Method method = invocation.getMethod();
                    throw new UnsupportedOperationException(ConcurrencyNLS.getMessage((String)"CWWKC1403.unsupported.tx.type", (Object[])new Object[]{"@Transactional", tx.value(), "@Asynchronous", method.getName(), method.getDeclaringClass().getName(), Arrays.asList(Transactional.TxType.REQUIRES_NEW, Transactional.TxType.NOT_SUPPORTED)}));
                }
            }
        }
    }
}

