/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.crypto.CryptoUtils;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class LTPACrypto {
    private static final boolean fipsEnabled = CryptoUtils.isFips140_3Enabled();
    private static final String provider = CryptoUtils.getProvider();
    private static final String signatureAlgorithm = CryptoUtils.getSignatureAlgorithm();
    private static int MAX_CACHE = 500;
    private static IvParameterSpec ivs8 = null;
    private static IvParameterSpec ivs16 = null;
    private static final ConcurrentHashMap<CachingKey, CachingKey> cryptoKeysMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<CachingVerifyKey, CachingVerifyKey> verifyKeysMap = new ConcurrentHashMap();
    private static final Comparator<CachingVerifyKey> cachingVerifyKeyComparator = new Comparator<CachingVerifyKey>(){

        @Override
        @Trivial
        public int compare(CachingVerifyKey o1, CachingVerifyKey o2) {
            if (o1.successfulUses < o2.successfulUses) {
                return -1;
            }
            if (o1.successfulUses == o2.successfulUses) {
                return 0;
            }
            return 1;
        }
    };
    private static final Comparator<CachingKey> cachingKeyComparator = new Comparator<CachingKey>(){

        @Override
        @Trivial
        public int compare(CachingKey o1, CachingKey o2) {
            if (!o1.reused) {
                if (o2.reused) {
                    return -1;
                }
            } else if (!o2.reused) {
                return 1;
            }
            if (o1.successfulUses < o2.successfulUses) {
                return -1;
            }
            if (o1.successfulUses == o2.successfulUses) {
                return 0;
            }
            return 1;
        }
    };

    LTPACrypto() {
    }

    @Trivial
    protected static final byte[] signISO9796(byte[][] key, byte[] data, int off, int len) throws Exception {
        CachingKey ck = new CachingKey(key, data, off, len);
        CachingKey result = cryptoKeysMap.get(ck);
        if (result != null) {
            result.successfulUses += 1L;
            result.reused = true;
            return result.result;
        }
        if (cryptoKeysMap.size() >= MAX_CACHE) {
            try {
                int i;
                int cryptoKeysMapSize = cryptoKeysMap.size();
                CachingKey[] keys = ((ConcurrentHashMap.CollectionView)((Object)cryptoKeysMap.keySet())).toArray(new CachingKey[cryptoKeysMapSize]);
                Arrays.sort(keys, cachingKeyComparator);
                if (cachingKeyComparator.compare(keys[0], keys[keys.length - 1]) < 0) {
                    for (i = 0; i < cryptoKeysMapSize / 5; ++i) {
                        cryptoKeysMap.remove(keys[i]);
                        keys[i + 1 * cryptoKeysMapSize / 5].successfulUses--;
                        keys[i + 2 * cryptoKeysMapSize / 5].successfulUses--;
                        keys[i + 3 * cryptoKeysMapSize / 5].successfulUses--;
                        keys[i + 4 * cryptoKeysMapSize / 5].successfulUses--;
                    }
                } else {
                    for (i = 0; i < cryptoKeysMapSize / 5; ++i) {
                        cryptoKeysMap.remove(keys[keys.length - 1 - i]);
                        keys[keys.length - 1 - i - 1 * cryptoKeysMapSize / 5].successfulUses--;
                        keys[keys.length - 1 - i - 2 * cryptoKeysMapSize / 5].successfulUses--;
                        keys[keys.length - 1 - i - 3 * cryptoKeysMapSize / 5].successfulUses--;
                        keys[keys.length - 1 - i - 4 * cryptoKeysMapSize / 5].successfulUses--;
                    }
                }
            }
            catch (Exception cryptoKeysMapSize) {
                // empty catch block
            }
        }
        BigInteger n = new BigInteger(key[0]);
        BigInteger e = new BigInteger(key[2]);
        BigInteger p = new BigInteger(key[3]);
        BigInteger q = new BigInteger(key[4]);
        BigInteger d = e.modInverse(p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE)));
        KeyFactory kFact = null;
        kFact = provider == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", provider);
        BigInteger pep = new BigInteger(key[5]);
        BigInteger peq = new BigInteger(key[6]);
        BigInteger crtC = new BigInteger(key[7]);
        RSAPrivateCrtKeySpec privCrtKeySpec = new RSAPrivateCrtKeySpec(n, e, d, p, q, pep, peq, crtC);
        PrivateKey privKey = kFact.generatePrivate(privCrtKeySpec);
        Signature rsaSig = null;
        rsaSig = provider == null ? Signature.getInstance(signatureAlgorithm) : Signature.getInstance(signatureAlgorithm, provider);
        rsaSig.initSign(privKey);
        rsaSig.update(data, off, len);
        byte[] sig = rsaSig.sign();
        cryptoKeysMap.put(ck, ck);
        CachingKey.access$302(ck, sig);
        ck.successfulUses = 0L;
        return sig;
    }

    @Trivial
    protected static int getSignCacheSize() {
        return cryptoKeysMap.size();
    }

    @Trivial
    protected static void emptySignCache() {
        cryptoKeysMap.clear();
    }

    @Trivial
    protected static final boolean verifyISO9796(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) throws Exception {
        CachingVerifyKey ck = new CachingVerifyKey(key, data, off, len, sig, sigOff, sigLen);
        CachingVerifyKey result = verifyKeysMap.get(ck);
        if (result != null) {
            result.successfulUses += 1L;
            return result.result;
        }
        if (verifyKeysMap.size() >= MAX_CACHE) {
            int i;
            int verifyKeysMapSize = verifyKeysMap.size();
            CachingVerifyKey[] keys = ((ConcurrentHashMap.CollectionView)((Object)verifyKeysMap.keySet())).toArray(new CachingVerifyKey[verifyKeysMapSize]);
            Arrays.sort(keys, cachingVerifyKeyComparator);
            if (cachingVerifyKeyComparator.compare(keys[0], keys[keys.length - 1]) < 0) {
                for (i = 0; i < verifyKeysMapSize / 5; ++i) {
                    verifyKeysMap.remove(keys[i]);
                    keys[i + 1 * verifyKeysMapSize / 5].successfulUses--;
                    keys[i + 2 * verifyKeysMapSize / 5].successfulUses--;
                    keys[i + 3 * verifyKeysMapSize / 5].successfulUses--;
                    keys[i + 4 * verifyKeysMapSize / 5].successfulUses--;
                }
            } else {
                for (i = 0; i < verifyKeysMapSize / 5; ++i) {
                    verifyKeysMap.remove(keys[keys.length - 1 - i]);
                    keys[keys.length - 1 - i - 1 * verifyKeysMapSize / 5].successfulUses--;
                    keys[keys.length - 1 - i - 2 * verifyKeysMapSize / 5].successfulUses--;
                    keys[keys.length - 1 - i - 3 * verifyKeysMapSize / 5].successfulUses--;
                    keys[keys.length - 1 - i - 4 * verifyKeysMapSize / 5].successfulUses--;
                }
            }
        }
        boolean verified = false;
        BigInteger n = new BigInteger(key[0]);
        BigInteger e = new BigInteger(key[1]);
        KeyFactory kFact = null;
        Signature rsaSig = null;
        kFact = provider == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", provider);
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(n, e);
        PublicKey pubKey = kFact.generatePublic(pubKeySpec);
        rsaSig = provider == null ? Signature.getInstance(signatureAlgorithm) : Signature.getInstance(signatureAlgorithm, provider);
        rsaSig.initVerify(pubKey);
        rsaSig.update(data, off, len);
        verified = rsaSig.verify(sig);
        verifyKeysMap.put(ck, ck);
        ck.result = verified;
        ck.successfulUses = 0L;
        return verified;
    }

    @Trivial
    protected static int getVerifyCacheSize() {
        return verifyKeysMap.size();
    }

    @Trivial
    protected static void emptyVerifyCache() {
        verifyKeysMap.clear();
    }

    @Trivial
    protected static final void setRSAKey(byte[][] key) {
        int i;
        BigInteger[] k = new BigInteger[8];
        for (i = 0; i < 8; ++i) {
            if (key[i] == null) continue;
            k[i] = new BigInteger(1, key[i]);
        }
        if (k[3].compareTo(k[4]) < 0) {
            BigInteger tmp = k[3];
            k[3] = k[4];
            k[4] = tmp;
            tmp = k[5];
            k[5] = k[6];
            k[6] = tmp;
            k[7] = null;
        }
        if (k[7] == null) {
            k[7] = k[4].modInverse(k[3]);
        }
        if (k[0] == null) {
            k[0] = k[3].multiply(k[4]);
        }
        if (k[1] == null) {
            k[1] = k[2].modInverse(k[3].subtract(BigInteger.valueOf(1L)).multiply(k[4].subtract(BigInteger.valueOf(1L))));
        }
        if (k[5] == null) {
            k[5] = k[1].remainder(k[3].subtract(BigInteger.valueOf(1L)));
        }
        if (k[6] == null) {
            k[6] = k[1].remainder(k[4].subtract(BigInteger.valueOf(1L)));
        }
        for (i = 0; i < 8; ++i) {
            key[i] = k[i].toByteArray();
        }
    }

    @Trivial
    private static SecretKey constructSecretKey(byte[] key, String cipher) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        SecretKey sKey = null;
        if (cipher.indexOf("AES") != -1) {
            int keyLength = fipsEnabled ? 32 : 16;
            sKey = new SecretKeySpec(key, 0, keyLength, "AES");
        } else {
            DESedeKeySpec kSpec = new DESedeKeySpec(key);
            SecretKeyFactory kFact = null;
            kFact = provider == null ? SecretKeyFactory.getInstance("DESede") : SecretKeyFactory.getInstance("DESede", provider);
            sKey = kFact.generateSecret(kSpec);
        }
        return sKey;
    }

    @Trivial
    private static Cipher createCipher(int cipherMode, byte[] key, String cipher, SecretKey sKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Cipher ci = null;
        Cipher cipher2 = ci = provider == null ? Cipher.getInstance(cipher) : Cipher.getInstance(cipher, provider);
        if (cipher.indexOf("ECB") == -1) {
            if (cipher.indexOf("AES") != -1) {
                LTPACrypto.setIVS16(key);
                ci.init(cipherMode, (Key)sKey, ivs16);
            } else {
                LTPACrypto.setIVS8(key);
                ci.init(cipherMode, (Key)sKey, ivs8);
            }
        } else {
            ci.init(cipherMode, sKey);
        }
        return ci;
    }

    @Trivial
    protected static final byte[] encrypt(byte[] data, byte[] key, String cipher) throws Exception {
        SecretKey sKey = LTPACrypto.constructSecretKey(key, cipher);
        Cipher ci = LTPACrypto.createCipher(1, key, cipher, sKey);
        return ci.doFinal(data);
    }

    @Trivial
    protected static final byte[] decrypt(byte[] msg, byte[] key, String cipher) throws Exception {
        SecretKey sKey = LTPACrypto.constructSecretKey(key, cipher);
        Cipher ci = LTPACrypto.createCipher(2, key, cipher, sKey);
        return ci.doFinal(msg);
    }

    @Trivial
    protected static void setMaxCache(int maxCache) {
        MAX_CACHE = maxCache;
    }

    @Trivial
    private static final synchronized void setIVS8(byte[] key) {
        byte[] iv8 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv8[i] = key[i];
        }
        ivs8 = new IvParameterSpec(iv8);
    }

    @Trivial
    private static final synchronized void setIVS16(byte[] key) {
        byte[] iv16 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            iv16[i] = key[i];
        }
        ivs16 = new IvParameterSpec(iv16);
    }

    @Trivial
    static final byte[] generateSharedKey() {
        return fipsEnabled ? CryptoUtils.generateRandomBytes((int)32) : CryptoUtils.generateRandomBytes((int)24);
    }

    @Trivial
    static final byte[][] rsaKey(int len, boolean crt, boolean f4) {
        byte[][] key;
        block13: {
            key = new byte[crt ? 8 : 3][];
            KeyPair pair = null;
            KeyPairGenerator keyGen = null;
            try {
                keyGen = provider == null ? KeyPairGenerator.getInstance("RSA") : KeyPairGenerator.getInstance("RSA", provider);
                keyGen.initialize(len * 8, new SecureRandom());
                pair = keyGen.generateKeyPair();
                RSAPublicKey rsaPubKey = (RSAPublicKey)pair.getPublic();
                RSAPrivateCrtKey rsaPrivKey = (RSAPrivateCrtKey)pair.getPrivate();
                BigInteger e = rsaPubKey.getPublicExponent();
                BigInteger n = rsaPubKey.getModulus();
                BigInteger pe = rsaPrivKey.getPrivateExponent();
                key[0] = n.toByteArray();
                key[1] = crt ? null : pe.toByteArray();
                key[2] = e.toByteArray();
                if (crt) {
                    BigInteger p = rsaPrivKey.getPrimeP();
                    BigInteger q = rsaPrivKey.getPrimeQ();
                    BigInteger ep = rsaPrivKey.getPrimeExponentP();
                    BigInteger eq = rsaPrivKey.getPrimeExponentQ();
                    BigInteger c = rsaPrivKey.getCrtCoefficient();
                    key[3] = p.toByteArray();
                    key[4] = q.toByteArray();
                    key[5] = ep.toByteArray();
                    key[6] = eq.toByteArray();
                    key[7] = c.toByteArray();
                }
            }
            catch (NoSuchAlgorithmException rsaPubKey) {
            }
            catch (NoSuchProviderException rsaPubKey) {
            }
            catch (UnsupportedOperationException uoe) {
                BigInteger d;
                BigInteger n;
                BigInteger q;
                System.out.println("DEBUG: UnsupportedOperationException is caught!! Going back to the previous hardware crypto routine for evaluation.");
                BigInteger e = BigInteger.valueOf(f4 ? 65537L : 3L);
                BigInteger one = BigInteger.valueOf(1L);
                BigInteger two = BigInteger.valueOf(2L);
                byte[] b = new byte[(len /= 2) + 1];
                BigInteger p = null;
                while (true) {
                    q = null;
                    while (true) {
                        if (q == null) {
                            byte[] seed = CryptoUtils.generateRandomBytes((int)len);
                            System.arraycopy(seed, 0, b, 1, len);
                            b[1] = (byte)(b[1] | 0xC0);
                            int n2 = len;
                            b[n2] = (byte)(b[n2] | 1);
                            q = new BigInteger(b);
                        } else if ((q = q.add(two)).bitLength() > len * 8) {
                            q = null;
                            continue;
                        }
                        if (q.isProbablePrime(32) && e.gcd(q.subtract(one)).equals(one)) break;
                    }
                    if (p == null) {
                        p = q;
                        continue;
                    }
                    n = p.multiply(q);
                    if (n.bitLength() == len * 2 * 8) {
                        d = e.modInverse(p.subtract(one).multiply(q.subtract(one)));
                        if (p.modPow(e, n).modPow(d, n).equals(p)) break;
                    }
                    p = null;
                }
                key[0] = n.toByteArray();
                key[1] = crt ? null : d.toByteArray();
                key[2] = e.toByteArray();
                if (!crt) break block13;
                if (p.compareTo(q) < 0) {
                    e = p;
                    p = q;
                    q = e;
                }
                key[3] = p.toByteArray();
                key[4] = q.toByteArray();
                key[5] = d.remainder(p.subtract(one)).toByteArray();
                key[6] = d.remainder(q.subtract(one)).toByteArray();
                key[7] = q.modInverse(p).toByteArray();
            }
        }
        return key;
    }

    @Trivial
    private static class CachingKey {
        private boolean reused = false;
        private long successfulUses;
        private final byte[][] key;
        private final byte[] data;
        private final int off;
        private final int len;
        private int hashcode;
        private byte[] result;

        @Trivial
        private CachingKey(byte[][] key, byte[] data, int off, int len) {
            this.key = key;
            this.data = data;
            this.off = off;
            this.len = len;
            this.successfulUses = 0L;
            this.reused = false;
            this.hashcode = 0;
            if (key != null && key.length > 0 && key[0] != null && key[0].length > 0) {
                this.hashcode += key[0][0];
            }
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    this.hashcode += data[i];
                }
            }
            this.hashcode += off + len;
            if (off != 0) {
                this.hashcode *= off;
            }
            this.hashcode *= 2;
        }

        @Trivial
        public boolean equals(Object to) {
            int i;
            if (!(to instanceof CachingKey)) {
                return false;
            }
            CachingKey ck = (CachingKey)to;
            if (this.hashcode != ck.hashcode) {
                return false;
            }
            if (this.len != ck.len) {
                return false;
            }
            if (this.key != null) {
                if (ck.key == null) {
                    return false;
                }
                if (this.key.length != ck.key.length) {
                    return false;
                }
                for (i = 0; i < this.key.length; ++i) {
                    if (this.key[i] != null) {
                        if (ck.key[i] == null) {
                            return false;
                        }
                        if (this.key[i].length != ck.key[i].length) {
                            return false;
                        }
                        for (int o = 0; o < this.key[i].length; ++o) {
                            if (this.key[i][o] == ck.key[i][o]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (ck.key[i] == null) continue;
                    return false;
                }
            } else if (ck.key != null) {
                return false;
            }
            if (this.data != null) {
                if (ck.data == null) {
                    return false;
                }
                if (this.data.length != ck.data.length) {
                    return false;
                }
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == ck.data[i]) continue;
                    return false;
                }
            } else if (ck.data != null) {
                return false;
            }
            return this.off == ck.off;
        }

        @Trivial
        public int hashCode() {
            return this.hashcode;
        }

        static /* synthetic */ byte[] access$302(CachingKey x0, byte[] x1) {
            x0.result = x1;
            return x1;
        }
    }

    @Trivial
    private static class CachingVerifyKey {
        private long successfulUses;
        private final byte[][] key;
        private final byte[] data;
        private final int off;
        private final int len;
        private final byte[] sig;
        private final int sigOff;
        private final int sigLen;
        private int hashcode;
        private boolean result;

        @Trivial
        private CachingVerifyKey(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) {
            this.key = key;
            this.data = data;
            this.off = off;
            this.len = len;
            this.sig = sig;
            this.sigOff = sigOff;
            this.sigLen = sigLen;
            this.successfulUses = 0L;
            this.hashcode = 0;
            if (key != null && key.length > 0 && key[0] != null && key[0].length > 0) {
                this.hashcode += key[0][0];
            }
            if (data != null) {
                int i;
                for (i = 0; i < data.length && i < 10; ++i) {
                    this.hashcode += data[i];
                }
                for (i = data.length - 1; i >= 0 && i > data.length - 10; --i) {
                    this.hashcode += data[i];
                }
            }
            this.hashcode += off;
            if (off != 0) {
                this.hashcode *= off;
            }
            this.hashcode *= 2;
        }

        @Trivial
        public boolean equals(Object to) {
            int i;
            if (!(to instanceof CachingVerifyKey)) {
                return false;
            }
            CachingVerifyKey ck = (CachingVerifyKey)to;
            if (this.hashcode != ck.hashcode) {
                return false;
            }
            if (this.len != ck.len) {
                return false;
            }
            if (this.key != null) {
                if (ck.key == null) {
                    return false;
                }
                if (this.key.length != ck.key.length) {
                    return false;
                }
                for (i = 0; i < this.key.length; ++i) {
                    if (this.key[i] != null) {
                        if (ck.key[i] == null) {
                            return false;
                        }
                        if (this.key[i].length != ck.key[i].length) {
                            return false;
                        }
                        for (int o = 0; o < this.key[i].length; ++o) {
                            if (this.key[i][o] == ck.key[i][o]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (ck.key[i] == null) continue;
                    return false;
                }
            } else if (ck.key != null) {
                return false;
            }
            if (this.data != null) {
                if (ck.data == null) {
                    return false;
                }
                if (this.data.length != ck.data.length) {
                    return false;
                }
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == ck.data[i]) continue;
                    return false;
                }
            } else if (ck.data != null) {
                return false;
            }
            if (this.sig != null) {
                if (ck.sig == null) {
                    return false;
                }
                if (this.sig.length != ck.sig.length) {
                    return false;
                }
                for (i = 0; i < this.sig.length; ++i) {
                    if (this.sig[i] == ck.sig[i]) continue;
                    return false;
                }
            } else if (ck.sig != null) {
                return false;
            }
            if (this.off != ck.off) {
                return false;
            }
            if (this.sigOff != ck.sigOff) {
                return false;
            }
            return this.sigLen == ck.sigLen;
        }

        @Trivial
        public int hashCode() {
            return this.hashcode;
        }
    }
}

