/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationForeignDefinition;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.ForeignDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.runtime.SIMPForeignBusControllable;
import com.ibm.ws.sib.processor.runtime.SIMPForeignDestinationControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Map;

public class ForeignDestination
extends AbstractControlAdapter
implements SIMPForeignDestinationControllable {
    private static TraceComponent tc = SibTr.register(ForeignDestination.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ForeignDestinationHandler foreignDest;
    private MessageProcessor messageProcessor;

    public ForeignDestination(MessageProcessor messageProcessor, ForeignDestinationHandler foreignDest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ForeignDestination", (Object)new Object[]{messageProcessor, foreignDest});
        }
        this.foreignDest = foreignDest;
        this.messageProcessor = messageProcessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ForeignDestination", (Object)this);
        }
    }

    public DestinationForeignDefinition getForeignDestinationDefinition() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignDestinationDefinition");
        }
        DestinationForeignDefinition definition = (DestinationForeignDefinition)this.foreignDest.getDefinition();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignDestinationDefinition");
        }
        return definition;
    }

    public SIMPForeignBusControllable getTargetForeignBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetForeignBus");
        }
        BusHandler foreignBus = null;
        try {
            foreignBus = this.messageProcessor.getDestinationManager().findBus(this.foreignDest.getBus());
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.getTargetForeignBus", (String)"1:114:1.19", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.getTargetForeignBus", "1:119:1.19", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        SIMPForeignBusControllable busControllable = null;
        if (foreignBus != null) {
            busControllable = (SIMPForeignBusControllable)foreignBus.getControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetForeignBus");
        }
        return busControllable;
    }

    public SIMPIterator getProducerIterator() {
        return null;
    }

    public SIMPMessageProcessorControllable getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor");
        }
        return (SIMPMessageProcessorControllable)this.messageProcessor.getControlAdapter();
    }

    public boolean isLocal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocal");
        }
        boolean isLocal = false;
        if (this.foreignDest.getResolvedDestinationHandler().getLocalLocalizationPoint() != null) {
            isLocal = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocal", (Object)new Boolean(isLocal));
        }
        return isLocal;
    }

    public boolean isAlias() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlias");
            SibTr.exit((TraceComponent)tc, (String)"isAlias", (Object)Boolean.TRUE);
        }
        return true;
    }

    public boolean isForeign() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForeign");
            SibTr.exit((TraceComponent)tc, (String)"isForeign", (Object)Boolean.TRUE);
        }
        return true;
    }

    public SIBUuid12 getUUID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUUID");
        }
        SIBUuid12 uuid = this.foreignDest.getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUUID", (Object)uuid);
        }
        return uuid;
    }

    public String getDescription() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        String desc = this.foreignDest.getDescription();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)desc);
        }
        return desc;
    }

    public Map getDestinationContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationContext");
        }
        Map context = this.foreignDest.getDefinition().getDestinationContext();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationContext", (Object)context);
        }
        return context;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.foreignDest == null || !this.foreignDest.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ForeignDest.assertValidControllable", "1:263:1.19", this.foreignDest}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.foreignDest = null;
        this.messageProcessor = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public SIMPIterator getBrowserIterator() {
        return null;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public boolean isSystem() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSystem");
        }
        boolean isSystem = this.foreignDest.isSystem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSystem", (Object)new Boolean(isSystem));
        }
        return isSystem;
    }

    public boolean isTemporary() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporary");
        }
        boolean isTemporary = this.foreignDest.isTemporary();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTemporary", (Object)new Boolean(isTemporary));
        }
        return isTemporary;
    }

    public String getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String state = this.messageProcessor.getDestinationManager().getDestinationIndex().getState(this.foreignDest).toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        return state;
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String name = this.foreignDest.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)name);
        }
        return name;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String id = this.getUUID().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)id);
        }
        return id;
    }
}

