/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.selector.impl.IdentifierImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class SelectorImpl
implements Selector,
Cloneable {
    private static final Class cclass = SelectorImpl.class;
    public int type;
    public int uniqueId;
    private int refCount;
    public int numIds;
    protected boolean extended;

    public boolean mayBeBoolean() {
        if (this.type == 0) {
            this.type = -6;
        }
        return this.type == -6;
    }

    public boolean mayBeString() {
        if (this.type == 0) {
            this.type = -5;
        }
        return this.type == -5;
    }

    public boolean mayBeNumeric() {
        if (this.type == 0) {
            this.type = 1;
        }
        return this.type == 1 || this.type >= -4 && this.type <= -1;
    }

    public boolean mayBeObject() {
        if (this.type == 0) {
            this.type = -7;
        }
        return this.type == -7;
    }

    public Selector intern(Selector.InternTable table) {
        Selector me = (Selector)table.get((Object)this);
        if (me != null) {
            me.incRefCount();
            return me;
        }
        this.uniqueId = table.getNextUniqueId();
        ++this.refCount;
        table.put((Object)this, (Object)this);
        return this;
    }

    public void unintern(Selector.InternTable table) {
        Object res;
        --this.refCount;
        if (this.refCount < 0) {
            throw new IllegalStateException();
        }
        if (this.refCount == 0 && (res = table.remove((Object)this)) == null) {
            throw new IllegalStateException();
        }
    }

    public static Selector decode(ObjectInput buf) throws IOException {
        if (buf.readByte() != 1) {
            throw new IOException();
        }
        try {
            return SelectorImpl.decodeSubtree(buf);
        }
        catch (Exception e) {
            FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.Selector.decode", (Throwable)e, (String)"1:191:1.19");
            throw new IllegalArgumentException();
        }
    }

    static Selector decodeSubtree(ObjectInput buf) throws ClassNotFoundException, IOException {
        byte type = buf.readByte();
        if (type < 0) {
            return new LiteralImpl(buf);
        }
        if (type == 0) {
            return new IdentifierImpl(buf);
        }
        if (type == 4) {
            return new LikeOperatorImpl(buf);
        }
        return new OperatorImpl(buf);
    }

    public void encode(ObjectOutput buf) throws IOException {
        buf.writeByte(1);
        this.encodeSelf(buf);
    }

    public boolean equals(Object o) {
        if (o instanceof Selector) {
            Selector s = (Selector)o;
            return this.type == s.getType() && this.numIds == s.getNumIds();
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.Selector.clone", (Throwable)e, (String)"1:255:1.19");
            throw new IllegalStateException();
        }
    }

    public int getNumIds() {
        return this.numIds;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public int getType() {
        return this.type;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended() {
        this.extended = true;
    }
}

