/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.beans;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class Permission {
    private static TraceComponent tc = SibTr.register(Permission.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.beans.Permission";
    private final Map<String, Set<String>> roleToUserMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<String>> roleToGroupMap = Collections.synchronizedMap(new HashMap());

    public Map<String, Set<String>> getRoleToUserMap() {
        return this.roleToUserMap;
    }

    public Map<String, Set<String>> getRoleToGroupMap() {
        return this.roleToGroupMap;
    }

    protected void addAllUsersToRole(Set<String> users, String role) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllUsersToRole", (Object)new Object[]{users, role});
        }
        if (users != null && role != null) {
            Set roleToUserLocalRef = this.roleToUserMap.computeIfAbsent(role, Permission::createSynchronizedSet);
            users.stream().filter(Objects::nonNull).forEach(roleToUserLocalRef::add);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllUsersToRole");
        }
    }

    protected void addAllGroupsToRole(Set<String> groups, String role) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllGroupsToRole", (Object)new Object[]{groups, role});
        }
        if (groups != null && role != null) {
            Set roleToGroupLocalRef = this.roleToGroupMap.computeIfAbsent(role, Permission::createSynchronizedSet);
            groups.stream().filter(Objects::nonNull).forEach(roleToGroupLocalRef::add);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllGroupsToRole");
        }
    }

    protected boolean checkActionArrayHasAllPermission(String[] actionArray) {
        for (String action : actionArray) {
            if (!action.equalsIgnoreCase("ALL")) continue;
            return true;
        }
        return false;
    }

    public abstract void addUserAndGroupsToRole(String[] var1, Set<String> var2, Set<String> var3);

    public abstract boolean validateAction(String var1);

    public abstract void addUsersAndGroupsToAllActions(Set<String> var1, Set<String> var2);

    private static <V extends Comparable<V>> SortedSet<V> createSynchronizedSet(Object ignored) {
        return Collections.synchronizedSortedSet(new TreeSet());
    }
}

