/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

public enum InjectionScope {
    COMP("comp"),
    MODULE("module"),
    APP("app"),
    GLOBAL("global");

    private static final InjectionScope[] VALUES;
    private static final String JAVA_COLON = "java:";
    private static final String JAVA_COLON_COMP_ENV_PREFIX = "java:comp/env/";
    private final String ivName;
    private final String ivQualifiedName;
    private final String ivPrefix;

    public static int size() {
        return VALUES.length;
    }

    public static InjectionScope match(String refName) {
        for (InjectionScope scope : VALUES) {
            if (!refName.startsWith(scope.ivPrefix)) continue;
            return scope;
        }
        return null;
    }

    public static String normalize(String refName) {
        return refName.startsWith(JAVA_COLON_COMP_ENV_PREFIX) ? refName.substring(JAVA_COLON_COMP_ENV_PREFIX.length()) : refName;
    }

    public static String denormalize(String refName) {
        return refName.startsWith(JAVA_COLON) ? refName : JAVA_COLON_COMP_ENV_PREFIX + refName;
    }

    private InjectionScope(String name) {
        this.ivName = name;
        this.ivQualifiedName = JAVA_COLON + name;
        this.ivPrefix = JAVA_COLON + name + '/';
    }

    public String contextName() {
        return this.ivName;
    }

    public String qualifiedName() {
        return this.ivQualifiedName;
    }

    public String prefix() {
        return this.ivPrefix;
    }

    static {
        VALUES = InjectionScope.values();
    }
}

