/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractObjectStore;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.BTree;
import com.ibm.ws.objectManager.ConcurrentHashMap;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.NonExistentObjectStoreFileException;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStoreFullException;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.StoreFileSizeTooSmallException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.UnexpectedExceptionException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import com.ibm.ws.objectManager.utils.concurrent.atomic.AtomicInteger;
import com.ibm.ws.objectManager.utils.concurrent.atomic.AtomicIntegerImpl;
import com.ibm.ws.objectManager.utils.concurrent.atomic.AtomicLongImpl;
import com.ibm.ws.objectManager.utils.concurrent.locks.ReentrantReadWriteLockImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AbstractSingleFileObjectStore
extends AbstractObjectStore {
    private static final Class cclass = AbstractSingleFileObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    private static final long serialVersionUID = -1011499273819925485L;
    protected static final long directoryIdentifier = 101L;
    protected static final long freeSpaceIdentifier = 102L;
    protected static final long initialSequenceNumber = 200L;
    static final String signature = "++ObjectManager.SingleFileObjectStore++";
    protected transient String storeFileName;
    protected transient RandomAccessFile storeFile;
    protected volatile transient Map managedObjectsToWrite;
    transient AtomicXXBitLong reservedSize;
    protected transient long directoryReservedSize;
    private transient long reservationThreshold = 0L;
    private transient long reservationCheckpointThreshold = 0L;
    private transient long simulateFullReservedSize = 0L;
    private transient boolean reservationPacing = false;
    private transient ReservationPacingLock reservationPacingLock;
    static final int reservationCheckpointMaximum = 5000000;
    protected transient Map checkpointManagedObjectsToWrite;
    protected transient SoftReference[] cachedManagedObjects;
    protected transient int iCache = 0;
    static final int initialCachedManagedObjectsSize = 10000;
    protected transient int cachedManagedObjectsSize;
    protected volatile transient Map tokensToDelete;
    protected transient Map checkpointTokensToDelete;
    protected transient int checkpointReleaseSize;
    transient GetLock getLock;
    protected transient Directory directory;
    protected transient FreeSpace freeSpaceByAddressHead;
    protected transient SortedSet freeSpaceByLength;
    protected transient Directory.StoreArea freeSpaceStoreArea;
    protected transient int maxFreeSpaceCount;
    static final int freeSpaceEntryLength = 16;
    static final int minimumFreeSpaceEntrySize = 17;
    protected transient SortedSet newFreeSpace;
    protected transient long storeFileSizeUsed;
    protected transient long storeFileSizeAllocated;
    protected transient long minimumStoreFileSize;
    protected transient long maximumStoreFileSize;
    protected static final int pageSize = 4096;
    protected final int version = 1;
    static final int initialDirectoryMinimumNodeSize = 10;
    protected transient int numberOfGetRequests;
    protected transient int numberOfDirectoryNodesRead;
    private transient int numberOfStoreFullCheckpointsTriggered;
    private transient int numberOfReservationCheckpointsTriggered;
    private transient int pacedReservationsReleased;
    protected transient int numberOfManagedObjectsWritten;
    private transient long lastFlushMilliseconds;
    private transient long writingMilliseconds;
    private transient long removingEntriesMilliseconds;
    private transient long allocatingEntrySpaceMilliseconds;
    private transient long releasingEntrySpaceMilliseconds;
    private transient long directoryWriteMilliseconds;
    protected transient long storeFileExtendedDuringAllocation;
    static final boolean useGuardBytes = false;
    static byte guardByte = 0;
    static final int guardBytesLength = 16;
    private transient Set tokenSet;

    public AbstractSingleFileObjectStore(String storeName, ObjectManager objectManager) throws ObjectManagerException {
        super(storeName, objectManager, 0);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager});
            trace.exit(this, cclass, "<init>");
        }
    }

    public AbstractSingleFileObjectStore(String storeName, ObjectManager objectManager, int storeStrategy) throws ObjectManagerException {
        super(storeName, objectManager, storeStrategy);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager, new Integer(storeStrategy)});
            trace.exit(this, cclass, "<init>");
        }
    }

    public synchronized void setStoreFileSize(long newMinimumStoreFileSize, long newMaximumStoreFileSize) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setStoreFileSize", new Object[]{new Long(newMinimumStoreFileSize), new Long(newMaximumStoreFileSize)});
        }
        if (newMinimumStoreFileSize > newMaximumStoreFileSize) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "setStoreFileSize");
            }
            throw new IllegalArgumentException(newMinimumStoreFileSize + ">" + newMaximumStoreFileSize);
        }
        if (newMaximumStoreFileSize < this.storeFileSizeUsed) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setStoreFileSize", new Object[]{new Long(newMaximumStoreFileSize), new Long(this.storeFileSizeAllocated), new Long(this.storeFileSizeUsed)});
            }
            throw new StoreFileSizeTooSmallException(this, newMaximumStoreFileSize, this.storeFileSizeAllocated, this.storeFileSizeUsed);
        }
        if (newMinimumStoreFileSize > this.storeFileSizeAllocated) {
            try {
                this.setStoreFileSizeInternalWithException(newMinimumStoreFileSize);
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "setStoreFileSize", exception, "1:349:1.57");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "setStoreFileSize");
                }
                throw new PermanentIOException((Object)this, exception);
            }
        }
        this.minimumStoreFileSize = newMinimumStoreFileSize;
        this.maximumStoreFileSize = newMaximumStoreFileSize;
        this.writeHeader();
        this.force();
        this.setAllocationAllowed();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setStoreFileSize");
        }
    }

    public synchronized int getCachedManagedObjectsSize() {
        return this.cachedManagedObjectsSize;
    }

    public synchronized void setCachedManagedObjectsSize(int cachedManagedObjectsSize) throws ObjectManagerException {
        this.cachedManagedObjectsSize = cachedManagedObjectsSize;
        this.cachedManagedObjects = new SoftReference[cachedManagedObjectsSize];
        this.writeHeader();
        this.force();
    }

    public synchronized long getMaximumStoreFileSize() {
        return this.maximumStoreFileSize;
    }

    public synchronized long getMinimumStoreFileSize() {
        return this.minimumStoreFileSize;
    }

    public long getStoreFileSize() {
        return this.storeFileSizeAllocated;
    }

    public long getStoreFileUsed() {
        return this.storeFileSizeUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAllocationAllowed() throws ObjectManagerException {
        String methodName = "setAllocationAllowed";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setAllocationAllowed", new Object[]{new Long(this.storeFileSizeAllocated), new Long(this.storeFileSizeUsed)});
        }
        long storeFileSizeRequired = this.storeFileSizeAllocated;
        if (this.simulateFullReservedSize > 0L) {
            this.allocationAllowed = false;
            this.reservationThreshold = 0L;
        } else {
            long currentReservedSize = this.reservedSize.get();
            long pesimisticSpaceRequired = Math.max(this.objectManagerState.logOutput.getLogFileSize(), this.objectManagerState.logOutput.getLogFileSizeRequested()) + this.directoryReservedSize + currentReservedSize;
            long largestFreeSpace = 0L;
            if (this.freeSpaceByLength.size() > 0) {
                largestFreeSpace = ((FreeSpace)this.freeSpaceByLength.last()).length;
            }
            if (pesimisticSpaceRequired <= largestFreeSpace) {
                this.allocationAllowed = true;
            } else {
                storeFileSizeRequired = this.storeFileSizeUsed + pesimisticSpaceRequired;
                if (storeFileSizeRequired <= this.storeFileSizeAllocated) {
                    this.allocationAllowed = true;
                } else if (storeFileSizeRequired <= this.maximumStoreFileSize) {
                    this.allocationAllowed = this.setStoreFileSizeInternal(storeFileSizeRequired);
                } else {
                    if (this.storeFileSizeAllocated < this.maximumStoreFileSize) {
                        this.setStoreFileSizeInternal(this.maximumStoreFileSize);
                    }
                    this.allocationAllowed = false;
                    ++this.numberOfStoreFullCheckpointsTriggered;
                    this.objectManagerState.requestCheckpoint(this.persistent);
                }
                this.reservationThreshold = this.storeFileSizeAllocated - this.storeFileSizeUsed - this.directoryReservedSize;
                this.reservationCheckpointThreshold = Math.min(this.reservationThreshold, currentReservedSize + 5000000L);
            }
        }
        if (this.reservationPacing) {
            ReservationPacingLock reservationPacingLock = this.reservationPacingLock;
            synchronized (reservationPacingLock) {
                this.reservationPacing = false;
                this.reservationPacingLock.notify();
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setAllocationAllowed", new Object[]{new Boolean(this.allocationAllowed), new Long(storeFileSizeRequired)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStoreFileSizeInternalWithException(long storeFileSizeRequired) throws IOException {
        String methodName = "setStoreFileSizeInternalWithException";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setStoreFileSizeInternalWithException", new Object[]{new Long(storeFileSizeRequired), new Long(this.storeFileSizeAllocated), new Long(this.storeFileSizeUsed)});
        }
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(this.storeFileName, "rw");
            f.setLength(storeFileSizeRequired);
            long length = f.length();
            if (length != storeFileSizeRequired) {
                IOException exception = new IOException("Store file size not what was requested.  Requested " + storeFileSizeRequired + ", got + " + length);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "setStoreFileSizeInternalWithException", new Object[]{exception});
                }
                throw exception;
            }
            this.storeFileSizeAllocated = storeFileSizeRequired;
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setStoreFileSizeInternalWithException");
        }
    }

    private boolean setStoreFileSizeInternal(long storeFileSizeRequired) {
        String methodName = "setStoreFileSizeInternal";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setStoreFileSizeInternal", new Object[]{new Long(storeFileSizeRequired), new Long(this.storeFileSizeAllocated), new Long(this.storeFileSizeUsed)});
        }
        boolean allocated = false;
        try {
            this.setStoreFileSizeInternalWithException(storeFileSizeRequired);
            allocated = true;
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "setStoreFileSizeInternal", exception, "1:603:1.57");
            if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                trace.event(this, cclass, "setStoreFileSizeInternal", exception);
            }
            trace.warning((Object)this, cclass, "setStoreFileSizeInternal", "ObjectStore_AllocateFileSpaceFailed", new Object[]{new Long(storeFileSizeRequired), new Long(this.storeFileSizeAllocated), exception});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setStoreFileSizeInternal", new Object[]{new Boolean(allocated)});
        }
        return allocated;
    }

    @Override
    public synchronized void open(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "open";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "open", new Object[]{objectManagerState});
        }
        super.open(objectManagerState);
        this.managedObjectsToWrite = new ConcurrentHashMap(64);
        this.tokensToDelete = new ConcurrentHashMap(64);
        this.newFreeSpace = new TreeSet();
        this.numberOfGetRequests = 0;
        this.numberOfDirectoryNodesRead = 0;
        this.numberOfStoreFullCheckpointsTriggered = 0;
        this.numberOfReservationCheckpointsTriggered = 0;
        this.pacedReservationsReleased = 0;
        this.numberOfManagedObjectsWritten = 0;
        this.storeFileExtendedDuringAllocation = 0L;
        this.reservationPacingLock = new ReservationPacingLock();
        this.getLock = new GetLock();
        this.storeFileName = (String)objectManagerState.objectStoreLocations.get(this.storeName);
        if (this.storeFileName == null) {
            this.storeFileName = this.storeName;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug((Object)this, cclass, "open", new Object[]{"storeName:664", this.storeName, this.storeFileName});
        }
        if (objectManagerState.getObjectManagerStateState() == 2 && !new File(this.storeFileName).exists()) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "open", new Object[]{"File does not exist:673"});
            }
            throw new NonExistentObjectStoreFileException(this, this.storeFileName);
        }
        try {
            this.storeFile = new RandomAccessFile(this.storeFileName, "rw");
        }
        catch (FileNotFoundException exception) {
            ObjectManager.ffdc.processException(this, cclass, "open", exception, "1:685:1.57");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "open", new Object[]{"File not found exception:687"});
            }
            throw new NonExistentObjectStoreFileException(this, exception, this.storeFileName);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reserve(int deltaSize, boolean paced) throws ObjectManagerException {
        long newReservedSize;
        String methodName = "reserve";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "reserve", new Object[]{new Integer(deltaSize), new Boolean(paced)});
        }
        if ((newReservedSize = this.reservedSize.addAndGet(deltaSize)) > this.reservationCheckpointThreshold) {
            Object object;
            ++this.numberOfReservationCheckpointsTriggered;
            this.objectManagerState.requestCheckpoint(this.persistent);
            if (paced) {
                object = this.reservationPacingLock;
                synchronized (object) {
                    while (newReservedSize > this.reservationCheckpointThreshold && this.reservationPacing && paced && (this.objectManagerState.state == 4 || this.objectManagerState.state == 3)) {
                        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                            trace.debug((Object)this, cclass, "reserve", new Object[]{"wait:728", new Long(newReservedSize), new Long(this.reservationCheckpointThreshold), new Long(this.reservationThreshold), new Boolean(this.reservationPacing)});
                        }
                        try {
                            newReservedSize = this.reservedSize.addAndGet(-deltaSize);
                            this.reservationPacingLock.wait();
                        }
                        catch (InterruptedException exception) {
                            ObjectManager.ffdc.processException(this, cclass, "reserve", exception, "1:739:1.57");
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "reserve", exception);
                            }
                            throw new UnexpectedExceptionException((Object)this, exception);
                        }
                        finally {
                            newReservedSize = this.reservedSize.addAndGet(deltaSize);
                        }
                    }
                    if (newReservedSize > this.reservationCheckpointThreshold && (this.objectManagerState.state == 4 || this.objectManagerState.state == 3)) {
                        this.reservationPacing = true;
                    } else {
                        this.reservationPacing = false;
                        this.reservationPacingLock.notify();
                    }
                }
            }
            if (newReservedSize > this.reservationThreshold) {
                object = this;
                synchronized (object) {
                    this.setAllocationAllowed();
                    if (newReservedSize > this.storeFileSizeAllocated - this.storeFileSizeUsed - this.directoryReservedSize) {
                        if (this.objectManagerState.getObjectManagerStateState() == 2 || deltaSize <= 0) {
                            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                                trace.debug((Object)this, cclass, "reserve", new Object[]{"Objectstorefull exception supressed:783", new Long(newReservedSize)});
                            }
                        } else {
                            this.reservedSize.addAndGet(-deltaSize);
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "reserve", new Object[]{new Long(newReservedSize)});
                            }
                            throw new ObjectStoreFullException(this, null);
                        }
                    }
                }
            }
        } else if (this.reservationPacing) {
            ReservationPacingLock reservationPacingLock = this.reservationPacingLock;
            synchronized (reservationPacingLock) {
                ++this.pacedReservationsReleased;
                this.reservationPacing = false;
                this.reservationPacingLock.notify();
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "reserve");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateFull(boolean isFull) throws ObjectManagerException {
        String methodName = "simulateFull";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "simulateFull", new Object[]{new Boolean(isFull)});
        }
        if (isFull) {
            this.objectManagerState.waitForCheckpoint(true);
            AbstractSingleFileObjectStore abstractSingleFileObjectStore = this;
            synchronized (abstractSingleFileObjectStore) {
                long available = this.storeFileSizeAllocated - this.storeFileSizeUsed - this.directoryReservedSize - this.reservedSize.get();
                long newReservedSize = this.reservedSize.addAndGet((int)available);
                this.simulateFullReservedSize += available;
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "simulateFull", new Object[]{"isFull:834", new Long(available), new Long(newReservedSize), new Long(this.simulateFullReservedSize)});
                }
            }
        }
        AbstractSingleFileObjectStore abstractSingleFileObjectStore = this;
        synchronized (abstractSingleFileObjectStore) {
            this.reservedSize.addAndGet((int)(-this.simulateFullReservedSize));
            this.simulateFullReservedSize = 0L;
        }
        this.objectManagerState.waitForCheckpoint(true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "simulateFull", new Object[]{new Long(this.simulateFullReservedSize)});
        }
    }

    @Override
    public void add(ManagedObject managedObject, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        String methodName = "add";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", new Object[]{managedObject, new Boolean(requiresCurrentCheckpoint)});
        }
        super.add(managedObject, requiresCurrentCheckpoint);
        if (requiresCurrentCheckpoint && this.storeStrategy != 2) {
            if (this.checkpointManagedObjectsToWrite == null) {
                this.captureCheckpointManagedObjects();
            }
            this.checkpointManagedObjectsToWrite.put(new Long(managedObject.owningToken.storedObjectIdentifier), managedObject);
        } else {
            Map myManagedObjectsToWrite;
            do {
                myManagedObjectsToWrite = this.managedObjectsToWrite;
                myManagedObjectsToWrite.put(new Long(managedObject.owningToken.storedObjectIdentifier), managedObject);
            } while (myManagedObjectsToWrite != this.managedObjectsToWrite);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "add");
        }
    }

    @Override
    public void remove(Token token, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        SoftReference[] localCachedManagedObjects;
        ManagedObject managedObject;
        String methodName = "remove";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{token, new Boolean(requiresCurrentCheckpoint)});
        }
        super.remove(token, requiresCurrentCheckpoint);
        this.managedObjectsToWrite.remove(new Long(token.storedObjectIdentifier));
        if (this.storeStrategy == 2) {
            Directory.StoreArea storeArea = (Directory.StoreArea)this.directory.getEntry(new Long(token.storedObjectIdentifier));
            if (storeArea != null) {
                this.tokensToDelete.put(new Long(token.storedObjectIdentifier), token);
            }
        } else if (requiresCurrentCheckpoint) {
            if (this.checkpointTokensToDelete == null) {
                this.captureCheckpointManagedObjects();
            }
            this.checkpointTokensToDelete.put(new Long(token.storedObjectIdentifier), token);
        } else {
            Map myTokensToDelete;
            do {
                myTokensToDelete = this.tokensToDelete;
                myTokensToDelete.put(new Long(token.storedObjectIdentifier), token);
            } while (myTokensToDelete != this.tokensToDelete);
        }
        if (token.managedObjectReference != null && (managedObject = (ManagedObject)token.managedObjectReference.get()) != null && managedObject.objectStoreCacheIndex < (localCachedManagedObjects = this.cachedManagedObjects).length) {
            localCachedManagedObjects[managedObject.objectStoreCacheIndex] = null;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "remove");
        }
    }

    synchronized void captureCheckpointManagedObjects() {
        String methodName = "captureCheckpointManagedObjects";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureCheckpointManagedObjects");
        }
        if (this.checkpointManagedObjectsToWrite == null) {
            this.checkpointManagedObjectsToWrite = this.managedObjectsToWrite;
            this.managedObjectsToWrite = new ConcurrentHashMap(64);
            this.checkpointTokensToDelete = this.tokensToDelete;
            this.tokensToDelete = new ConcurrentHashMap(64);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "captureCheckpointManagedObjects");
        }
    }

    void cache(ManagedObject managedObject) {
        int localICache;
        SoftReference[] localCachedManagedObjects = this.cachedManagedObjects;
        if ((localICache = this.iCache++) >= localCachedManagedObjects.length) {
            this.iCache = 0;
            localICache = 0;
        }
        localCachedManagedObjects[localICache] = new SoftReference<ManagedObject>(managedObject);
        managedObject.objectStoreCacheIndex = localICache;
    }

    @Override
    protected synchronized void clear() throws ObjectManagerException {
        String methodName = "clear";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "clear");
        }
        this.inMemoryTokens.clear();
        this.cachedManagedObjects = new SoftReference[this.cachedManagedObjectsSize];
        this.managedObjectsToWrite.clear();
        this.tokensToDelete.clear();
        this.storeFileSizeUsed = 8192L;
        this.freeSpaceByAddressHead = null;
        this.freeSpaceByLength = new TreeSet(new LengthComparator());
        this.freeSpaceStoreArea = null;
        this.sequenceNumber = 200L;
        this.directory = this.makeDirectory(10, 0L, 0L);
        this.directoryReservedSize = this.directory.spaceRequired();
        this.reservedSize.set(0L);
        this.setAllocationAllowed();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "clear");
        }
    }

    @Override
    public synchronized void close() throws ObjectManagerException {
        String methodName = "close";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "close");
        }
        super.close();
        try {
            if (this.storeFile != null) {
                this.storeFile.close();
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "close", exception, "1:1082:1.57");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "close", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "close");
        }
    }

    @Override
    public synchronized void flush() throws ObjectManagerException {
        String methodName = "flush";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "flush");
        }
        if (this.storeStrategy == 2) {
            if (this.objectManagerState.getObjectManagerStateState() != 6) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "flush");
                }
                return;
            }
            if (this.objectManagerState.getTransactionIterator().hasNext()) {
                trace.warning((Object)this, cclass, "flush", "ObjectStore_UnsafeToFlush", this);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "flush");
                }
                return;
            }
        }
        this.updateDirectory();
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug((Object)this, cclass, "flush", "Release new free space");
        }
        this.freeAllocatedSpace(this.newFreeSpace);
        long now = System.currentTimeMillis();
        this.releasingEntrySpaceMilliseconds += now - this.lastFlushMilliseconds;
        this.lastFlushMilliseconds = now;
        this.directory.write();
        now = System.currentTimeMillis();
        this.directoryWriteMilliseconds += now - this.lastFlushMilliseconds;
        this.lastFlushMilliseconds = now;
        this.writeFreeSpace();
        if (this.storeStrategy == 0) {
            this.force();
        }
        this.writeHeader();
        if (this.storeStrategy == 0) {
            this.force();
        }
        this.newFreeSpace.clear();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "flush");
        }
    }

    private void updateDirectory() throws ObjectManagerException {
        String methodName = "updateDirectory";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "updateDirectory");
        }
        if (this.checkpointManagedObjectsToWrite == null) {
            this.captureCheckpointManagedObjects();
        }
        this.checkpointReleaseSize = 0;
        this.lastFlushMilliseconds = System.currentTimeMillis();
        for (ManagedObject managedObject : this.checkpointManagedObjectsToWrite.values()) {
            this.cache(managedObject);
            this.write(managedObject);
        }
        this.checkpointManagedObjectsToWrite = null;
        long now = System.currentTimeMillis();
        this.writingMilliseconds += now - this.lastFlushMilliseconds;
        this.lastFlushMilliseconds = now;
        for (Token token : this.checkpointTokensToDelete.values()) {
            Directory.StoreArea storeArea = (Directory.StoreArea)this.directory.removeEntry(new Long(token.storedObjectIdentifier));
            if (storeArea == null) continue;
            this.newFreeSpace.add(storeArea);
        }
        this.checkpointTokensToDelete = null;
        now = System.currentTimeMillis();
        this.removingEntriesMilliseconds += now - this.lastFlushMilliseconds;
        this.lastFlushMilliseconds = now;
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug((Object)this, cclass, "updateDirectory", "Reserve space for the direcory and new free space map");
        }
        this.directory.reserveSpace();
        now = System.currentTimeMillis();
        this.allocatingEntrySpaceMilliseconds += now - this.lastFlushMilliseconds;
        this.lastFlushMilliseconds = now;
        if (this.freeSpaceStoreArea != null && this.freeSpaceStoreArea.length != 0L) {
            this.newFreeSpace.add(this.freeSpaceStoreArea);
        }
        long newFreeSpaceLength = (this.freeSpaceByLength.size() + this.newFreeSpace.size()) * 16;
        FreeSpace newFreeSpaceArea = this.allocateSpace(newFreeSpaceLength);
        this.freeSpaceStoreArea = this.directory.makeStoreArea(102L, newFreeSpaceArea.address, newFreeSpaceArea.length);
        this.directoryReservedSize = this.directory.spaceRequired();
        this.reservedSize.addAndGet(-this.checkpointReleaseSize);
        this.setAllocationAllowed();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "updateDirectory");
        }
    }

    FreeSpace allocateSpace(long lengthRequired) throws ObjectManagerException {
        FreeSpace freeSpace;
        SortedSet<FreeSpace> tailSet;
        String methodName = "allocateSpace";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "allocateSpace", new Object[]{new Long(lengthRequired)});
        }
        if (!(tailSet = this.freeSpaceByLength.tailSet(new FreeSpace(0L, lengthRequired))).isEmpty()) {
            freeSpace = tailSet.first();
            tailSet.remove(freeSpace);
            long remainingLength = freeSpace.length - lengthRequired;
            if (remainingLength < 17L) {
                if (freeSpace.prev != null) {
                    freeSpace.prev.next = freeSpace.next;
                } else {
                    this.freeSpaceByAddressHead = freeSpace.next;
                }
                if (freeSpace.next != null) {
                    freeSpace.next.prev = freeSpace.prev;
                }
                freeSpace.next = null;
                freeSpace.prev = null;
            } else {
                freeSpace.length = remainingLength;
                this.freeSpaceByLength.add(freeSpace);
                freeSpace = new FreeSpace(freeSpace.address + remainingLength, lengthRequired);
            }
        } else {
            freeSpace = new FreeSpace(this.storeFileSizeUsed, lengthRequired);
            long newStoreFileSizeUsed = this.storeFileSizeUsed + lengthRequired;
            if (newStoreFileSizeUsed > this.storeFileSizeAllocated) {
                ++this.storeFileExtendedDuringAllocation;
                if (this.storeStrategy == 0 && (this.objectManagerState.logFileType == 0 || this.objectManagerState.logFileType == 2)) {
                    ObjectManager.ffdc.processException(this, cclass, "allocateSpace", new Exception("Extended allocated file"), "1:1437:1.57", new Object[]{new Long(newStoreFileSizeUsed), new Long(this.storeFileSizeAllocated)});
                    if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                        trace.debug((Object)this, cclass, "allocateSpace", new Object[]{"STRATEGY_KEEP_ALWAYS:1440", new Long(newStoreFileSizeUsed), new Long(this.storeFileSizeAllocated)});
                    }
                }
                if (newStoreFileSizeUsed > this.maximumStoreFileSize || !this.setStoreFileSizeInternal(newStoreFileSizeUsed)) {
                    this.allocationAllowed = false;
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "allocateSpace", new Object[]{"ObjectStoreFull"});
                    }
                    throw new ObjectStoreFullException(this, null);
                }
            }
            this.storeFileSizeUsed = newStoreFileSizeUsed;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "allocateSpace", new Object[]{freeSpace});
        }
        return freeSpace;
    }

    private void freeAllocatedSpace(Collection sortedFreeSpaceList) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "freeAllocatedSpace", new Object[]{new Integer(sortedFreeSpaceList.size()), new Long(this.freeSpaceByLength.size())});
        }
        java.util.Iterator listIterator = sortedFreeSpaceList.iterator();
        Directory.StoreArea currentArea = null;
        while (listIterator.hasNext()) {
            currentArea = (Directory.StoreArea)listIterator.next();
            if (currentArea.byteAddress <= 0L) continue;
        }
        if (currentArea != null) {
            FreeSpace spaceEntry = this.freeSpaceByAddressHead;
            FreeSpace previousEntry = null;
            do {
                FreeSpace nextSpaceEntry;
                if (spaceEntry == null || spaceEntry.address > currentArea.byteAddress) {
                    if (currentArea.length > 0L) {
                        FreeSpace newSpaceEntry = new FreeSpace(currentArea.byteAddress, currentArea.length);
                        newSpaceEntry.next = spaceEntry;
                        if (previousEntry != null) {
                            previousEntry.next = newSpaceEntry;
                        } else {
                            this.freeSpaceByAddressHead = newSpaceEntry;
                        }
                        newSpaceEntry.prev = previousEntry;
                        if (spaceEntry != null) {
                            spaceEntry.prev = newSpaceEntry;
                        }
                        this.freeSpaceByLength.add(newSpaceEntry);
                        if (this.freeSpaceByLength.size() > this.maxFreeSpaceCount) {
                            this.maxFreeSpaceCount = this.freeSpaceByLength.size();
                        }
                        spaceEntry = newSpaceEntry;
                    }
                    if (listIterator.hasNext()) {
                        currentArea = (Directory.StoreArea)listIterator.next();
                        continue;
                    }
                    currentArea = null;
                    continue;
                }
                if (spaceEntry.address + spaceEntry.length == currentArea.byteAddress) {
                    this.freeSpaceByLength.remove(spaceEntry);
                    spaceEntry.length += currentArea.length;
                    nextSpaceEntry = spaceEntry.next;
                    if (nextSpaceEntry != null && currentArea.byteAddress + currentArea.length == nextSpaceEntry.address) {
                        this.freeSpaceByLength.remove(nextSpaceEntry);
                        spaceEntry.length += nextSpaceEntry.length;
                        spaceEntry.next = nextSpaceEntry.next;
                        if (nextSpaceEntry.next != null) {
                            nextSpaceEntry.next.prev = spaceEntry;
                        }
                    }
                    this.freeSpaceByLength.add(spaceEntry);
                    if (listIterator.hasNext()) {
                        currentArea = (Directory.StoreArea)listIterator.next();
                        continue;
                    }
                    currentArea = null;
                    continue;
                }
                if (spaceEntry.next != null && currentArea.byteAddress + currentArea.length == spaceEntry.next.address) {
                    nextSpaceEntry = spaceEntry.next;
                    this.freeSpaceByLength.remove(nextSpaceEntry);
                    nextSpaceEntry.address = currentArea.byteAddress;
                    nextSpaceEntry.length += currentArea.length;
                    this.freeSpaceByLength.add(nextSpaceEntry);
                    if (listIterator.hasNext()) {
                        currentArea = (Directory.StoreArea)listIterator.next();
                        continue;
                    }
                    currentArea = null;
                    continue;
                }
                previousEntry = spaceEntry;
                spaceEntry = spaceEntry.next;
            } while (currentArea != null);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "freeAllocatedSpace", new Object[]{new Long(this.freeSpaceByLength.size())});
        }
    }

    @Override
    public Map captureStatistics() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        Map statistics = super.captureStatistics();
        statistics.put("managedobjectsToWrite.size()", Integer.toString(this.managedObjectsToWrite.size()));
        statistics.put("reservedSize", this.reservedSize.toString());
        statistics.put("directoryReservedSize", Long.toString(this.directoryReservedSize));
        statistics.put("tokensToDelete.size()", Integer.toString(this.tokensToDelete.size()));
        statistics.put("directory.size()", Long.toString(this.directory.size()));
        statistics.put("storeFileSizeUsed", Long.toString(this.storeFileSizeUsed));
        statistics.put("storeFileSizeAllocated", Long.toString(this.storeFileSizeAllocated));
        statistics.put("freeSpaceByLength.size()", Integer.toString(this.freeSpaceByLength.size()));
        statistics.put("maxFreeSpaceCount", Integer.toString(this.maxFreeSpaceCount));
        statistics.put("numberOfGetRequests", Integer.toString(this.numberOfGetRequests));
        this.numberOfGetRequests = 0;
        statistics.put("storeFileExtendedDuringAllocation", Long.toString(this.storeFileExtendedDuringAllocation));
        this.storeFileExtendedDuringAllocation = 0L;
        statistics.put("numberOfDirectoryNodesRead", Integer.toString(this.numberOfDirectoryNodesRead));
        this.numberOfDirectoryNodesRead = 0;
        statistics.put("numberOfStoreFullCheckpointsTriggered", Integer.toString(this.numberOfStoreFullCheckpointsTriggered));
        this.numberOfStoreFullCheckpointsTriggered = 0;
        statistics.put("numberOfReservationCheckpointsTriggered", Integer.toString(this.numberOfReservationCheckpointsTriggered));
        this.numberOfReservationCheckpointsTriggered = 0;
        statistics.put("pacedReservationsReleased", Integer.toString(this.pacedReservationsReleased));
        this.pacedReservationsReleased = 0;
        statistics.put("numberOfManagedObjectsWritten", Integer.toString(this.numberOfManagedObjectsWritten));
        this.numberOfManagedObjectsWritten = 0;
        statistics.put("writingMilliseconds", Long.toString(this.writingMilliseconds));
        this.writingMilliseconds = 0L;
        statistics.put("removingEntriesMilliseconds", Long.toString(this.removingEntriesMilliseconds));
        this.removingEntriesMilliseconds = 0L;
        statistics.put("allocatingEntrySpaceMilliseconds", Long.toString(this.allocatingEntrySpaceMilliseconds));
        this.allocatingEntrySpaceMilliseconds = 0L;
        statistics.put("releasingEntrySpaceMilliseconds", Long.toString(this.releasingEntrySpaceMilliseconds));
        this.releasingEntrySpaceMilliseconds = 0L;
        statistics.put("directoryWriteMilliseconds", Long.toString(this.directoryWriteMilliseconds));
        this.directoryWriteMilliseconds = 0L;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", "return=" + statistics);
        }
        return statistics;
    }

    @Override
    public synchronized void print(PrintWriter printWriter) {
        super.print(printWriter);
        try {
            printWriter.println("State Dump for:" + cclass.getName() + "\n storeFile=" + this.storeFile + "(java.io.RandomaccessFile)\n storeFileSizeUsed=" + this.storeFileSizeUsed + "(long) storeFileSizeAllocated=" + this.storeFileSizeAllocated + "(long) reservedSize=" + this.reservedSize + "(long) directoryReservedSize=" + this.directoryReservedSize + "(long)\n minimumStoreFileSize=" + this.minimumStoreFileSize + " maximumStoreFileSize=" + this.maximumStoreFileSize + "\n ((Directory.Node)directory.root).byteAddress=" + ((Directory.Node)this.directory.root).byteAddress + "((Directory.Node)directory.root).length=" + ((Directory.Node)this.directory.root).length + " directory.size()=" + this.directory.size() + "\n freeSpaceStoreArea=" + this.freeSpaceStoreArea);
            printWriter.println();
            printWriter.println("managedObjectsToWrite...");
            for (ManagedObject managedObject : this.managedObjectsToWrite.values()) {
                printWriter.println(managedObject.toString());
            }
            printWriter.println("tokensToDelete...");
            for (Token token : this.tokensToDelete.values()) {
                printWriter.println(token.toString());
            }
            printWriter.println("directory...");
            printWriter.println("identifier          byteAddress         length");
            printWriter.println("directoryRoot       " + (((Directory.Node)this.directory.root).byteAddress + "                    ").substring(0, 20) + (((Directory.Node)this.directory.root).length + "                    ").substring(0, 20));
            Iterator storeAreaIterator = this.directory.entrySet().iterator();
            while (storeAreaIterator.hasNext()) {
                Directory.StoreArea storeArea = (Directory.StoreArea)storeAreaIterator.next();
                printWriter.println((storeArea.identifier + "                    ").substring(0, 20) + (storeArea.byteAddress + "                    ").substring(0, 20) + (storeArea.length + "                    ").substring(0, 20));
                Directory.Node child = (Directory.Node)storeArea.getChild();
                if (child == null) continue;
                printWriter.println("directoryMetaData   " + (child.byteAddress + "                    ").substring(0, 20) + (child.length + "                    ").substring(0, 20));
                if (storeArea.next.getKey() != null) continue;
                storeArea = (Directory.StoreArea)storeArea.next;
                child = (Directory.Node)storeArea.getChild();
                printWriter.println("directoryMetaData   " + (child.byteAddress + "                    ").substring(0, 20) + (child.length + "                    ").substring(0, 20));
            }
        }
        catch (ObjectManagerException objectManagerException) {
            printWriter.println("Caught objectManagerException=" + objectManagerException);
            objectManagerException.printStackTrace(printWriter);
        }
        printWriter.println("cachedManagedObjects...");
        for (int i = 0; i < this.cachedManagedObjects.length; ++i) {
            if (this.cachedManagedObjects[i] == null) continue;
            printWriter.println(i + " " + this.cachedManagedObjects[i].toString());
        }
        printWriter.println("freeSpaceByLength.size()=" + this.freeSpaceByLength.size() + "\n... Address(long) Length(Long)");
        for (FreeSpace freeSpace : this.freeSpaceByLength) {
            printWriter.println(freeSpace.address + " " + freeSpace.length);
        }
        printWriter.println("newFreeSpace.size()=" + this.newFreeSpace.size() + "\n... Address(long) Length(Long)");
        for (Directory.StoreArea storeArea : this.newFreeSpace) {
            printWriter.println(storeArea.byteAddress + " " + storeArea.length);
        }
    }

    @Override
    public synchronized boolean validate(PrintStream printStream) throws ObjectManagerException {
        Directory.StoreArea existing;
        Directory.StoreArea storeArea2;
        String methodName = "validate";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "validate", new Object[]{printStream});
        }
        boolean valid = true;
        valid = this.directory.validate(printStream);
        TreeMap<Long, Directory.StoreArea> storeAreas = new TreeMap<Long, Directory.StoreArea>();
        Iterator directoryIterator = this.directory.entrySet().iterator();
        while (directoryIterator.hasNext()) {
            Directory.Node child;
            storeArea2 = (Directory.StoreArea)directoryIterator.next();
            existing = storeAreas.put(new Long(storeArea2.byteAddress), storeArea2);
            if (existing != null) {
                printStream.println("storeArea " + storeArea2 + " payload reused byte Address storeArea.byteAddress=" + storeArea2.byteAddress + " storeArea.length=" + storeArea2.length + " existing.length=" + existing.length + " existing.identifier=" + existing.identifier);
                valid = false;
            }
            if ((child = (Directory.Node)storeArea2.getChild()) == null) continue;
            Directory.StoreArea metaData = this.directory.makeStoreArea(0L, child.byteAddress, child.length);
            existing = storeAreas.put(new Long(metaData.byteAddress), metaData);
            if (existing != null) {
                printStream.println("storeArea " + storeArea2 + " child reused byte Address child.byteAddress=" + child.byteAddress + " child.length=" + child.length + " existing.length=" + existing.length + " existing.identifier=" + existing.identifier);
                valid = false;
            }
            if (storeArea2.next.getKey() != null) continue;
            storeArea2 = (Directory.StoreArea)storeArea2.next;
            child = (Directory.Node)storeArea2.getChild();
            metaData = this.directory.makeStoreArea(0L, child.byteAddress, child.length);
            existing = storeAreas.put(new Long(metaData.byteAddress), metaData);
            if (existing == null) continue;
            printStream.println("storeArea " + storeArea2 + " greater than child reused byte Address child.byteAddress=" + child.byteAddress + " child.length=" + child.length + " existing.length=" + existing.length + " existing.identifier=" + existing.identifier);
            valid = false;
        }
        if (((Directory.Node)this.directory.root).length != 0L && (existing = storeAreas.put(new Long(storeArea2.byteAddress), storeArea2 = this.directory.makeStoreArea(0L, ((Directory.Node)this.directory.root).byteAddress, ((Directory.Node)this.directory.root).length))) != null) {
            printStream.println("storeArea " + storeArea2 + " directory root reused byte Address storeArea.byteAddress=" + storeArea2.byteAddress + " storeArea.length=" + storeArea2.length + " existing.length=" + existing.length + " existing.identifier=" + existing.identifier);
            valid = false;
        }
        int freeSpaceCount = 0;
        FreeSpace freeSpace = this.freeSpaceByAddressHead;
        FreeSpace prevFreeSpace = null;
        while (freeSpace != null) {
            storeArea2 = this.directory.makeStoreArea(0L, freeSpace.address, freeSpace.length);
            existing = storeAreas.put(new Long(storeArea2.byteAddress), storeArea2);
            if (existing != null) {
                printStream.println("freeSpace storeArea " + storeArea2 + " reused byte Address storeArea.byteAddress=" + storeArea2.byteAddress + " storeArea.length=" + storeArea2.length + " existing.length=" + existing.length + " existing.identifier=" + existing.identifier);
                valid = false;
            }
            if (freeSpace.prev != prevFreeSpace) {
                printStream.println("freeSpaceByAddress list invalid prevFreeSpace=" + prevFreeSpace + " freeSpace.prev=" + freeSpace.prev);
            }
            if (prevFreeSpace != null && freeSpace.address <= prevFreeSpace.address) {
                printStream.println("freeSpaceByAddress list out of order freeSpace.address=" + freeSpace.address + " freeSpace.length=" + freeSpace.length + " prevFreeSpace.address=" + prevFreeSpace.address + " prevFreeSpace.length=" + prevFreeSpace.length);
            }
            prevFreeSpace = freeSpace;
            freeSpace = freeSpace.next;
            ++freeSpaceCount;
        }
        if (freeSpaceCount != this.freeSpaceByLength.size()) {
            printStream.println("freeSpaceByAddress.size()=" + freeSpaceCount + " freeSpaceByLength.size()=" + this.freeSpaceByLength.size());
            valid = false;
        }
        if (this.freeSpaceStoreArea != null && this.freeSpaceStoreArea.length != 0L && (existing = storeAreas.put(new Long(this.freeSpaceStoreArea.byteAddress), this.freeSpaceStoreArea)) != null) {
            printStream.println("freeSpaceStoreArea " + this.freeSpaceStoreArea + " reused byte Address freeSpaceStoreArea.byteAddress=" + this.freeSpaceStoreArea.byteAddress + " freeSpaceStoreArea.length=" + this.freeSpaceStoreArea.length + " existing.length=" + existing.length + " existing.identifier=" + existing.identifier);
            valid = false;
        }
        Directory.StoreArea previous = this.directory.makeStoreArea(0L, 0L, 8192L);
        for (Directory.StoreArea storeArea2 : storeAreas.values()) {
            long gap = storeArea2.byteAddress - (previous.byteAddress + previous.length);
            if (gap > 0L) {
                printStream.println("previous.byteAddress=" + previous.byteAddress + " previous.length=" + previous.length + " gap=" + gap + " storeArea.byteAddress=" + storeArea2.byteAddress + " storeArea.length=" + storeArea2.length);
                valid = false;
            } else if (gap < 0L) {
                printStream.println("previous.byteAddress=" + previous.byteAddress + " previous.length=" + previous.length + " overlap=" + -gap + " storeArea.byteAddress=" + storeArea2.byteAddress + " storeArea.length=" + storeArea2.length);
                valid = false;
            }
            previous = storeArea2;
        }
        if (this.storeFileSizeUsed != previous.byteAddress + previous.length) {
            printStream.println("storeFileLength not valid previous.byteAddress + previous.length=" + (previous.byteAddress + previous.length) + " storeFileSizeUsed=" + this.storeFileSizeUsed);
            valid = false;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "validate", new Object[]{new Boolean(valid)});
        }
        return valid;
    }

    @Override
    public Set tokens() {
        if (this.tokenSet == null) {
            this.tokenSet = new AbstractSetView(){

                @Override
                public long size() throws ObjectManagerException {
                    return AbstractSingleFileObjectStore.this.directory.size();
                }

                @Override
                public Iterator iterator() throws ObjectManagerException {
                    final Iterator storeAreaIterator = AbstractSingleFileObjectStore.this.directory.entrySet().iterator();
                    return new Iterator(){

                        @Override
                        public boolean hasNext() throws ObjectManagerException {
                            return storeAreaIterator.hasNext();
                        }

                        @Override
                        public Object next() throws ObjectManagerException {
                            Directory.StoreArea storeArea = (Directory.StoreArea)storeAreaIterator.next();
                            Token token = new Token(AbstractSingleFileObjectStore.this, storeArea.identifier);
                            return AbstractSingleFileObjectStore.this.like(token);
                        }

                        @Override
                        public boolean hasNext(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object next(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object remove(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return this.tokenSet;
    }

    abstract Directory makeDirectory(int var1, long var2, long var4) throws ObjectManagerException;

    abstract void write(ManagedObject var1) throws ObjectManagerException;

    abstract void writeFreeSpace() throws ObjectManagerException;

    abstract void writeHeader() throws ObjectManagerException;

    abstract void force() throws ObjectManagerException;

    static interface AtomicXXBitLong {
        public long addAndGet(long var1);

        public long get();

        public void set(long var1);
    }

    class FreeSpace {
        long length;
        long address;
        FreeSpace prev;
        FreeSpace next;

        FreeSpace(long address, long length) {
            this.length = length;
            this.address = address;
        }
    }

    private class ReservationPacingLock {
        private ReservationPacingLock() {
        }
    }

    class GetLock
    extends ReentrantReadWriteLockImpl {
        GetLock() {
        }
    }

    abstract class Directory
    extends BTree {
        private final Class cclass;

        Directory(int minimumNodeSize, long directoryRootByteAddress, long directoryRootLength) throws ObjectManagerException {
            super(minimumNodeSize);
            this.cclass = Directory.class;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Integer(minimumNodeSize), new Long(directoryRootByteAddress), new Long(directoryRootLength)});
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, this.cclass, "<init>");
            }
        }

        void reserveSpace() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "reserveSpace");
            }
            ((Node)this.root).reserveSpace();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, this.cclass, "reserveSpace");
            }
        }

        long spaceRequired() throws ObjectManagerException {
            String methodName = "spaceRequired";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "spaceRequired");
            }
            int worstCaseNodeSize = this.getMinimumNodeSize() * 2 * 40 + 4 + 1 + 16;
            long nodesAtThisLevel = 1L;
            long spaceRequired = 0L;
            Node node = (Node)this.root;
            while (node != null) {
                spaceRequired += nodesAtThisLevel * (long)worstCaseNodeSize;
                nodesAtThisLevel = nodesAtThisLevel == 1L ? (long)node.numberOfKeys : nodesAtThisLevel * (long)this.getMinimumNodeSize() * 2L;
                if (node.first == null) {
                    node = null;
                    continue;
                }
                node = (Node)node.first.getChild();
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, this.cclass, "spaceRequired", new Object[]{new Long(spaceRequired)});
            }
            return spaceRequired;
        }

        void write() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, this.cclass, "write");
            }
            ((Node)this.root).write();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, this.cclass, "write");
            }
        }

        void setRoot(Node newRoot) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "setRoot", new Object[]{newRoot});
            }
            super.setRoot(newRoot);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, this.cclass, "setRoot");
            }
        }

        @Override
        abstract BTree.Node makeNode(BTree.Node var1) throws ObjectManagerException;

        @Override
        abstract BTree.Entry makeEntry(Object var1, Object var2) throws ObjectManagerException;

        abstract StoreArea makeStoreArea(long var1, long var3, long var5) throws ObjectManagerException;

        abstract class Node
        extends BTree.Node {
            private final Class cclass;
            static final byte flagIsLeaf = 0;
            static final byte flagIsNotLeaf = 1;
            boolean modified;
            int dormantFlushCount;
            static final int initialDormantFlushCount = 2;
            long byteAddress;
            long length;

            Node(Node parent) {
                super(Directory.this, parent);
                this.cclass = Node.class;
                this.modified = false;
                this.byteAddress = 0L;
                this.length = 0L;
            }

            @Override
            public long size() throws ObjectManagerException {
                long size;
                String methodName = "size";
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, this.cclass, "size");
                }
                BTree.Entry entry = this.first;
                if (this.isLeaf) {
                    size = this.numberOfKeys;
                } else {
                    size = -1L;
                    while (entry != null) {
                        boolean childWasNull = entry.child == null;
                        size += entry.getChild().size();
                        if (childWasNull) {
                            entry.child = null;
                        }
                        ++size;
                        entry = entry.next;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, this.cclass, "size", new Object[]{new Long(size)});
                }
                return size;
            }

            void reserveSpace() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "reserveSpace", new Object[]{new Boolean(this.modified), new Integer(this.dormantFlushCount)});
                }
                if (!this.isLeaf) {
                    StoreArea storeArea = (StoreArea)this.first;
                    while (storeArea != null) {
                        if (storeArea.child != null) {
                            ((Node)storeArea.child).reserveSpace();
                            if (((Node)storeArea.child).dormantFlushCount == 0) {
                                storeArea.childSoftReference = new SoftReference<BTree.Node>(storeArea.child);
                                storeArea.child = null;
                            }
                        }
                        storeArea = (StoreArea)storeArea.next;
                    }
                }
                --this.dormantFlushCount;
                if (this.modified) {
                    if (this.length != 0L) {
                        AbstractSingleFileObjectStore.this.newFreeSpace.add(Directory.this.makeStoreArea(0L, this.byteAddress, this.length));
                    }
                    FreeSpace freeSpace = AbstractSingleFileObjectStore.this.allocateSpace(this.writtenSize());
                    this.byteAddress = freeSpace.address;
                    this.length = freeSpace.length;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "reserveSpace");
                }
            }

            long writtenSize() {
                long size = this.isLeaf ? (long)(5 + this.numberOfKeys * 3 * 8) : (long)(5 + this.numberOfKeys * 5 * 8 + 16);
                return size;
            }

            abstract void write() throws ObjectManagerException;

            @Override
            BTree.Entry split() throws ObjectManagerException {
                this.modified = true;
                this.dormantFlushCount = 2;
                return super.split();
            }

            @Override
            BTree.Entry insert(BTree.Entry newEntry) throws ObjectManagerException {
                this.modified = true;
                BTree.Entry replacedEntry = super.insert(newEntry);
                return replacedEntry;
            }

            @Override
            BTree.Entry delete(Object key) throws ObjectManagerException {
                this.modified = true;
                Node currentRoot = (Node)Directory.this.root;
                BTree.Entry deletedEntry = super.delete(key);
                if (!this.isLeaf && this.numberOfKeys == 0 && currentRoot.length != 0L) {
                    AbstractSingleFileObjectStore.this.newFreeSpace.add(Directory.this.makeStoreArea(0L, currentRoot.byteAddress, currentRoot.length));
                }
                return deletedEntry;
            }

            @Override
            BTree.Entry removeLastEntryAndFollowingNode() throws ObjectManagerException {
                this.modified = true;
                return super.removeLastEntryAndFollowingNode();
            }

            @Override
            BTree.Entry removeFirstEntryAndPrecedingNode() {
                this.modified = true;
                return super.removeFirstEntryAndPrecedingNode();
            }

            @Override
            public void clear() throws ObjectManagerException {
                this.modified = true;
                super.clear();
            }
        }

        abstract class StoreArea
        extends BTree.Entry
        implements Comparable {
            private final Class cclass;
            static final int maximumWrittenSize = 40;
            protected long identifier;
            protected long byteAddress;
            protected long length;
            protected long childByteAddress;
            protected long childLength;
            SoftReference childSoftReference;

            StoreArea(Object key, Object value) {
                super(Directory.this, key, value);
                this.cclass = StoreArea.class;
                this.identifier = 0L;
                this.byteAddress = 0L;
                this.length = 0L;
                this.childByteAddress = 0L;
                this.childLength = 0L;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, this.cclass, "<init>");
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            StoreArea(long identifier, long byteAddress, long length) {
                super(Directory.this, new Long(identifier), null);
                this.cclass = StoreArea.class;
                this.identifier = 0L;
                this.byteAddress = 0L;
                this.length = 0L;
                this.childByteAddress = 0L;
                this.childLength = 0L;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Long(identifier), new Long(byteAddress), new Long(length)});
                }
                this.identifier = identifier;
                this.byteAddress = byteAddress;
                this.length = length;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            long getChildByteAddress() {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, this.cclass, "getChildByteAddress");
                }
                long address = this.child == null ? this.childByteAddress : ((Node)this.child).byteAddress;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, this.cclass, "getChildByteAddress", new Object[]{new Long(address)});
                }
                return address;
            }

            long getChildLength() {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, this.cclass, "getChildLength");
                }
                long length = this.child == null ? this.childLength : ((Node)this.child).length;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, this.cclass, "getChildLength", new Object[]{new Long(length)});
                }
                return length;
            }

            @Override
            void setChild(BTree.Node child) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "setChild", new Object[]{child});
                }
                super.setChild(child);
                if (child == null) {
                    this.childByteAddress = 0L;
                    this.childLength = 0L;
                } else {
                    this.childByteAddress = ((Node)child).byteAddress;
                    this.childLength = ((Node)child).length;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, this.cclass, "setChild", new Object[]{new Long(this.childByteAddress), new Long(this.childLength)});
                }
            }

            @Override
            void mergeChildWithGreaterThanChild() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry(this, this.cclass, "mergeChildWithGreaterThanChild");
                }
                Node dropped = (Node)this.next.getChild();
                if (dropped.length != 0L) {
                    AbstractSingleFileObjectStore.this.newFreeSpace.add(Directory.this.makeStoreArea(0L, dropped.byteAddress, dropped.length));
                }
                super.mergeChildWithGreaterThanChild();
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, this.cclass, "mergeChildWithGreaterThanChild", new Object[]{dropped});
                }
            }

            public int compareTo(Object other) {
                long diff = this.byteAddress - ((StoreArea)other).byteAddress;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object other) {
                return ((StoreArea)other).byteAddress == this.byteAddress;
            }

            @Override
            public String toString() {
                return new String("Directory.StoreArea(identifier=" + this.identifier + " byteAddress=" + this.byteAddress + " length=" + this.length + ") " + super.toString());
            }
        }
    }

    class LengthComparator
    implements Comparator {
        LengthComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            FreeSpace freeSpace0 = (FreeSpace)arg0;
            FreeSpace freeSpace1 = (FreeSpace)arg1;
            if (freeSpace0.length < freeSpace1.length) {
                return -1;
            }
            if (freeSpace0.length > freeSpace1.length) {
                return 1;
            }
            if (freeSpace0.address < freeSpace1.address) {
                return -1;
            }
            if (freeSpace0.address > freeSpace1.address) {
                return 1;
            }
            return 0;
        }
    }

    class AddressComparator
    implements Comparator {
        AddressComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            FreeSpace freeSpace0 = (FreeSpace)arg0;
            FreeSpace freeSpace1 = (FreeSpace)arg1;
            if (freeSpace0.address < freeSpace1.address) {
                return -1;
            }
            if (freeSpace0.address > freeSpace1.address) {
                return 1;
            }
            return 0;
        }
    }

    class Atomic32BitLong
    implements AtomicXXBitLong {
        AtomicInteger intValue;

        Atomic32BitLong(long longValue) {
            this.intValue = new AtomicIntegerImpl((int)longValue);
        }

        @Override
        public final long addAndGet(long longValue) {
            return this.intValue.addAndGet((int)longValue);
        }

        @Override
        public final long get() {
            return this.intValue.get();
        }

        @Override
        public final void set(long longValue) {
            this.intValue.set((int)longValue);
        }
    }

    class Atomic64BitLong
    extends AtomicLongImpl
    implements AtomicXXBitLong {
        private static final long serialVersionUID = 1L;

        Atomic64BitLong(long longValue) {
            super(longValue);
        }
    }
}

