/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InstallAsset {
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.install");
    private static final String DEFAULT_NAME = "";
    private static final boolean DEFAULT_TEMP = true;
    protected String name;
    protected File asset;
    private final boolean temporary;

    public InstallAsset(boolean temporary) {
        this(DEFAULT_NAME, null, temporary);
    }

    public InstallAsset(File assetFile) {
        this(DEFAULT_NAME, assetFile, true);
    }

    public InstallAsset(File assetFile, boolean temporary) {
        this(DEFAULT_NAME, assetFile, temporary);
    }

    public InstallAsset(String name, File assetFile) {
        this(name, assetFile, true);
    }

    public InstallAsset(String name, File assetFile, boolean temporary) {
        this.name = name;
        this.temporary = temporary;
        this.asset = assetFile;
    }

    public void delete() {
        if (this.asset != null && this.isTemporary()) {
            try {
                Files.delete(this.asset.toPath());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "{0}", e.getMessage());
                logger.log(Level.FINEST, "Failed to delete asset.", e);
                this.asset.deleteOnExit();
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean isFeature() {
        return false;
    }

    public boolean isFix() {
        return false;
    }

    public boolean isServerPackage() {
        return false;
    }

    protected boolean isTemporary() {
        return this.temporary;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAddon() {
        return false;
    }

    public boolean isSample() {
        return false;
    }

    public boolean isOpenSource() {
        return false;
    }

    public File getAsset() {
        return this.asset;
    }

    public String installedLogMsg() {
        return DEFAULT_NAME;
    }

    public static void log(String msg) {
        if (logger != null) {
            logger.log(Level.FINE, msg);
        }
    }

    protected File download(File installTempDir, RepositoryResource installResource) throws InstallException {
        try {
            String url = installResource.getMainAttachment().getURL();
            logger.log(Level.FINEST, "Downloading " + installResource.getName() + " from " + (url.contains("public.dhe.ibm.com") ? "the IBM WebSphere Liberty Repository" : url + " of the repository " + installResource.getRepositoryConnection().getRepositoryLocation()));
            File d = InstallUtils.download(installTempDir, installResource);
            logger.log(Level.FINEST, d == null ? installResource.getName() + " is an unsupported type " + installResource.getType() + " to be downloaded." : "Downloaded " + installResource.getName() + " from " + (url.contains("public.dhe.ibm.com") ? "the IBM WebSphere Liberty Repository" : url + " of the repository " + installResource.getRepositoryConnection().getRepositoryLocation()) + " to " + d.getAbsolutePath());
            return d;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionUtils.createFailedToDownload(installResource, e, installTempDir);
        }
    }

    public void download(File installTempDir) throws InstallException {
    }

    public RepositoryResource getRepositoryResource() {
        return null;
    }

    public void cleanup() {
    }
}

