/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.destination;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PtoPOutputHandler;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.destination.LocalisationManager;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIContainerItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOContainerItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPReceiveMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SourceProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.impl.AnycastInputControl;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractRemoteSupport {
    private static final TraceComponent tc = SibTr.register(AbstractRemoteSupport.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected BaseDestinationHandler _baseDestinationHandler;
    protected MessageProcessor _messageProcessor;
    protected DestinationManager _destinationManager;
    protected TargetProtocolItemStream _targetProtocolItemStream;
    protected SourceProtocolItemStream _sourceProtocolItemStream;
    protected AnycastOutputHandler _anycastOutputHandler = null;
    protected AOContainerItemStream _aoContainerItemStream = null;
    protected HashMap<String, AnycastInputHandler> _anycastInputHandlers = new HashMap();
    protected HashMap<String, AIContainerItemStream> _aiContainerItemStreams = new HashMap();
    protected HashMap<String, PtoPReceiveMsgsItemStream> _rcdItemStreams = new HashMap();
    private boolean _toBeDeleted;

    public AbstractRemoteSupport(BaseDestinationHandler myBaseDestinationHandler, MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractRemoteSupport", (Object)new Object[]{myBaseDestinationHandler, messageProcessor});
        }
        this._baseDestinationHandler = myBaseDestinationHandler;
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractRemoteSupport", (Object)this);
        }
    }

    public void reconstituteAnycastRMEPhaseOne() throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteAnycastRMEPhaseOne");
        }
        NonLockingCursor cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(AIContainerItemStream.class));
        AIContainerItemStream aiTempItemStream = null;
        do {
            if ((aiTempItemStream = (AIContainerItemStream)cursor.next()) == null) continue;
            if (aiTempItemStream.getDurablePseudoDestID() != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstituteAnycastRME", (Object)"SIResourceException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.reconstituteAnycastRMEPhaseOne", "1:230:1.25", null}, null));
            }
            String key = SIMPUtils.getRemoteGetKey(aiTempItemStream.getDmeId(), aiTempItemStream.getGatheringTargetDestUuid());
            this._aiContainerItemStreams.put(key, aiTempItemStream);
        } while (aiTempItemStream != null);
        cursor.finished();
        cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(PtoPReceiveMsgsItemStream.class));
        PtoPReceiveMsgsItemStream rcdTempItemStream = (PtoPReceiveMsgsItemStream)cursor.next();
        if (rcdTempItemStream != null && !rcdTempItemStream.isRestoring()) {
            try {
                LocalTransaction tran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                do {
                    rcdTempItemStream.reconstitute(this._baseDestinationHandler);
                    rcdTempItemStream.reallocateMsgs();
                    rcdTempItemStream.remove((Transaction)tran, -2L);
                } while ((rcdTempItemStream = (PtoPReceiveMsgsItemStream)cursor.next()) != null);
                tran.commit();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.reconstituteAnycastRMEPhaseOne", (String)"1:273:1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstituteAnycastRMEPhaseOne", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        cursor.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteAnycastRMEPhaseOne");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteAnycastRMEPhaseTwo(int startMode, DestinationDefinition definition) throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteAnycastRMEPhaseTwo", (Object)new Object[]{startMode, definition});
        }
        boolean flush = false;
        if ((startMode & 1) == 1 && (startMode & 2) == 0) {
            flush = true;
        }
        HashMap<String, AnycastInputHandler> hashMap = this._anycastInputHandlers;
        synchronized (hashMap) {
            for (AIContainerItemStream stream : this._aiContainerItemStreams.values()) {
                String key = SIMPUtils.getRemoteGetKey(stream.getDmeId(), stream.getGatheringTargetDestUuid());
                AnycastInputHandler aih = this._anycastInputHandlers.get(key);
                if (aih != null) continue;
                aih = this.createAIHandRCD(stream.getDmeId(), stream.getGatheringTargetDestUuid(), definition, flush);
                this._anycastInputHandlers.put(key, aih);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteAnycastRMEPhaseTwo");
        }
    }

    public void reconstituteGD() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteGD");
        }
        NonLockingCursor cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(TargetProtocolItemStream.class));
        this._targetProtocolItemStream = (TargetProtocolItemStream)cursor.next();
        cursor.finished();
        if (this._targetProtocolItemStream == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("DESTINATION_HANDLER_RECOVERY_ERROR_CWSIP0048", new Object[]{this._baseDestinationHandler.getName()}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.reconstituteGD", (String)"1:381:1.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstituteGD", (Object)((Object)e));
            }
            throw e;
        }
        cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(SourceProtocolItemStream.class));
        this._sourceProtocolItemStream = (SourceProtocolItemStream)cursor.next();
        cursor.finished();
        if (this._sourceProtocolItemStream == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("DESTINATION_HANDLER_RECOVERY_ERROR_CWSIP0048", new Object[]{this._baseDestinationHandler.getName()}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.reconstituteGD", (String)"1:442:1.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstituteGD", (Object)((Object)e));
            }
            throw e;
        }
        this._sourceProtocolItemStream.reconstitute(this._baseDestinationHandler, this._baseDestinationHandler.getTransactionManager());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteGD");
        }
    }

    public void reconstituteGDTargetStreams() throws MessageStoreException, SIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteGDTargetStreams");
        }
        this._targetProtocolItemStream.reconstitute(this._baseDestinationHandler, this._baseDestinationHandler.getTransactionManager(), (ProducerInputHandler)this._baseDestinationHandler.getInputHandler());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteGDTargetStreams");
        }
    }

    public void reconstituteSourceStreams(int startMode, PtoPOutputHandler outputHandler) throws SIDiscriminatorSyntaxException, MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteSourceStreams", (Object)new Object[]{startMode});
        }
        this._sourceProtocolItemStream.reconstituteSourceStreams(this._baseDestinationHandler, outputHandler, startMode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteSourceStreams");
        }
    }

    public abstract int reconstituteLocalQueuePoint(int var1) throws MessageStoreException, SIResourceException;

    public void createGDProtocolItemStreams(TransactionCommon transaction) throws OutOfCacheSpace, MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createGDProtocolItemStreams");
        }
        Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
        this._targetProtocolItemStream = new TargetProtocolItemStream(this._baseDestinationHandler, msTran);
        this._sourceProtocolItemStream = new SourceProtocolItemStream(this._baseDestinationHandler, msTran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createGDProtocolItemStreams");
        }
    }

    public void removeProtocolItems(TransactionCommon transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeProtocolItems", (Object)transaction);
        }
        Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
        try {
            if (this._targetProtocolItemStream != null) {
                this._targetProtocolItemStream.removeAll(msTran);
            }
            if (this._sourceProtocolItemStream != null) {
                this._sourceProtocolItemStream.removeAll(msTran);
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.removeProtocolItems", (String)"1:636:1.25", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeProtocolItems", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeProtocolItems");
        }
    }

    public void resetProtocolStreams() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetProtocolStreams");
        }
        this._targetProtocolItemStream = null;
        this._sourceProtocolItemStream = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetProtocolStreams");
        }
    }

    public TargetProtocolItemStream getTargetProtocolItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetProtocolItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getTargetProtocolItemStream", (Object)((Object)this._targetProtocolItemStream));
        }
        return this._targetProtocolItemStream;
    }

    public SourceProtocolItemStream getSourceProtocolItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceProtocolItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getSourceProtocolItemStream", (Object)((Object)this._sourceProtocolItemStream));
        }
        return this._sourceProtocolItemStream;
    }

    public abstract AnycastInputHandler getAnycastInputHandlerByPseudoDestId(SIBUuid12 var1);

    public abstract AnycastOutputHandler getAnycastOutputHandlerByPseudoDestId(SIBUuid12 var1);

    public abstract Object[] getPostReconstitutePseudoIds();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnycastInputHandler getAnycastInputHandler(SIBUuid8 dmeId, SIBUuid12 gatheringTargetDestUuid, DestinationDefinition definition, boolean createAIH) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)new Object[]{dmeId, gatheringTargetDestUuid, definition, createAIH});
        }
        AnycastInputHandler aih = null;
        String key = SIMPUtils.getRemoteGetKey(dmeId, gatheringTargetDestUuid);
        HashMap<String, AnycastInputHandler> hashMap = this._anycastInputHandlers;
        synchronized (hashMap) {
            aih = this._anycastInputHandlers.get(key);
            if (aih == null && createAIH && !this._toBeDeleted) {
                aih = this.createAIHandRCD(dmeId, gatheringTargetDestUuid, definition, false);
                this._anycastInputHandlers.put(key, aih);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)aih);
        }
        return aih;
    }

    public final AnycastOutputHandler getAnycastOutputHandler(DestinationDefinition definition, boolean restartFromStaleBackup) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastOutputHandler", (Object)new Object[]{definition, restartFromStaleBackup});
        }
        if (this._anycastOutputHandler == null) {
            try {
                if (this._aoContainerItemStream == null) {
                    AOContainerItemStream aostream = new AOContainerItemStream(null, null);
                    LocalTransaction tran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                    this._baseDestinationHandler.addItemStream(aostream, (Transaction)tran);
                    tran.commit();
                    this._aoContainerItemStream = aostream;
                }
                this._anycastOutputHandler = new AnycastOutputHandler(definition.getName(), definition.getUUID(), definition.isReceiveExclusive(), this._baseDestinationHandler, null, this._aoContainerItemStream, this._messageProcessor, this._destinationManager.getAsyncUpdateThread(), this._destinationManager.getPersistLockThread(), System.currentTimeMillis(), restartFromStaleBackup);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.getAnycastOutputHandler", (String)"1:834:1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport", "1:842:1.25", e, this._baseDestinationHandler.getName()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getAnycastOutputHandlerInternal", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.getAnycastOutputHandler", "1:853:1.25", e, this._baseDestinationHandler.getName()}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAnycastOutputHandler", (Object)this._anycastOutputHandler);
        }
        return this._anycastOutputHandler;
    }

    private AnycastInputHandler createAIHandRCD(SIBUuid8 dmeId, SIBUuid12 gatheringTargetDestUuid, DestinationDefinition definition, boolean restartFromStaleBackup) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAIHandRCD", (Object)new Object[]{dmeId, gatheringTargetDestUuid, definition, restartFromStaleBackup});
        }
        AnycastInputHandler aih = null;
        AIContainerItemStream aiContainerItemStream = null;
        PtoPReceiveMsgsItemStream rcdItemStream = null;
        String key = SIMPUtils.getRemoteGetKey(dmeId, gatheringTargetDestUuid);
        try {
            aiContainerItemStream = this._aiContainerItemStreams.get(key);
            rcdItemStream = this._rcdItemStreams.get(key);
            if (aiContainerItemStream == null || rcdItemStream == null) {
                LocalTransaction tran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                if (aiContainerItemStream == null) {
                    aiContainerItemStream = new AIContainerItemStream(dmeId, gatheringTargetDestUuid, null, null, null);
                    this._baseDestinationHandler.addItemStream(aiContainerItemStream, (Transaction)tran);
                }
                if (rcdItemStream == null) {
                    rcdItemStream = new PtoPReceiveMsgsItemStream(this._baseDestinationHandler, dmeId, null);
                    this._baseDestinationHandler.addItemStream(rcdItemStream, (Transaction)tran);
                    rcdItemStream.setDefaultDestLimits();
                    rcdItemStream.setDestMsgInterval();
                }
                tran.commit();
                this._aiContainerItemStreams.put(key, aiContainerItemStream);
                this._rcdItemStreams.put(key, rcdItemStream);
            }
            aih = new AnycastInputHandler(definition.getName(), definition.getUUID(), definition.isReceiveExclusive(), this._messageProcessor, aiContainerItemStream, dmeId, gatheringTargetDestUuid, this._destinationManager.getAsyncUpdateThread(), this._baseDestinationHandler, restartFromStaleBackup);
            RemoteConsumerDispatcher rcd = new RemoteConsumerDispatcher(this._baseDestinationHandler, definition.getName(), rcdItemStream, new ConsumerDispatcherState(), aih, this._baseDestinationHandler.getTransactionManager(), definition.isReceiveExclusive());
            rcd.setReadyForUse();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("RCD created " + rcd));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.createAIHandRCD", (String)"1:961:1.25", (Object)this);
            SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.createAIHandRCD", "1:968:1.25", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.createAIHandRCD", "1:976:1.25", e});
            if (this._toBeDeleted && e instanceof InvalidAddOperation && !restartFromStaleBackup) {
                aih = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createAIHandRCD", (Object)aih);
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAIHandRCD", (Object)aih);
        }
        return aih;
    }

    public boolean removeAnycastInputHandlerAndRCD(String key) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAnycastInputHandlerAndRCD", (Object)key);
        }
        AnycastInputHandler aih = this._anycastInputHandlers.get(key);
        AIContainerItemStream aiContainerItemStream = this._aiContainerItemStreams.get(key);
        PtoPMessageItemStream rcdItemStream = this._rcdItemStreams.get(key);
        boolean removed = true;
        if (aih != null) {
            boolean removeAIH = true;
            try {
                LocalTransaction tran = null;
                if (rcdItemStream != null) {
                    tran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                    rcdItemStream.remove((Transaction)tran, -2L);
                    tran.commit();
                    this._rcdItemStreams.remove(key);
                }
                if (removeAIH) {
                    if (aiContainerItemStream != null) {
                        tran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                        aiContainerItemStream.remove((Transaction)tran, -2L);
                        tran.commit();
                        this._aiContainerItemStreams.remove(key);
                    }
                    this._anycastInputHandlers.remove(key);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.AbstractRemoteSupport.removeAnycastInputHandlerAndRCD", (String)"1:1096:1.25", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeAnycastInputHandlerAndRCD", (Object)e);
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAnycastInputHandlerAndRCD", (Object)removed);
        }
        return removed;
    }

    public void closeRemoteConsumers(Set newQueuePointLocalisingMEUuids, LocalisationManager daManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeRemoteConsumers", (Object)new Object[]{newQueuePointLocalisingMEUuids, daManager});
        }
        Iterator<String> existingMEs = this._anycastInputHandlers.keySet().iterator();
        Iterator newMEs = newQueuePointLocalisingMEUuids.iterator();
        while (existingMEs.hasNext()) {
            boolean found = false;
            String key = existingMEs.next();
            AnycastInputHandler aih = this._anycastInputHandlers.get(key);
            SIBUuid8 dmeUuid = aih.getLocalisationUuid();
            while (newMEs.hasNext()) {
                SIBUuid8 newMEUuid = new SIBUuid8((String)newMEs.next());
                if (!newMEUuid.equals((Object)dmeUuid)) continue;
                found = true;
                break;
            }
            if (found || daManager.isQueuePointStillAdvertisedForGet(dmeUuid)) continue;
            this.closeRemoteConsumer(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeRemoteConsumers");
        }
    }

    public void closeRemoteConsumers(SIBUuid8 remoteMEId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeRemoteConsumers", (Object)remoteMEId);
        }
        for (String key : this._anycastInputHandlers.keySet()) {
            AnycastInputHandler aih = this._anycastInputHandlers.get(key);
            if (!aih.getLocalisationUuid().equals((Object)remoteMEId)) continue;
            this.closeRemoteConsumer(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeRemoteConsumers");
        }
    }

    public void closeRemoteConsumer(String key) {
        RemoteConsumerDispatcher rcd;
        AnycastInputHandler aih;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeRemoteConsumer", (Object)key);
        }
        if ((aih = this._anycastInputHandlers.get(key)) != null && (rcd = aih.getRCD()) != null) {
            rcd.closeAllConsumersForDelete(this._baseDestinationHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeRemoteConsumer");
        }
    }

    public abstract void closeConsumers() throws SIResourceException;

    public void notifyAOHReceiveExclusiveChange(boolean newValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyAOHReceiveExclusiveChange", (Object)new Object[]{newValue});
        }
        if (this._anycastOutputHandler != null) {
            this._anycastOutputHandler.notifyReceiveExclusiveChange(newValue);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyAOHReceiveExclusiveChange");
        }
    }

    public abstract void notifyReceiveAllowedRCD(DestinationHandler var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRCDReceiveExclusiveChange(boolean isReceiveExclusive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyRCDReceiveExclusiveChange", (Object)new Object[]{isReceiveExclusive});
        }
        HashMap<String, AnycastInputHandler> hashMap = this._anycastInputHandlers;
        synchronized (hashMap) {
            Iterator<String> i = this._anycastInputHandlers.keySet().iterator();
            while (i.hasNext()) {
                AnycastInputHandler aih = this._anycastInputHandlers.get(i.next());
                if (aih == null) continue;
                RemoteConsumerDispatcher rcd = aih.getRCD();
                rcd.notifyReceiveExclusiveChange(isReceiveExclusive);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyRCDReceiveExclusiveChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToBeDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setToBeDeleted");
        }
        HashMap<String, AnycastInputHandler> hashMap = this._anycastInputHandlers;
        synchronized (hashMap) {
            this._toBeDeleted = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setToBeDeleted");
        }
    }

    public abstract Iterator<AnycastInputControl> getAIControlAdapterIterator();

    public abstract Iterator<ControlAdapter> getAOControlAdapterIterator();
}

