/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.queue;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import java.util.ArrayList;
import java.util.List;

public class QueueData {
    private static String CLASS_NAME = QueueData.class.getName();
    private static final TraceComponent tc = SibTr.register(QueueData.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private ProxyQueue proxyQueue;
    private boolean lastInBatch;
    private CommsByteBuffer buffer;
    private long messageLength = 0L;
    private boolean chunkedMessage = false;
    private boolean complete = false;
    private long arrivalTime = 0L;
    private List<DataSlice> slices = new ArrayList<DataSlice>();

    public QueueData(ProxyQueue proxyQueue, boolean lastInBatch, boolean chunk, CommsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{proxyQueue, lastInBatch, chunk, buffer});
        }
        this.proxyQueue = proxyQueue;
        this.lastInBatch = lastInBatch;
        if (!chunk) {
            this.buffer = buffer;
            this.messageLength = buffer.peekLong();
            this.complete = true;
        } else {
            this.slices.add(buffer.getDataSlice());
            this.chunkedMessage = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public synchronized SIBusMessage getMessage() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessage");
        }
        SIBusMessage msg = null;
        if (this.buffer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Recreating message from:", (Object)this.buffer);
            }
            msg = this.buffer.getMessage(null);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Recreating message from:", this.slices);
            }
            try {
                msg = JsMessageFactory.getInstance().createInboundJsMessage(this.slices);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".getMessage"), (String)"2-017-0001", (Object[])new Object[]{this.slices, this});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to recreate message from slices", (Object)e);
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessage", (Object)msg);
        }
        return msg;
    }

    public boolean isLastInBatch() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isLastInBatch");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isLastInBatch", (Object)this.lastInBatch);
        }
        return this.lastInBatch;
    }

    public ProxyQueue getProxyQueue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProxyQueue");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProxyQueue", (Object)this.proxyQueue);
        }
        return this.proxyQueue;
    }

    public synchronized long getMessageLength() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageLength");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageLength", (Object)this.messageLength);
        }
        return this.messageLength;
    }

    public synchronized void addSlice(CommsByteBuffer bufferContainingSlice, boolean last) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addSlice", (Object)new Object[]{bufferContainingSlice, last});
        }
        this.slices.add(bufferContainingSlice.getDataSlice());
        if (last) {
            for (DataSlice slice : this.slices) {
                this.messageLength += (long)slice.getLength();
            }
            this.complete = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message now consists of " + this.slices.size() + " slices"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addSlice");
        }
    }

    public boolean isChunkedMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isChunkedMessage");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isChunkedMessage", (Object)this.chunkedMessage);
        }
        return this.chunkedMessage;
    }

    public synchronized boolean isComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isComplete");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isComplete", (Object)this.complete);
        }
        return this.complete;
    }

    public void updateArrivalTime(long messageArrivalTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateMessageArrivalTime", (Object)messageArrivalTime);
        }
        this.arrivalTime = messageArrivalTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateMessageArrivalTime");
        }
    }

    public long getArrivalTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageArrivalTime");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageArrivalTime", (Object)this.arrivalTime);
        }
        return this.arrivalTime;
    }

    public String toString() {
        return "QueueData@" + Integer.toHexString(System.identityHashCode(this)) + " {buffer=" + this.buffer + ",  slices=" + this.slices + ",  chunked=" + this.chunkedMessage + ",  complete=" + this.complete + ",  messageLength=" + this.messageLength + ",  lastInbatch=" + this.lastInBatch + ",  arrivalTime=" + this.arrivalTime + ",  proxyQueue=" + this.proxyQueue + "}";
    }
}

