/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.structures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedGenericHashMap;
import com.ibm.ws.security.common.structures.CacheValue;
import com.ibm.ws.security.common.structures.CommonCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SingleTableCache
extends CommonCache {
    protected Map<Object, CacheValue> lookupTable;
    static final long serialVersionUID = 1517086008114653831L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SingleTableCache(long timeoutInMilliSeconds) {
        this(0, timeoutInMilliSeconds);
    }

    public SingleTableCache(int entryLimit, long timeoutInMilliSeconds) {
        this.lookupTable = Collections.synchronizedMap(new BoundedGenericHashMap(entryLimit));
        this.rescheduleCleanup(timeoutInMilliSeconds);
    }

    @Override
    public synchronized void remove(@Sensitive Object key) {
        this.lookupTable.remove(key);
    }

    @Override
    public synchronized Object get(@Sensitive Object key) {
        CacheValue cacheValue = this.lookupTable.get(key);
        if (cacheValue == null) {
            return null;
        }
        if (cacheValue.isExpired(this.timeoutInMilliSeconds)) {
            this.remove(key);
            return null;
        }
        return cacheValue.getValue();
    }

    @Override
    public synchronized void put(@Sensitive Object key, Object value) {
        this.put(key, value, 0L);
    }

    public synchronized void put(@Sensitive Object key, Object value, long clockSkew) {
        this.lookupTable.put(key, this.createCacheValue(value, clockSkew));
    }

    protected CacheValue createCacheValue(Object value, long clockSkew) {
        return new CacheValue(value, clockSkew);
    }

    public int size() {
        return this.lookupTable.size();
    }

    @Override
    protected synchronized void evictStaleEntries() {
        ArrayList<Object> keysToRemove = new ArrayList<Object>();
        for (Map.Entry<Object, CacheValue> entry : this.lookupTable.entrySet()) {
            Object key = entry.getKey();
            CacheValue cacheValue = entry.getValue();
            if (cacheValue != null && !cacheValue.isExpired(this.timeoutInMilliSeconds)) continue;
            keysToRemove.add(key);
        }
        for (Map.Entry<Object, CacheValue> entry : keysToRemove) {
            this.remove(entry);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.SingleTableCache", SingleTableCache.class, null, null);
    }
}

