/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.services.OASValidator;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIModelOperations;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIVersionConfig;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import java.util.List;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={ValidationComponent.class})
public class ValidationComponent {
    private static final TraceComponent tc = Tr.register(ValidationComponent.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String VALIDATOR_REF = "validator";
    protected ComponentContext ctx;
    @Reference(name="validator")
    protected volatile List<ServiceReference<OASValidator>> validators;
    @Reference
    protected OpenAPIModelOperations modelOperations;
    @Reference
    protected OpenAPIVersionConfig versionConfig;
    static final long serialVersionUID = -7367669184412216496L;

    @Activate
    private void activate(ComponentContext ctx) {
        this.ctx = ctx;
    }

    public void validateAndReportErrors(OpenAPI model) {
        OASValidationResult result = this.validateModel(model);
        this.reportResults(result);
    }

    public OASValidationResult validateModel(OpenAPI model) {
        model = this.modelOperations.shallowCopy(model);
        this.versionConfig.applyConfig(model);
        String modelVersion = model.getOpenapi();
        if (modelVersion == null) {
            modelVersion = "";
        }
        OASValidationResult result = null;
        for (ServiceReference<OASValidator> ref : this.validators) {
            String validatorVersion = (String)ref.getProperty("openapi.version");
            if (!modelVersion.startsWith(validatorVersion)) continue;
            OASValidator validator = (OASValidator)this.ctx.locateService(VALIDATOR_REF, ref);
            result = validator.validate(model);
            break;
        }
        if (result == null) {
            result = new OASValidationResult();
            String message = ValidatorUtils.formatMessage("openAPIVersionInvalid", modelVersion);
            result.getEvents().add(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, "#", message));
        }
        return result;
    }

    private void reportResults(OASValidationResult result) {
        StringBuilder sbError = new StringBuilder();
        StringBuilder sbWarnings = new StringBuilder();
        if (result.hasEvents()) {
            String warnings;
            result.getEvents().stream().forEach(v -> {
                String message = ValidatorUtils.formatMessage("validationMessage", v.message, v.location);
                if (v.severity == OASValidationResult.ValidationEvent.Severity.ERROR) {
                    sbError.append("\n - " + message);
                } else if (v.severity == OASValidationResult.ValidationEvent.Severity.WARNING) {
                    sbWarnings.append("\n - " + message);
                }
            });
            String errors = sbError.toString();
            if (!errors.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_ERROR", (Object[])new Object[]{errors + "\n"});
            }
            if (!(warnings = sbWarnings.toString()).isEmpty()) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_DOCUMENT_VALIDATION_WARNING", (Object[])new Object[]{warnings + "\n"});
            }
        }
    }
}

