/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.AttributeConstraint;
import io.openliberty.data.internal.persistence.cdi.RepositoryProducer;
import io.openliberty.data.internal.version.DataVersionCompatibility;
import jakarta.data.Order;
import jakarta.data.Sort;
import jakarta.data.repository.Insert;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import jakarta.persistence.AttributeConverter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Util {
    public static final String ATTR_CONVERTER_CLASS_NAME;
    public static final String EOLN;
    static final List<String> LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS;
    private static final Set<String> METHOD_NAME_PREFIXES_STATEFUL;
    private static final Set<String> METHOD_NAME_PREFIXES_STATELESS;
    static final int MIN_COUNT_QUERY_LENGTH = 15;
    static final Set<Class<?>> NON_ENTITY_RESULT_TYPES;
    static final Set<Class<?>> PRIMITIVE_NUMERIC_TYPES;
    public static final Set<String> QL_KEYWORDS_AFTER_ENTITY_NAME;
    static final Set<Class<?>> RETURN_TYPES_FOR_DELETE_ONLY;
    static final Set<Class<?>> SORT_PARAM_TYPES;
    public static final List<String> SUPPORTED_BASIC_TYPES;
    public static final List<String> SUPPORTED_TEMPORAL_TYPES;
    public static final Set<Class<?>> UNSUPPORTED_ATTR_TYPES;
    static final Set<Class<?>> UPDATE_COUNT_TYPES;
    public static final Set<Class<?>> VERSION_TYPES;
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASSES;
    static final long serialVersionUID = -334910562183736238L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static SortedMap<String, Object> alphabetize(Dictionary<String, Object> props) {
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            sorted.put(key, props.get(key));
        }
        return sorted;
    }

    @Trivial
    public static boolean cannotBeEntity(Class<?> c) {
        int modifiers;
        return NON_ENTITY_RESULT_TYPES.contains(c) || c.isEnum() || Modifier.isInterface(modifiers = c.getModifiers()) || Modifier.isAbstract(modifiers);
    }

    @Trivial
    static Set<String> constraintsThatSupportCollections() {
        TreeSet<String> supported = new TreeSet<String>();
        for (AttributeConstraint c : AttributeConstraint.values()) {
            if (!c.supportsCollections() || c.lengthWithinMethodName() <= 0) continue;
            String name = c.name();
            supported.add(name);
        }
        return supported;
    }

    @Trivial
    static final boolean hasOperationAnno(Method method, RepositoryProducer<?> producer) {
        DataVersionCompatibility compat = producer.compat();
        Set statefulAnnos = compat.operationAnnoTypes(true);
        Set statelessAnnos = compat.operationAnnoTypes(false);
        for (Annotation anno : method.getAnnotations()) {
            if (!statefulAnnos.contains(anno.annotationType()) && !statelessAnnos.contains(anno.annotationType())) continue;
            return true;
        }
        return false;
    }

    static final boolean isWrapperClassFor(Class<?> primitive, Class<?> cl) {
        return primitive == Long.TYPE && cl == Long.class || primitive == Integer.TYPE && cl == Integer.class || primitive == Float.TYPE && cl == Float.class || primitive == Double.TYPE && cl == Double.class || primitive == Character.TYPE && cl == Character.class || primitive == Byte.TYPE && cl == Byte.class || primitive == Boolean.TYPE && cl == Boolean.class || primitive == Short.TYPE && cl == Short.class;
    }

    @Trivial
    static String lifeCycleAnnoNames(RepositoryProducer<?> producer) {
        Set annoClasses = producer.compat().lifeCycleAnnoTypes(producer.stateful());
        return annoClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(", ", "[", "]"));
    }

    static List<String> lifeCycleReturnTypes(String singularClassName, boolean hasSingularEntityParam, boolean includeBooleanAndNumeric) {
        ArrayList<String> validReturnTypes = new ArrayList<String>();
        if (includeBooleanAndNumeric) {
            validReturnTypes.add("boolean");
            validReturnTypes.add("int");
            validReturnTypes.add("long");
        }
        validReturnTypes.add("void");
        if (hasSingularEntityParam) {
            validReturnTypes.add(singularClassName);
        } else {
            validReturnTypes.add(singularClassName + "[]");
            validReturnTypes.add("List<" + singularClassName + ">");
        }
        return validReturnTypes;
    }

    static Set<String> methodNamePrefixes(RepositoryProducer<?> producer) {
        return producer.stateful() ? METHOD_NAME_PREFIXES_STATEFUL : METHOD_NAME_PREFIXES_STATELESS;
    }

    public static String names(Collection<Class<?>> classes) {
        StringBuilder b = new StringBuilder();
        for (Class<?> c : classes) {
            b.append(b.isEmpty() ? "" : ", ").append(c.getName());
        }
        return b.toString();
    }

    @Trivial
    static String operationAnnoNames(RepositoryProducer<?> producer) {
        Set annoClasses = producer.compat().operationAnnoTypes(producer.stateful());
        return annoClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(", ", "[", "]"));
    }

    @Trivial
    public static void printlnIndented(String s, PrintWriter writer, String indent) {
        int eoln;
        if (s == null) {
            writer.println("null");
            return;
        }
        int start = 0;
        while ((eoln = s.indexOf(EOLN, start)) >= 0) {
            writer.print(s.substring(start, eoln));
            writer.println();
            writer.print(indent);
            start = eoln + EOLN.length();
        }
        writer.println(s.substring(start, s.length()));
    }

    @Trivial
    public static void printStackTrace(Throwable x, PrintWriter writer, String indent, Set<Throwable> suppressedIgnores) {
        HashSet<Throwable> alreadyPrinted = suppressedIgnores == null ? new HashSet<Throwable>() : suppressedIgnores;
        for (Throwable cause = x; cause != null; cause = cause.getCause()) {
            if (alreadyPrinted.add(cause)) {
                writer.print(indent);
                if (cause != x) {
                    writer.print("Caused by: ");
                } else if (suppressedIgnores != null) {
                    writer.print("Suppressed: ");
                }
                Util.printlnIndented(cause.toString(), writer, indent + "  ");
                for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
                    writer.println(indent + "  at " + stackTraceElement.toString());
                }
                for (Serializable serializable : x.getSuppressed()) {
                    Util.printStackTrace((Throwable)serializable, writer, indent + "  ", alreadyPrinted);
                }
                continue;
            }
            writer.println(indent + "[CIRCULAR REFERENCE: " + cause.getClass().getName() + "]");
        }
    }

    @Trivial
    static String resourceAccessorTypeNames(RepositoryProducer<?> producer) {
        Set types = producer.compat().resourceAccessorTypes(producer.stateful());
        return types.stream().map(Class::getSimpleName).collect(Collectors.joining(", ", "[", "]"));
    }

    @Trivial
    private static String toString(Annotation anno) {
        Object s = anno.toString();
        int openParen = ((String)s).indexOf(40);
        int dot = openParen > 0 ? ((String)s).lastIndexOf(46, openParen) : -1;
        int end = ((String)s).length() - (((String)s).endsWith("()") ? 2 : 0);
        s = dot > 0 && ((String)s).startsWith("@jakarta.data.") ? "@" + ((String)s).substring(dot + 1, end) : ((String)s).substring(0, end);
        return s;
    }

    @Trivial
    public static String toString(Class<?> c, String indent) {
        Type[] interfaces;
        Type supertype;
        String className_ = c.getName() + ".";
        String packageName_ = c.getPackage().getName() + ".";
        Function<String, String> shorten = str -> str.replace(className_, "").replace(packageName_, "");
        StringBuilder s = new StringBuilder(1000);
        for (Annotation anno : c.getDeclaredAnnotations()) {
            s.append(indent).append(Util.toString(anno)).append(EOLN);
        }
        s.append(indent).append(c.toGenericString());
        RecordComponent[] components = c.getRecordComponents();
        if (components != null) {
            s.append('(');
            for (int rc = 0; rc < components.length; ++rc) {
                if (rc > 0) {
                    s.append(", ");
                }
                s.append(shorten.apply(components[rc].getGenericType().getTypeName())).append(' ').append(components[rc].getName());
            }
            s.append(')');
        }
        if ((supertype = c.getGenericSuperclass()) != null) {
            s.append(" extends ").append(shorten.apply(supertype.getTypeName()));
        }
        if ((interfaces = c.getGenericInterfaces()) != null && interfaces.length > 0) {
            s.append(c.isInterface() ? " extends" : " implements");
            for (int i = 0; i < interfaces.length; ++i) {
                s.append(i == 0 ? " " : ", ").append(shorten.apply(interfaces[i].getTypeName()));
            }
        }
        s.append(" {").append(EOLN);
        for (Class<?> inner : c.getDeclaredClasses()) {
            s.append(EOLN).append(Util.toString(inner, indent + "  ")).append(EOLN);
        }
        TreeMap<String, Field> fields = new TreeMap<String, Field>();
        for (Field f : c.getFields()) {
            fields.put(f.getName(), f);
        }
        for (Field f : fields.values()) {
            s.append(EOLN);
            for (Annotation anno : f.getDeclaredAnnotations()) {
                s.append(indent).append("  ").append(Util.toString(anno)).append(EOLN);
            }
            s.append(indent).append("  ").append(shorten.apply(f.toGenericString())).append(';').append(EOLN);
        }
        TreeMap ctors = new TreeMap();
        for (Constructor<?> ctor : c.getConstructors()) {
            ctors.put(ctor.getName(), ctor);
        }
        for (Constructor ctor : ctors.values()) {
            s.append(EOLN);
            Util.toStringAppend(ctor, shorten, indent + "  ", s);
        }
        TreeMap<String, Method> methods = new TreeMap<String, Method>();
        for (Method m : c.getMethods()) {
            if (Object.class.equals(m.getDeclaringClass())) continue;
            methods.put(m.getName(), m);
        }
        for (Method m : methods.values()) {
            s.append(EOLN);
            Util.toStringAppend(m, shorten, indent + "  ", s);
        }
        s.append(indent).append('}');
        return s.toString();
    }

    @Trivial
    private static void toStringAppend(Executable m, Function<String, String> shorten, String indent, StringBuilder b) {
        for (Annotation anno : m.getDeclaredAnnotations()) {
            b.append(indent).append(Util.toString(anno)).append(EOLN);
        }
        String s = shorten.apply(m.toGenericString());
        Annotation[][] paramAnnos = m.getParameterAnnotations();
        if (paramAnnos.length == 0) {
            b.append(indent).append(s).append(EOLN);
        } else {
            int paramStart = s.indexOf(40) + 1;
            b.append(indent).append(s.substring(0, paramStart));
            for (int a = 0; a < paramAnnos.length; ++a) {
                for (Annotation anno : paramAnnos[a]) {
                    b.append(Util.toString(anno)).append(' ');
                }
                int paramNext = s.indexOf(44, paramStart);
                paramNext = paramNext == -1 ? s.length() : paramNext + 1;
                b.append(s.substring(paramStart, paramNext)).append(' ');
                paramStart = paramNext;
            }
            b.append(EOLN);
        }
    }

    @Trivial
    static final String txStatusToString(int status) {
        return switch (status) {
            case 0 -> "STATUS_ACTIVE (0)";
            case 1 -> "STATUS_MARKED_ROLLBACK (1)";
            case 2 -> "STATUS_PREPARED (2)";
            case 3 -> "STATUS_COMMITTED (3)";
            case 4 -> "STATUS_ROLLEDBACK (4)";
            case 5 -> "STATUS_UNKNOWN (5)";
            case 6 -> "STATUS_NO_TRANSACTION (6)";
            case 7 -> "STATUS_PREPARING (7)";
            case 8 -> "STATUS_COMMITTING (8)";
            case 9 -> "STATUS_ROLLING_BACK (9)";
            default -> "unrecognized value (" + status + ")";
        };
    }

    @Trivial
    static final Class<?> wrapperClassIfPrimitive(Class<?> c) {
        Class<?> w = WRAPPER_CLASSES.get(c);
        return w == null ? c : w;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.data.internal.persistence.Util", Util.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
        ATTR_CONVERTER_CLASS_NAME = AttributeConverter.class.getName();
        EOLN = String.format("%n", new Object[0]);
        LIFE_CYCLE_METHODS_THAT_RETURN_ENTITIES_STATELESS = List.of(Insert.class.getSimpleName(), Save.class.getSimpleName(), Update.class.getSimpleName());
        METHOD_NAME_PREFIXES_STATEFUL = Set.of("count", "exists", "find");
        METHOD_NAME_PREFIXES_STATELESS = Set.of("count", "delete", "exists", "find");
        NON_ENTITY_RESULT_TYPES = new HashSet();
        PRIMITIVE_NUMERIC_TYPES = Set.of(Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, Double.TYPE, Float.TYPE);
        QL_KEYWORDS_AFTER_ENTITY_NAME = new HashSet<String>();
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("EXCEPT");
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("GROUP");
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("HAVING");
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("INTERSECT");
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("ORDER");
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("SET");
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("UNION");
        QL_KEYWORDS_AFTER_ENTITY_NAME.add("WHERE");
        RETURN_TYPES_FOR_DELETE_ONLY = Set.of(Void.TYPE, Void.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Number.class);
        SORT_PARAM_TYPES = Set.of(Order.class, Sort.class, Sort[].class);
        SUPPORTED_BASIC_TYPES = List.of(BigDecimal.class.getSimpleName(), BigInteger.class.getSimpleName(), Boolean.class.getSimpleName(), "boolean", Byte.class.getSimpleName(), "byte", "byte[]", Character.class.getSimpleName(), "char", Double.class.getSimpleName(), "double", Float.class.getSimpleName(), "float", Integer.class.getSimpleName(), "int", Long.class.getSimpleName(), "long", Short.class.getSimpleName(), "short", String.class.getSimpleName(), UUID.class.getSimpleName());
        SUPPORTED_TEMPORAL_TYPES = List.of(Instant.class.getSimpleName(), LocalDate.class.getSimpleName(), LocalDateTime.class.getSimpleName(), LocalTime.class.getSimpleName(), Year.class.getSimpleName());
        UNSUPPORTED_ATTR_TYPES = Set.of(Byte[].class, Character[].class, Date.class, Time.class, Timestamp.class, Calendar.class, java.util.Date.class, ZonedDateTime.class);
        UPDATE_COUNT_TYPES = Set.of(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Void.TYPE, Void.class, Number.class);
        VERSION_TYPES = Set.of(Instant.class, Integer.TYPE, Integer.class, LocalDateTime.class, Long.TYPE, Long.class, Short.TYPE, Short.class);
        WRAPPER_CLASSES = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Void.TYPE, Void.class);
        for (Map.Entry<Class<?>, Class<?>> e : WRAPPER_CLASSES.entrySet()) {
            NON_ENTITY_RESULT_TYPES.add(e.getKey());
            NON_ENTITY_RESULT_TYPES.add(e.getValue());
        }
        NON_ENTITY_RESULT_TYPES.add(BigDecimal.class);
        NON_ENTITY_RESULT_TYPES.add(BigInteger.class);
        NON_ENTITY_RESULT_TYPES.add(Object.class);
        NON_ENTITY_RESULT_TYPES.add(String.class);
    }
}

