/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.DependencyTable;
import com.ibm.ws.cache.HTODDependencyMap;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Result;
import com.ibm.ws.cache.ValueSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HTODDependencyTable {
    public static final int DEP_ID_TABLE = 1;
    public static final int TEMPLATE_TABLE = 2;
    private static TraceComponent tc = Tr.register(DependencyTable.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private Map<Object, Set<Object>> dependencyToEntryTable = null;
    private Map<Object, Set<Object>> dependencyNotUpdatedTable = null;
    private int type;
    private int maxSize;
    private int entryRemove;
    public int delayOffloadEntriesLimit;
    private HTODDynacache htod;

    public HTODDependencyTable(int type, int initialSize, int maxSize, int entryRemove, int delayOffloadEntriesLimit, boolean dependencyCacheIndexEnabled, HTODDynacache htod) {
        this.type = type;
        this.dependencyToEntryTable = new HTODDependencyMap(10 * initialSize, 0.75f, 1, dependencyCacheIndexEnabled);
        this.dependencyNotUpdatedTable = new ConcurrentHashMap<Object, Set<Object>>(initialSize / 2, 0.75f, 1);
        this.maxSize = maxSize;
        this.entryRemove = entryRemove;
        this.delayOffloadEntriesLimit = delayOffloadEntriesLimit;
        this.htod = htod;
    }

    public int add(Object dependency, ValueSet valueSet, Object entry) {
        int returnCode = 0;
        this.dependencyNotUpdatedTable.remove(dependency);
        valueSet.add(entry);
        if (valueSet.size() > this.delayOffloadEntriesLimit) {
            if (this.type == 1) {
                returnCode = this.htod.writeValueSet(2, dependency, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(dependency);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("***** add dependency id=" + dependency + " size=" + valueSet.size()), (Object[])new Object[0]);
                }
            } else {
                returnCode = this.htod.writeValueSet(3, dependency, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().templatesOffloadedToDisk(dependency);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("***** add dependency id=" + dependency + " size=" + valueSet.size()), (Object[])new Object[0]);
                }
            }
            this.dependencyToEntryTable.remove(dependency);
            if (returnCode == 2 && valueSet.size() > 0) {
                this.htod.delCacheEntry(valueSet, 8, 5, false, true);
                returnCode = 0;
            }
        }
        return returnCode;
    }

    public int add(Object dependency, ValueSet valueSet) {
        int returnCode = 0;
        if (this.dependencyToEntryTable.size() >= this.maxSize) {
            returnCode = this.reduceTableSize();
        }
        this.dependencyNotUpdatedTable.put(dependency, valueSet);
        this.dependencyToEntryTable.put(dependency, valueSet);
        return returnCode;
    }

    public int add(Object dependency, Object entry) {
        int returnCode = 0;
        if (this.dependencyToEntryTable.size() >= this.maxSize) {
            returnCode = this.reduceTableSize();
        }
        ValueSet valueSet = new ValueSet(4);
        valueSet.add(entry);
        this.dependencyNotUpdatedTable.put(dependency, valueSet);
        this.dependencyToEntryTable.put(dependency, valueSet);
        return returnCode;
    }

    public int replace(Object dependency, ValueSet valueSet) {
        int returnCode = 0;
        this.dependencyNotUpdatedTable.remove(dependency);
        if (valueSet != null && valueSet.size() > this.delayOffloadEntriesLimit) {
            this.dependencyToEntryTable.remove(dependency);
            if (this.type == 1) {
                returnCode = this.htod.writeValueSet(2, dependency, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(dependency);
            } else {
                returnCode = this.htod.writeValueSet(3, dependency, valueSet, true);
                this.htod.cache.getCacheStatisticsListener().templatesOffloadedToDisk(dependency);
            }
        } else if (valueSet.size() > 0) {
            this.dependencyToEntryTable.put(dependency, valueSet);
        } else {
            this.dependencyToEntryTable.remove(dependency);
        }
        if (returnCode == 2 && valueSet.size() > 0) {
            this.htod.delCacheEntry(valueSet, 8, 5, false, true);
            returnCode = 0;
        }
        return returnCode;
    }

    public void removeDependency(Object dependency) {
        this.dependencyNotUpdatedTable.remove(dependency);
        this.dependencyToEntryTable.remove(dependency);
    }

    public Result removeEntry(Object dependency, Object entry) {
        Result result = this.htod.getFromResultPool();
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(dependency);
        if (valueSet == null) {
            return result;
        }
        result.bExist = true;
        valueSet.remove(entry);
        this.dependencyNotUpdatedTable.remove(dependency);
        if (valueSet.isEmpty()) {
            this.dependencyToEntryTable.remove(dependency);
            result.returnCode = this.type == 1 ? this.htod.delValueSet(2, dependency) : this.htod.delValueSet(3, dependency);
        }
        return result;
    }

    public void clear() {
        this.dependencyToEntryTable.clear();
        this.dependencyNotUpdatedTable.clear();
    }

    public Enumeration getKeys() {
        return new IteratorEnumerator(this.dependencyToEntryTable.keySet().iterator());
    }

    public Enumeration getNotUpdateKeys() {
        return new IteratorEnumerator(this.dependencyNotUpdatedTable.keySet().iterator());
    }

    public ValueSet getEntries(Object dependency) {
        ValueSet valueSet = (ValueSet)this.dependencyToEntryTable.get(dependency);
        return valueSet;
    }

    public boolean isEmpty() {
        return this.dependencyToEntryTable.isEmpty();
    }

    public boolean isUpdated(Object id) {
        return !this.dependencyNotUpdatedTable.containsKey(id);
    }

    public boolean containsCacheId(Object id) {
        return this.dependencyToEntryTable.containsValue(id);
    }

    private int reduceTableSize() {
        int returnCode = 0;
        int count = this.entryRemove;
        if (count > 0) {
            int removeSize = 5;
            while (count > 0) {
                int minSize = Integer.MAX_VALUE;
                for (Map.Entry<Object, Set<Object>> entry : this.dependencyToEntryTable.entrySet()) {
                    Object id = entry.getKey();
                    ValueSet vs = (ValueSet)entry.getValue();
                    int vsSize = vs.size();
                    if (vsSize < removeSize) {
                        if (this.type == 1) {
                            returnCode = this.htod.writeValueSet(2, id, vs, true);
                            this.htod.cache.getCacheStatisticsListener().depIdsOffloadedToDisk(id);
                            Tr.debug((TraceComponent)tc, (String)(" reduceTableSize dependency id=" + id + " vs=" + vs.size() + " returnCode=" + returnCode), (Object[])new Object[0]);
                        } else {
                            returnCode = this.htod.writeValueSet(3, id, vs, true);
                            this.htod.cache.getCacheStatisticsListener().templatesOffloadedToDisk(id);
                            Tr.debug((TraceComponent)tc, (String)("reduceTableSize template id=" + id + " vs=" + vs.size() + " returnCode=" + returnCode), (Object[])new Object[0]);
                        }
                        this.dependencyToEntryTable.remove(id);
                        this.dependencyNotUpdatedTable.remove(id);
                        --count;
                        if (returnCode == 1) {
                            return returnCode;
                        }
                        if (returnCode == 2) {
                            this.htod.delCacheEntry(vs, 8, 5, false, true);
                            returnCode = 0;
                            return returnCode;
                        }
                    } else {
                        int n = minSize = vsSize < minSize ? vsSize : minSize;
                    }
                    if (count != 0) continue;
                    break;
                }
                removeSize = minSize;
                removeSize += 3;
            }
        }
        return returnCode;
    }

    public int size() {
        return this.dependencyToEntryTable.size();
    }

    class IteratorEnumerator
    implements Enumeration {
        private Iterator _iterator = null;

        public IteratorEnumerator(Iterator iter) {
            this._iterator = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this._iterator.hasNext();
        }

        public Object nextElement() {
            return this._iterator.next();
        }
    }
}

