/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.MPSelectionCriteria;
import com.ibm.ws.sib.processor.MPSelectionCriteriaFactory;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public final class DurableSubscriptionItemStream
extends SubscriptionItemStream {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(DurableSubscriptionItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 3;
    private BaseDestinationHandler _bdh;
    private ConsumerDispatcherState _subState;
    private int[] _domains;
    private String[] _selectors;
    private String[] _topics;
    private Map[] _selectorProperties;
    private DestinationManager _destinationManager;
    private boolean _inDoubt = false;

    public DurableSubscriptionItemStream(ConsumerDispatcherState subState, DestinationManager destinationManager, PubSubMessageItemStream parentItemStream, Transaction msTran) throws OutOfCacheSpace, MessageStoreException, StreamIsFull {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DurableSubscriptionItemStream", (Object)new Object[]{subState, destinationManager, parentItemStream, msTran});
        }
        this._subState = subState;
        this._destinationManager = destinationManager;
        subState.setReady(false);
        this.setStorageStrategy(4);
        parentItemStream.addReferenceStream(this, msTran);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DurableSubscriptionItemStream", (Object)this);
        }
    }

    public DurableSubscriptionItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DurableSubscriptionItemStream");
        }
        this._subState = new ConsumerDispatcherState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DurableSubscriptionItemStream", (Object)this);
        }
    }

    @Override
    public int getPersistentVersion() {
        return 3;
    }

    @Override
    public void getPersistentData(ObjectOutputStream oos) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)oos);
        }
        try {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("subscriberID", this._subState.getSubscriberID());
            hm.put("topicspace", this._subState.getTopicSpaceUuid().toString());
            hm.put("topicspaceName", this._subState.getTopicSpaceName());
            hm.put("topicspaceBusName", this._subState.getTopicSpaceBusName());
            hm.put("targetDestination", this._subState.getTargetDestination());
            hm.put("isToBeDeleted", new Boolean(this.toBeDeleted));
            hm.put("user", this._subState.getUser());
            hm.put("isSIBServerSubject", new Boolean(this._subState.isSIBServerSubject()));
            hm.put("topics", this._subState.getTopics());
            hm.put("isCloned", new Boolean(this._subState.isCloned()));
            hm.put("isNoLocal", new Boolean(this._subState.isNoLocal()));
            SelectionCriteria[] selectionCriteriaList = this._subState.getSelectionCriteriaList();
            String[] selectors = null;
            int[] domains = null;
            HashMap[] selectorProperties = null;
            if (selectionCriteriaList != null) {
                selectors = new String[selectionCriteriaList.length];
                domains = new int[selectionCriteriaList.length];
                selectorProperties = new HashMap[selectionCriteriaList.length];
                for (int i = 0; i < selectionCriteriaList.length; ++i) {
                    selectors[i] = selectionCriteriaList[i] == null ? null : selectionCriteriaList[i].getSelectorString();
                    domains[i] = selectionCriteriaList[i] == null ? SelectorDomain.SIMESSAGE.toInt() : selectionCriteriaList[i].getSelectorDomain().toInt();
                    selectorProperties[i] = null;
                    if (selectionCriteriaList[i] == null || !(selectionCriteriaList[i] instanceof MPSelectionCriteria)) continue;
                    MPSelectionCriteria mpCriteria = (MPSelectionCriteria)selectionCriteriaList[i];
                    selectorProperties[i] = mpCriteria.getSelectorProperties();
                }
            }
            hm.put("selectors", selectors);
            hm.put("domains", domains);
            hm.put("selectorProperties", selectorProperties);
            hm.put("userData", this._subState.getUserData());
            oos.writeObject(hm);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.getPersistentData", (String)"1:275:1.95", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)e);
            }
            throw new SIErrorException(nls.getFormattedMessage("SUBSCRIPTION_WARM_START_ERROR_CWSIP0148", new Object[]{this._destinationManager.getLocalME().getMessagingEngineName(), e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void initializeNonPersistent(BaseDestinationHandler baseDestHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)baseDestHandler);
        }
        this._bdh = baseDestHandler;
        this._destinationManager = this._bdh.getDestinationManager();
        SelectionCriteria[] selectionCriteriaList = null;
        if (this._selectors != null) {
            SelectionCriteriaFactory selFactory = this._destinationManager.getLocalME().getSelectionCriteriaFactory();
            selectionCriteriaList = new SelectionCriteria[this._selectors.length];
            for (int i = 0; i < this._selectors.length; ++i) {
                selectionCriteriaList[i] = this._selectorProperties[i] == null ? selFactory.createSelectionCriteria(this._topics[i], this._selectors[i], SelectorDomain.getSelectorDomain((int)this._domains[i])) : MPSelectionCriteriaFactory.getInstance().createSelectionCriteria(this._topics[i], this._selectors[i], SelectorDomain.getSelectorDomain((int)this._domains[i]), this._selectorProperties[i]);
            }
        }
        this._subState.setSelectionCriteriaListOnRestore(selectionCriteriaList);
        this._subState.setDurableHome(this._destinationManager.getLocalME().getMessagingEngineName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    @Override
    public void restore(ObjectInputStream ois, int dataVersion) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{ois, new Integer(dataVersion)});
        }
        if (dataVersion > this.getPersistentVersion()) {
            SibTr.error((TraceComponent)tc, (String)"ITEM_RESTORE_ERROR_CWSIP0261", (Object)new Object[]{new Integer(this.getPersistentVersion()), new Integer(dataVersion)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SevereMessageStoreException(nls.getFormattedMessage("ITEM_RESTORE_ERROR_CWSIP0261", new Object[]{new Integer(this.getPersistentVersion()), new Integer(dataVersion)}, null));
        }
        BaseDestinationHandler baseDestHandler = null;
        PubSubMessageItemStream mis = (PubSubMessageItemStream)this.getItemStream();
        baseDestHandler = (BaseDestinationHandler)mis.getItemStream();
        if (baseDestHandler != null) {
            this._destinationManager = baseDestHandler.getDestinationManager();
        }
        this._subState.setDurable(true);
        try {
            HashMap hm = (HashMap)ois.readObject();
            this._subState.setSubscriberID((String)hm.get("subscriberID"));
            this._subState.setTopicSpaceUuid(new SIBUuid12((String)hm.get("topicspace")));
            this._subState.setTopicSpaceName((String)hm.get("topicspaceName"));
            this._subState.setTopicSpaceBusName((String)hm.get("topicspaceBusName"));
            this.toBeDeleted = (Boolean)hm.get("isToBeDeleted");
            boolean isSIBServerSubject = (Boolean)hm.get("isSIBServerSubject");
            this._subState.setUser((String)hm.get("user"), isSIBServerSubject);
            this._topics = (String[])hm.get("topics");
            this._subState.setIsCloned((Boolean)hm.get("isCloned"));
            this._subState.setNoLocal((Boolean)hm.get("isNoLocal"));
            if (dataVersion < 2) {
                if (this._selectors == null) {
                    this._selectors = new String[1];
                }
                if (this._domains == null) {
                    this._domains = new int[1];
                }
                this._selectors[0] = (String)hm.get("selectorstring");
                this._domains[0] = (Integer)hm.get("selectordomain");
            } else {
                this._subState.setTargetDestination((String)hm.get("targetDestination"));
                this._selectors = (String[])hm.get("selectors");
                this._domains = (int[])hm.get("domains");
                this._selectorProperties = (HashMap[])hm.get("selectorProperties");
                this._subState.setUserData((HashMap)hm.get("userData"));
            }
            if (dataVersion < 3) {
                if (this._selectorProperties == null) {
                    this._selectorProperties = new HashMap[1];
                }
            } else {
                this._selectorProperties = (HashMap[])hm.get("selectorProperties");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.restore", (String)"1:434:1.95", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)e);
            }
            throw new SIErrorException(nls.getFormattedMessage("SUBSCRIPTION_WARM_START_ERROR_CWSIP0148", new Object[]{this._destinationManager.getLocalME().getMessagingEngineName(), e}, null), (Throwable)e);
        }
        if (baseDestHandler == null || this._destinationManager == null) {
            this._inDoubt = true;
        } else {
            this.initializeNonPersistent(baseDestHandler);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        super.xmlWriteOn(writer);
        writer.newLine();
        writer.taggedValue("subscriberID", (Object)this._subState.getSubscriberID());
        writer.newLine();
        writer.startTag("topics");
        writer.indent();
        String[] topics = this._subState.getTopics();
        if (topics != null) {
            for (int i = 0; i < topics.length; ++i) {
                writer.newLine();
                writer.taggedValue("topic", (Object)topics[i]);
            }
        }
        writer.outdent();
        writer.newLine();
        writer.endTag("topics");
        writer.newLine();
        writer.taggedValue("toBeDeleted", (Object)this.toBeDeleted);
    }

    public ConsumerDispatcherState getConsumerDispatcherState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatcherState");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatcherState", (Object)this._subState);
        }
        return this._subState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventPostCommitAdd(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostCommitAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
        }
        HashMap durableSubsTable = this._destinationManager.getDurableSubscriptionsTable();
        ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)durableSubsTable.get(this._subState.getSubscriberID());
        HashMap hashMap = durableSubsTable;
        synchronized (hashMap) {
            this._subState.setReady(true);
        }
        try {
            ((PubSubMessageItemStream)this.getItemStream()).incrementReferenceStreamCount();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.eventPostCommitAdd", (String)"1:544:1.95", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) throws SevereMessageStoreException {
        super.eventPostRollbackAdd(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        this.deleteDurableSubscription(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDurableSubscription(boolean callProxyCode) {
        HashMap durableSubsTable;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDurableSubscription", (Object)new Object[]{new Boolean(callProxyCode)});
        }
        HashMap hashMap = durableSubsTable = this._destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap) {
            block8: {
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)durableSubsTable.get(this._subState.getSubscriberID());
                if (consumerDispatcher != null && consumerDispatcher.dispatcherStateEquals(this._subState)) {
                    durableSubsTable.remove(this._subState.getSubscriberID());
                    try {
                        consumerDispatcher.deleteConsumerDispatcher(callProxyCode);
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream.deleteDurableSubscription", (String)"1:626:1.95", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block8;
                        SibTr.exit((TraceComponent)tc, (String)"deleteDurableSubscription", (Object)((Object)e));
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDurableSubscription");
        }
    }

    @Override
    public boolean hasInDoubtItems() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasInDoubtItems");
            SibTr.exit((TraceComponent)tc, (String)"hasInDoubtItems", (Object)new Boolean(this._inDoubt));
        }
        return this._inDoubt;
    }

    public void clearToBeDeleted() {
        SibTr.entry((TraceComponent)tc, (String)"clearToBeDeleted");
        this.toBeDeleted = false;
        SibTr.exit((TraceComponent)tc, (String)"clearToBeDeleted");
    }
}

