/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.jmf.JMFType;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSDynamic;
import com.ibm.ws.sib.mfp.jmf.impl.JSEnum;
import com.ibm.ws.sib.mfp.jmf.impl.JSPrimitive;
import com.ibm.ws.sib.mfp.jmf.impl.JSRepeated;
import com.ibm.ws.sib.mfp.jmf.impl.JSTuple;
import com.ibm.ws.sib.mfp.jmf.impl.JSVariant;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public abstract class JSType
implements JMFType {
    private static TraceComponent tc = JmfTr.register(JSType.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private String featureName;
    JSType parent;
    int siblingPosition = -1;
    BigInteger multiChoiceCount = BigInteger.ONE;
    private Object association;
    private boolean referenceable;
    static final int DYNAMIC = 1;
    static final int PRIMITIVE = 2;
    static final int TUPLE = 3;
    static final int VARIANT = 4;
    static final int ARRAY = 5;
    static final int ENUM = 6;

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public void setFeatureName(String name) {
        this.featureName = name;
    }

    @Override
    public JMFType getParent() {
        return this.parent;
    }

    @Override
    public int getSiblingPosition() {
        return this.siblingPosition;
    }

    @Override
    public Object getAssociation() {
        return this.association;
    }

    @Override
    public void setAssociation(Object assoc) {
        this.association = assoc;
    }

    @Override
    public boolean isReferenceable() {
        return this.referenceable;
    }

    @Override
    public void setReferenceable(boolean referenceable) {
        this.referenceable = referenceable;
    }

    @Override
    public void updateAssociations(JMFType type) {
        if (!this.getClass().isInstance(type)) {
            throw new IllegalStateException();
        }
        this.association = type.getAssociation();
        this.featureName = type.getFeatureName();
        this.referenceable = type.isReferenceable();
    }

    public BigInteger getMultiChoiceCount() {
        return this.multiChoiceCount;
    }

    BigInteger setMultiChoiceCount() {
        return this.multiChoiceCount;
    }

    public String toString() {
        StringBuffer fmt = new StringBuffer();
        HashSet todo = new HashSet();
        HashSet<JSType> done = new HashSet<JSType>();
        done.add(this);
        this.format(fmt, done, todo, 0);
        while (!todo.isEmpty()) {
            HashSet newTodo = new HashSet();
            for (JSType subSchema : todo) {
                if (subSchema == null) continue;
                fmt.append(",\n");
                done.add(subSchema);
                subSchema.format(fmt, done, newTodo, 0);
            }
            todo = newTodo;
        }
        return fmt.toString();
    }

    void formatName(StringBuffer fmt, int indent) {
        this.indent(fmt, indent);
        String name = this.getFeatureName();
        if (name != null && name.length() > 0) {
            fmt.append(name).append(": ");
        }
    }

    void indent(StringBuffer fmt, int indent) {
        for (int i = 0; i < indent; ++i) {
            fmt.append(" ");
        }
    }

    public abstract void format(StringBuffer var1, Set var2, Set var3, int var4);

    static JSType createJSType(byte[] frame, int[] limits) {
        byte kind = JSType.getByte(frame, limits);
        switch (kind) {
            case 2: {
                return new JSPrimitive(frame, limits);
            }
            case 1: {
                return new JSDynamic();
            }
            case 5: {
                return new JSRepeated(frame, limits);
            }
            case 3: {
                return new JSTuple(frame, limits);
            }
            case 4: {
                return new JSVariant(frame, limits);
            }
            case 6: {
                return new JSEnum(frame, limits);
            }
        }
        return null;
    }

    static byte getByte(byte[] frame, int[] limits) {
        if (limits[0] < limits[1]) {
            int n = limits[0];
            limits[0] = n + 1;
            return frame[n];
        }
        throw new IllegalStateException();
    }

    public static int getCount(byte[] frame, int[] limits) {
        int ans = JSType.getByte(frame, limits) << 8;
        return ans | JSType.getByte(frame, limits) & 0xFF;
    }

    static void setByte(byte[] frame, int[] limits, byte val) {
        if (limits[0] >= limits[1]) {
            throw new IllegalStateException();
        }
        int n = limits[0];
        limits[0] = n + 1;
        frame[n] = val;
    }

    public static void setCount(byte[] frame, int[] limits, int count) {
        JSType.setByte(frame, limits, (byte)(count >>> 8));
        JSType.setByte(frame, limits, (byte)count);
    }

    public abstract void encodeType(byte[] var1, int[] var2);

    public abstract int encodedTypeLength();
}

