/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.internal.WebReply;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuthChallengeReply
extends WebReply {
    private static final TraceComponent tc = Tr.register(OAuthChallengeReply.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private final String reason;
    public static final String AUTHENTICATE_HDR = "WWW-Authenticate";
    static final long serialVersionUID = 900810391635142497L;

    public OAuthChallengeReply(String reason) {
        super(401, reason);
        this.reason = reason;
    }

    @Override
    public void writeResponse(HttpServletResponse rsp) throws IOException {
        if (rsp.isCommitted()) {
            return;
        }
        rsp.setStatus(this.responseCode);
        String wwwAuthenticate = rsp.getHeader(AUTHENTICATE_HDR);
        if (wwwAuthenticate == null || wwwAuthenticate.isEmpty()) {
            wwwAuthenticate = "Bearer realm=\"oauth\"";
            rsp.setHeader(AUTHENTICATE_HDR, wwwAuthenticate);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WWW-Authenticate:'" + wwwAuthenticate + "' code:" + this.responseCode + " reason:" + this.reason), (Object[])new Object[0]);
        }
    }
}

