/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulws.mpmetrics;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs.defaultexceptionmapper.DefaultExceptionMapperCallback;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import jakarta.ws.rs.container.ResourceInfo;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={DefaultExceptionMapperCallback.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class MetricsRestfulWsEMCallbackImpl
implements DefaultExceptionMapperCallback {
    static SharedMetricRegistries sharedMetricRegistry;
    private static final TraceComponent tc;
    public static final String EXCEPTION_KEY;
    private static final String[] metricCDIBundles;
    static final long serialVersionUID = 3957283091589073261L;

    public static synchronized Counter registerOrRetrieveRESTUnmappedExceptionMetric(String fullyQualifiedClassName, String methodSignature) {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        return MetricsRestfulWsEMCallbackImpl.registerOrRetrieveRESTUnmappedExceptionMetric(fullyQualifiedClassName, methodSignature, cmd.getJ2EEName().getApplication());
    }

    public static synchronized Counter registerOrRetrieveRESTUnmappedExceptionMetric(String fullyQualifiedClassName, String methodSignature, String appName) {
        MetricRegistry baseMetricRegistry = sharedMetricRegistry.getOrCreate("base");
        Metadata metadata = Metadata.builder().withName("REST.request.unmappedException.total").withDescription("REST.request.unmappedException.description").build();
        Tag classTag = new Tag("class", fullyQualifiedClassName);
        Tag methodTag = new Tag("method", methodSignature);
        Counter counter = baseMetricRegistry.counter(metadata, new Tag[]{classTag, methodTag});
        sharedMetricRegistry.associateMetricIDToApplication(new MetricID(metadata.getName(), new Tag[]{classTag, methodTag}), appName, baseMetricRegistry);
        return counter;
    }

    public Map<String, Object> onDefaultMappedException(Throwable throwable, int statusCode, ResourceInfo resourceInfo) {
        Map.Entry<String, String> classXmethod;
        StackTraceElement[] ste = throwable.getStackTrace();
        if (!ste[0].getClassName().startsWith(metricCDIBundles[0]) && !ste[0].getClassName().startsWith(metricCDIBundles[1]) && (classXmethod = this.resolveClassMethodTags(resourceInfo)) != null) {
            MetricsRestfulWsEMCallbackImpl.registerOrRetrieveRESTUnmappedExceptionMetric(classXmethod.getKey(), classXmethod.getValue()).inc();
        }
        Tr.warning((TraceComponent)tc, (String)"METRICS_UNHANDLED_RESTFULWS_EXCEPTION", (Object[])new Object[]{throwable});
        return Collections.singletonMap(EXCEPTION_KEY, throwable);
    }

    @Reference
    public void getSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        MetricsRestfulWsEMCallbackImpl.sharedMetricRegistry = sharedMetricRegistry;
    }

    private Map.Entry<String, String> resolveClassMethodTags(ResourceInfo resourceInfo) {
        Object fullMethodSignature;
        String fullyQualifiedClassName;
        block7: {
            block6: {
                Class resourceClass = resourceInfo.getResourceClass();
                fullyQualifiedClassName = null;
                fullMethodSignature = null;
                if (resourceClass != null) {
                    fullyQualifiedClassName = resourceClass.getName();
                    Method resourceMethod = resourceInfo.getResourceMethod();
                    Class<?>[] parameterClasses = resourceMethod.getParameterTypes();
                    fullMethodSignature = resourceMethod.getName();
                    for (Class<?> p : parameterClasses) {
                        String parameter = p.getCanonicalName();
                        fullMethodSignature = (String)fullMethodSignature + "_" + parameter;
                    }
                }
                if (fullMethodSignature == null || fullyQualifiedClassName == null || ((String)fullMethodSignature).isEmpty()) break block6;
                if (!fullyQualifiedClassName.isEmpty()) break block7;
            }
            if (tc.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not resolve the class name or method signature class:[" + (String)fullMethodSignature + "] method:[" + (String)fullMethodSignature + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>(fullyQualifiedClassName, (String)fullMethodSignature);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static {
        tc = Tr.register(MetricsRestfulWsEMCallbackImpl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
        EXCEPTION_KEY = MetricsRestfulWsEMCallbackImpl.class.getName() + ".Exception";
        metricCDIBundles = new String[]{"io.openliberty.smallrye.metrics.cdi.adapters", "io.smallrye.metrics.legacyapi.interceptors", "io.smallrye.metrics"};
    }
}

