/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.rldispatcher;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.AbstractInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ConversationReceiveListenerDataReceivedInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ConversationReceiveListenerErrorOccurredInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDataReceivedInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatchQueue;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerErrorOccurredInvocation;
import com.ibm.ws.sib.jfapchannel.threadpool.ThreadPool;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.ArrayList;
import java.util.List;

public final class ReceiveListenerDispatcher {
    private static final TraceComponent tc = SibTr.register(ReceiveListenerDispatcher.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static ReceiveListenerDispatcher clientInstance;
    private static ReceiveListenerDispatcher serverInstance;
    private static ReceiveListenerDispatcher meInstance;
    protected static final int DEFAULT_MAX_CONCURRENT_DISPATCHES_SERVER = 32;
    protected static final int DEFAULT_MAX_CONCURRENT_DISPATCHES_CLIENT = 1;
    private static final boolean DEFAULT_DISPATCHER_ENABLED = true;
    private int maxConcurrentDispatches = 32;
    private static final int MIN_CONCURRENT_DISPATCHES;
    private static final long RLD_KEEP_ALIVE_TIME;
    private boolean dispatcherEnabled = true;
    private ThreadPool threadPool;
    private ReceiveListenerDispatchQueue[] dispatchQueues;
    private List<ReceiveListenerDispatchQueue> emptyDispatchQueues;
    private ObjectPool receiveListenerDataReceivedInvocationPool;
    private ObjectPool conversationReceiveListenerDataReceivedInvocationPool;
    private ObjectPool receiveListenerErrorOccurredInvocationPool;
    private ObjectPool conversationReceiveListenerErrorOccurredInvocationPool;

    private ReceiveListenerDispatcher(boolean isClientSide, boolean isMEClient) {
        this(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.RL_DISPATCHER_DISABLED") == null, isClientSide, isMEClient);
    }

    private ReceiveListenerDispatcher(boolean dispatcherEnabled, boolean isClientSide, boolean isMEClient) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{dispatcherEnabled, isClientSide});
        }
        this.dispatcherEnabled = dispatcherEnabled;
        if (dispatcherEnabled) {
            this.maxConcurrentDispatches = isClientSide ? Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.MAX_CONCURRENT_DISPATCHES_CLIENT", (String)"1")) : Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.MAX_CONCURRENT_DISPATCHES", (String)"32"));
            this.threadPool = Framework.getInstance().getThreadPool("JS-ReceiveListenerDispatcher", MIN_CONCURRENT_DISPATCHES, this.maxConcurrentDispatches);
            this.threadPool.setRequestBufferSize(this.maxConcurrentDispatches);
            this.threadPool.setKeepAliveTime(RLD_KEEP_ALIVE_TIME);
            this.dispatchQueues = new ReceiveListenerDispatchQueue[this.maxConcurrentDispatches];
            this.emptyDispatchQueues = new ArrayList<ReceiveListenerDispatchQueue>();
            for (int i = 0; i < this.maxConcurrentDispatches; ++i) {
                this.dispatchQueues[i] = new ReceiveListenerDispatchQueue(this.emptyDispatchQueues, this.threadPool, isMEClient ? ReceiveListenerDispatchQueue.QueueType.ME_Client : ReceiveListenerDispatchQueue.QueueType.ME_ME);
            }
        }
        int dataReceivedInvocationPoolSize = 5 * this.maxConcurrentDispatches;
        int errorOccurredInvocationPoolSize = 5 * this.maxConcurrentDispatches;
        this.receiveListenerDataReceivedInvocationPool = new ObjectPool("JS data received invocation pool", dataReceivedInvocationPoolSize);
        this.receiveListenerErrorOccurredInvocationPool = new ObjectPool("JS error occurred invocation pool", errorOccurredInvocationPoolSize);
        this.conversationReceiveListenerDataReceivedInvocationPool = new ObjectPool("JS data received invocation pool", dataReceivedInvocationPoolSize);
        this.conversationReceiveListenerErrorOccurredInvocationPool = new ObjectPool("JS error occurred invocation pool", errorOccurredInvocationPoolSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    private ReceiveListenerDataReceivedInvocation allocateDataReceivedInvocation(Connection connection, ReceiveListener listener, WsByteBuffer data, int size, int segmentType, int requestNumber, int priority, boolean allocatedFromPool, boolean partOfExchange, Conversation conversation) {
        ReceiveListenerDataReceivedInvocation retInvocation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocateDataReceivedInvocation", (Object)new Object[]{connection, listener, data, "" + size, "" + segmentType, "" + requestNumber, "" + priority, "" + allocatedFromPool, "" + partOfExchange, conversation});
        }
        if ((retInvocation = (ReceiveListenerDataReceivedInvocation)this.receiveListenerDataReceivedInvocationPool.remove()) == null) {
            retInvocation = new ReceiveListenerDataReceivedInvocation(connection, listener, data, size, segmentType, requestNumber, priority, allocatedFromPool, partOfExchange, conversation, this.receiveListenerDataReceivedInvocationPool);
        } else {
            retInvocation.reset(connection, listener, data, size, segmentType, requestNumber, priority, allocatedFromPool, partOfExchange, conversation);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocateDataReceivedInvocation", (Object)retInvocation);
        }
        return retInvocation;
    }

    private ConversationReceiveListenerDataReceivedInvocation allocateDataReceivedInvocation(Connection connection, ConversationReceiveListener listener, WsByteBuffer data, int size, int segmentType, int requestNumber, int priority, boolean allocatedFromPool, boolean partOfExchange, Conversation conversation) {
        ConversationReceiveListenerDataReceivedInvocation retInvocation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocateDataReceivedInvocation", (Object)new Object[]{connection, listener, data, "" + size, "" + segmentType, "" + requestNumber, "" + priority, "" + allocatedFromPool, "" + partOfExchange, conversation});
        }
        if ((retInvocation = (ConversationReceiveListenerDataReceivedInvocation)this.conversationReceiveListenerDataReceivedInvocationPool.remove()) == null) {
            retInvocation = new ConversationReceiveListenerDataReceivedInvocation(connection, listener, data, size, segmentType, requestNumber, priority, allocatedFromPool, partOfExchange, conversation, this.conversationReceiveListenerDataReceivedInvocationPool);
        } else {
            retInvocation.reset(connection, listener, data, size, segmentType, requestNumber, priority, allocatedFromPool, partOfExchange, conversation);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocateDataReceivedInvocation", (Object)retInvocation);
        }
        return retInvocation;
    }

    private ReceiveListenerErrorOccurredInvocation allocateErrorOccurredInvocation(Connection connection, ReceiveListener listener, SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
        ReceiveListenerErrorOccurredInvocation retInvocation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocateErrorOccurredInvocation", (Object)new Object[]{connection, listener, exception, "" + segmentType, "" + requestNumber, "" + priority, conversation});
        }
        if ((retInvocation = (ReceiveListenerErrorOccurredInvocation)this.receiveListenerErrorOccurredInvocationPool.remove()) == null) {
            retInvocation = new ReceiveListenerErrorOccurredInvocation(connection, listener, exception, segmentType, requestNumber, priority, conversation, this.receiveListenerErrorOccurredInvocationPool);
        } else {
            retInvocation.reset(connection, listener, exception, segmentType, requestNumber, priority, conversation);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocateErrorOccurredInvocation", (Object)retInvocation);
        }
        return retInvocation;
    }

    private ConversationReceiveListenerErrorOccurredInvocation allocateErrorOccurredInvocation(Connection connection, ConversationReceiveListener listener, SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
        ConversationReceiveListenerErrorOccurredInvocation retInvocation;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocateErrorOccurredInvocation", (Object)new Object[]{connection, listener, exception, "" + segmentType, "" + requestNumber, "" + priority, conversation});
        }
        if ((retInvocation = (ConversationReceiveListenerErrorOccurredInvocation)this.conversationReceiveListenerErrorOccurredInvocationPool.remove()) == null) {
            retInvocation = new ConversationReceiveListenerErrorOccurredInvocation(connection, listener, exception, segmentType, requestNumber, priority, conversation, this.conversationReceiveListenerErrorOccurredInvocationPool);
        } else {
            retInvocation.reset(connection, listener, exception, segmentType, requestNumber, priority, conversation);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocateDataReceivedInvocation", (Object)retInvocation);
        }
        return retInvocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueInvocationCommon(AbstractInvocation invocation, ConversationImpl conversation) {
        block27: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"queueInvocationCommon", (Object)new Object[]{invocation, conversation});
            }
            if (this.dispatcherEnabled) {
                try {
                    List<ReceiveListenerDispatchQueue> dispatchableLock;
                    Dispatchable dispatchable = invocation.getThreadContext();
                    if (dispatchable == null) {
                        dispatchable = conversation;
                    }
                    invocation.setDispatchable(dispatchable);
                    Object object = conversation.getTotalOutstandingRequestCountLock();
                    synchronized (object) {
                        conversation.incrementTotalOutstandingCount();
                    }
                    ReceiveListenerDispatchQueue dispatchQueue = null;
                    List<ReceiveListenerDispatchQueue> list = dispatchableLock = dispatchable.getDispatchLockObject();
                    synchronized (list) {
                        dispatchQueue = (ReceiveListenerDispatchQueue)dispatchable.getDispatchQueue();
                        if (dispatchQueue != null) {
                            dispatchable.incrementDispatchQueueRefCount();
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"queueInvocationCommon", (Object)("dispatchQueue=" + dispatchQueue));
                    }
                    if (dispatchQueue == null) {
                        list = this.emptyDispatchQueues;
                        synchronized (list) {
                            if (!this.emptyDispatchQueues.isEmpty()) {
                                dispatchQueue = this.emptyDispatchQueues.remove(this.emptyDispatchQueues.size() - 1);
                            } else {
                                int queueNumber = conversation.getInstanceCounterValue();
                                dispatchQueue = this.dispatchQueues[queueNumber % this.maxConcurrentDispatches];
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("dispatchQueue=" + dispatchQueue));
                        }
                        list = dispatchableLock;
                        synchronized (list) {
                            dispatchable.setDispatchQueue(dispatchQueue);
                            dispatchable.incrementDispatchQueueRefCount();
                        }
                    }
                    invocation.resetReferenceCounts();
                    dispatchQueue.enqueue(invocation);
                }
                catch (RuntimeException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Looks like getThreadContext failed:", (Object)e);
                    }
                    break block27;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher", (String)"00220001", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"RL Dispatcher threw an exception: ", (Object)t);
                    }
                    break block27;
                }
            }
            invocation.invoke();
            invocation.repool();
            invocation.resetReferenceCounts();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"queueInvocationCommon");
        }
    }

    public void queueDataReceivedInvocation(Connection connection, ReceiveListener listener, WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"queueDataReceivedInvocation", (Object)new Object[]{connection, listener, data, "" + segmentType, "" + requestNumber, "" + priority, "" + allocatedFromBufferPool, "" + partOfExchange, conversation});
        }
        int dataSize = 0;
        if (this.dispatcherEnabled) {
            dataSize = data.position();
        }
        ReceiveListenerDataReceivedInvocation invocation = this.allocateDataReceivedInvocation(connection, listener, data, dataSize, segmentType, requestNumber, priority, allocatedFromBufferPool, partOfExchange, conversation);
        this.queueInvocationCommon(invocation, (ConversationImpl)conversation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"queueDataReceivedInvocation");
        }
    }

    public void queueDataReceivedInvocation(Connection connection, ConversationReceiveListener listener, WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"queueDataReceivedInvocation", (Object)new Object[]{connection, listener, data, "" + segmentType, "" + requestNumber, "" + priority, "" + allocatedFromBufferPool, "" + partOfExchange, conversation});
        }
        int dataSize = 0;
        if (this.dispatcherEnabled) {
            dataSize = data.position();
        }
        ConversationReceiveListenerDataReceivedInvocation invocation = this.allocateDataReceivedInvocation(connection, listener, data, dataSize, segmentType, requestNumber, priority, allocatedFromBufferPool, partOfExchange, conversation);
        this.queueInvocationCommon(invocation, (ConversationImpl)conversation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"queueDataReceivedInvocation");
        }
    }

    public void queueErrorOccurredInvocation(Connection connection, ReceiveListener listener, SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"queueErrorOccurredInvocation", (Object)new Object[]{connection, listener, exception, "" + segmentType, "" + requestNumber, "" + priority, conversation});
        }
        ReceiveListenerErrorOccurredInvocation invocation = this.allocateErrorOccurredInvocation(connection, listener, exception, segmentType, requestNumber, priority, conversation);
        this.queueInvocationCommon(invocation, (ConversationImpl)conversation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"queueErrorOccurredInvocation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueErrorOccurredInvocation(Connection connection, ConversationReceiveListener listener, SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"queueErrorOccurredInvocation", (Object)new Object[]{connection, listener, exception, "" + segmentType, "" + requestNumber, "" + priority, conversation});
        }
        ConversationReceiveListenerErrorOccurredInvocation invocation = this.allocateErrorOccurredInvocation(connection, listener, exception, segmentType, requestNumber, priority, conversation);
        ConversationImpl convImpl = (ConversationImpl)conversation;
        int conversationRequestCount = 0;
        boolean queueIt = true;
        Object object = convImpl.getTotalOutstandingRequestCountLock();
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Queueing a errorOccurred invocation for ", (Object)conversation);
            }
            conversationRequestCount = convImpl.getTotalOutstandingRequestCount();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Request count is: " + conversationRequestCount));
            }
            if (conversationRequestCount != 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Count != 0, saving");
                }
                convImpl.setErrorOccurredInvocation(invocation);
                queueIt = false;
            }
        }
        if (queueIt) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Count = 0, queueing");
            }
            this.queueInvocationCommon(invocation, convImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"queueErrorOccurredInvocation");
        }
    }

    protected ReceiveListenerDispatchQueue[] getDispatchQueues() {
        return this.dispatchQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ReceiveListenerDispatcher getInstance(Conversation.ConversationType convType, boolean isOnClientSide) {
        ReceiveListenerDispatcher retInstance;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInstance", (Object)new Object[]{"" + convType, "" + isOnClientSide});
        }
        if (convType == Conversation.CLIENT) {
            if (isOnClientSide) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Returning client instance");
                }
                Class<ReceiveListenerDispatcher> clazz = ReceiveListenerDispatcher.class;
                // MONITORENTER : com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher.class
                if (clientInstance == null) {
                    clientInstance = new ReceiveListenerDispatcher(true, true);
                }
                // MONITOREXIT : clazz
                retInstance = clientInstance;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Returning server instance");
                }
                Class<ReceiveListenerDispatcher> clazz = ReceiveListenerDispatcher.class;
                // MONITORENTER : com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher.class
                if (serverInstance == null) {
                    serverInstance = new ReceiveListenerDispatcher(false, true);
                }
                // MONITOREXIT : clazz
                retInstance = serverInstance;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Returning ME-ME instance");
            }
            Class<ReceiveListenerDispatcher> clazz = ReceiveListenerDispatcher.class;
            // MONITORENTER : com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher.class
            if (meInstance == null) {
                meInstance = new ReceiveListenerDispatcher(false, false);
            }
            // MONITOREXIT : clazz
            retInstance = meInstance;
        }
        if (!TraceComponent.isAnyTracingEnabled()) return retInstance;
        if (!tc.isEntryEnabled()) return retInstance;
        SibTr.exit((TraceComponent)tc, (String)"getInstance", (Object)retInstance);
        return retInstance;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"08:47:51 @(#) 1.31");
        }
        MIN_CONCURRENT_DISPATCHES = Integer.parseInt(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.MIN_CONCURRENT_DISPATCHES", (String)"1"));
        RLD_KEEP_ALIVE_TIME = Long.parseLong(RuntimeInfo.getPropertyWithMsg((String)"com.ibm.ws.sib.jfapchannel.RLD_KEEP_ALIVE_TIME", (String)"5000"));
    }
}

