/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;

public class Transaction
implements Printable {
    private static final Class cclass = Transaction.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    public static final int stateError = 0;
    public static final int stateInactive = 1;
    public static final int stateActiveNonPersistent = 2;
    public static final int stateActivePersistent = 3;
    public static final int statePrePreparedInactive = 4;
    public static final int statePrePreparedNonPersistent = 5;
    public static final int statePrePreparedPersistent = 6;
    public static final int statePreparedInactive = 7;
    public static final int statePreparedNonPersistent = 8;
    public static final int statePreparedPersistent = 9;
    public static final int stateCommitingInactive = 10;
    public static final int stateCommitingNonPersistent = 11;
    public static final int stateCommitingPersistent = 12;
    public static final int stateBackingOutInactive = 13;
    public static final int stateBackingOutNonPersistent = 14;
    public static final int stateBackingOutPersistent = 15;
    public static final int stateTerminated = 16;
    public static final int terminatedNotTerminated = 0;
    public static final int terminatedByUser = 1;
    public static final int terminatedShutdown = 2;
    public static final int terminatedLogTooFull = 3;
    public static final int terminatedOrphanBackedOut = 4;
    public static final int terminatedDuplicate = 5;
    public static final String[] terminationReasonNames = new String[]{"NotTerminated", "User", "Shutdown", "LogTooFull", "OrphanBackedOut", "Duplicate"};
    private int terminationReason = 1;
    protected volatile InternalTransaction internalTransaction;

    protected Transaction(InternalTransaction internalTransaction) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", internalTransaction);
        }
        this.internalTransaction = internalTransaction;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public int getObjectManagerStateState() {
        return this.internalTransaction.objectManagerState.getObjectManagerStateState();
    }

    public int getState() {
        return this.internalTransaction.getState();
    }

    public LogicalUnitOfWork getLogicalUnitOfWork() {
        return this.internalTransaction.getLogicalUnitOfWork();
    }

    public byte[] getXID() {
        return this.internalTransaction.getXID();
    }

    public void setXID(byte[] XID) throws ObjectManagerException {
        this.internalTransaction.setXID(XID);
    }

    public Collection getIncludedManagedObjects() {
        return this.internalTransaction.getIncludedManagedObjects();
    }

    public long getTransactionUnlockSequence() {
        return this.internalTransaction.objectManagerState.getTransactionUnlockSequence();
    }

    public void requestCallback(Token tokenToCallBack) throws ObjectManagerException {
        this.internalTransaction.requestCallback(tokenToCallBack, this);
    }

    public void lock(ManagedObject managedObject) throws ObjectManagerException {
        this.internalTransaction.lock(managedObject);
    }

    public void add(ManagedObject managedObject) throws ObjectManagerException {
        this.internalTransaction.add(managedObject, this, 0L);
    }

    public void add(ManagedObject managedObject, long logSpaceReservedDelta) throws ObjectManagerException {
        this.internalTransaction.add(managedObject, this, logSpaceReservedDelta);
    }

    protected void addFromCheckpoint(ManagedObject managedObject) throws ObjectManagerException {
        this.internalTransaction.addFromCheckpoint(managedObject, this);
    }

    public void replace(ManagedObject managedObject) throws ObjectManagerException {
        this.internalTransaction.replace(managedObject, this, 0L);
    }

    public void replace(ManagedObject managedObject, long logSpaceReservedDelta) throws ObjectManagerException {
        this.internalTransaction.replace(managedObject, this, logSpaceReservedDelta);
    }

    protected void replaceFromCheckpoint(ManagedObject managedObject, byte[] serializedBytes) throws ObjectManagerException {
        this.internalTransaction.replaceFromCheckpoint(managedObject, serializedBytes, this);
    }

    public void optimisticReplace(List managedObjectsToAdd, List managedObjectsToReplace, List managedObjectsToDelete, List tokensToNotify) throws ObjectManagerException {
        this.internalTransaction.optimisticReplace(managedObjectsToAdd, managedObjectsToReplace, managedObjectsToDelete, tokensToNotify, this, 0L);
    }

    public void optimisticReplace(List managedObjectsToAdd, List managedObjectsToReplace, List managedObjectsToDelete, List tokensToNotify, long logSpaceReservedDelta) throws ObjectManagerException {
        this.internalTransaction.optimisticReplace(managedObjectsToAdd, managedObjectsToReplace, managedObjectsToDelete, tokensToNotify, this, logSpaceReservedDelta);
    }

    protected void optimisticReplaceFromCheckpoint(ManagedObject managedObject) throws ObjectManagerException {
        this.internalTransaction.optimisticReplaceFromCheckpoint(managedObject, this);
    }

    protected void notifyFromCheckpoint(Token token) throws ObjectManagerException {
        this.internalTransaction.notifyFromCheckpoint(token, this);
    }

    public void delete(ManagedObject managedObject) throws ObjectManagerException {
        this.internalTransaction.delete(managedObject, this, 0L);
    }

    public void delete(ManagedObject managedObject, long logSpaceReservedDelta) throws ObjectManagerException {
        this.internalTransaction.delete(managedObject, this, logSpaceReservedDelta);
    }

    protected void deleteFromCheckpoint(ManagedObject managedObject) throws ObjectManagerException {
        this.internalTransaction.deleteFromCheckpoint(managedObject, this);
    }

    public void prepare() throws ObjectManagerException {
        this.internalTransaction.prepare(this);
    }

    public void commit(boolean reUse) throws ObjectManagerException {
        this.internalTransaction.commit(reUse, this);
    }

    public void backout(boolean reUse) throws ObjectManagerException {
        this.internalTransaction.backout(reUse, this);
    }

    protected void recoveryCompleted() throws ObjectManagerException {
        this.internalTransaction.recoveryCompleted(this);
    }

    @Override
    public void print(PrintWriter printWriter) {
        this.internalTransaction.print(printWriter);
    }

    public int getTerminationReason() {
        if (this.internalTransaction.getState() != 16) {
            return 0;
        }
        return this.terminationReason;
    }

    void setTerminationReason(int terminationReason) {
        this.terminationReason = terminationReason;
    }

    public String toString() {
        if (this.internalTransaction == null) {
            return new String("Transaction(null)/" + Integer.toHexString(this.hashCode()));
        }
        return new String("Transaction(" + this.internalTransaction.toString() + ")/" + Integer.toHexString(this.hashCode()));
    }

    public void finalize() {
        if (null != this.internalTransaction) {
            this.internalTransaction.finaliseTick = System.currentTimeMillis();
        }
    }
}

