/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.exception.ExecutionAssignedToServerException;
import com.ibm.jbatch.container.exception.JobStoppedException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV2;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV3;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV2;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV3;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntityV2;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceKey;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceKey;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.AbstractPersistenceManager;
import com.ibm.jbatch.container.services.impl.TranSynchronization;
import com.ibm.jbatch.container.util.WSPartitionStepAggregateImpl;
import com.ibm.jbatch.container.util.WSStepThreadExecutionAggregateImpl;
import com.ibm.jbatch.container.validation.IdentifierValidator;
import com.ibm.jbatch.container.ws.BatchLocationService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.JobInstanceNotQueuedException;
import com.ibm.jbatch.container.ws.WSPartitionStepAggregate;
import com.ibm.jbatch.container.ws.WSPartitionStepThreadExecution;
import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.jbatch.container.ws.WSRemotablePartitionState;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.jbatch.container.persistence"}, service={IPersistenceManagerService.class, DDLGenerationParticipant.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM", "service.ranking:Integer=20", "persistenceType=JPA"})
public class JPAPersistenceManagerImpl
extends AbstractPersistenceManager
implements IPersistenceManagerService,
DDLGenerationParticipant {
    private static final Logger logger = Logger.getLogger(JPAPersistenceManagerImpl.class.getName(), "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    private EmbeddableWebSphereTransactionManager tranMgr;
    private LocalTransactionCurrent localTranCurrent;
    private DatabaseStore databaseStore;
    private String databaseStoreDisplayId;
    private BatchLocationService batchLocationService;
    private ExecutorService executorService;
    private volatile PersistenceServiceUnit psu;
    private Integer executionVersion;
    private Integer instanceVersion;
    private Integer partitionVersion;
    private static final int MAX_EXECUTION_VERSION = 3;
    private static final int MAX_INSTANCE_VERSION = 3;
    private static final int MAX_PARTITION_VERSION = 2;
    static final long serialVersionUID = 43060228312646662L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JPAPersistenceManagerImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "<init>", new Object[0]);
        }
        this.executionVersion = null;
        this.instanceVersion = null;
        this.partitionVersion = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(target="(component.name=com.ibm.ws.threading)")
    protected void setExecutorService(ExecutorService executorService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setExecutorService", new Object[]{executorService});
        }
        this.executorService = executorService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setExecutorService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(name="jobStore", target="(id=unbound)")
    protected void setDatabaseStore(DatabaseStore databaseStore, Map<String, Object> props) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setDatabaseStore", new Object[]{databaseStore, props});
        }
        this.databaseStore = databaseStore;
        this.databaseStoreDisplayId = (String)props.get("config.displayId");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setDatabaseStore");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setTransactionManager(EmbeddableWebSphereTransactionManager svc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setTransactionManager", new Object[]{svc});
        }
        this.tranMgr = svc;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setTransactionManager");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setLocalTransactionCurrent(LocalTransactionCurrent ltc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setLocalTransactionCurrent", new Object[]{ltc});
        }
        this.localTranCurrent = ltc;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setLocalTransactionCurrent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchLocationService(BatchLocationService batchLocationService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setBatchLocationService", new Object[]{batchLocationService});
        }
        this.batchLocationService = batchLocationService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setBatchLocationService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "activate", new Object[]{context, config});
        }
        logger.log(Level.INFO, "persistence.service.status", new Object[]{"JPA", "activated"});
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deactivate", new Object[0]);
        }
        if (this.psu != null) {
            try {
                this.psu.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"251", (Object)this, (Object[])new Object[0]);
            }
        }
        logger.log(Level.INFO, "persistence.service.status", new Object[]{"JPA", "deactivated"});
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deactivate");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "init");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "shutdown", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "shutdown");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PersistenceServiceUnit getPsu() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPsu", new Object[0]);
        }
        if (this.psu == null) {
            try {
                this.psu = this.createPsu();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"278", (Object)this, (Object[])new Object[0]);
                throw new BatchRuntimeException("Failed to load JPA PersistenceServiceUnit", (Throwable)e);
            }
        }
        PersistenceServiceUnit persistenceServiceUnit = this.psu;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PersistenceServiceUnit createLatestPsu() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createLatestPsu", new Object[0]);
        }
        PersistenceServiceUnit persistenceServiceUnit = this.createPsu(3, 3, 2);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createLatestPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PersistenceServiceUnit createPsu(int jobInstanceVersion, int jobExecutionVersion, int partitionVersion) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", new Object[]{jobInstanceVersion, jobExecutionVersion, partitionVersion});
        }
        ArrayList<String> entityClasses = new ArrayList<String>(Arrays.asList(StepThreadInstanceEntity.class.getName(), TopLevelStepExecutionEntity.class.getName(), TopLevelStepInstanceEntity.class.getName()));
        if (jobExecutionVersion <= 1) {
            entityClasses.add(JobExecutionEntity.class.getName());
        } else if (jobExecutionVersion == 2) {
            entityClasses.add(JobExecutionEntityV2.class.getName());
        } else if (jobExecutionVersion >= 3) {
            entityClasses.add(JobExecutionEntityV3.class.getName());
        }
        if (jobInstanceVersion <= 1) {
            JobInstanceEntity.class.getName();
        } else if (jobInstanceVersion == 2) {
            entityClasses.add(JobInstanceEntityV2.class.getName());
        } else if (jobInstanceVersion >= 3) {
            entityClasses.add(JobInstanceEntityV3.class.getName());
        }
        if (partitionVersion <= 1) {
            entityClasses.add(StepThreadExecutionEntity.class.getName());
        } else if (partitionVersion >= 2) {
            entityClasses.add(StepThreadExecutionEntityV2.class.getName());
            entityClasses.add(RemotablePartitionEntity.class.getName());
        }
        PersistenceServiceUnit persistenceServiceUnit = this.databaseStore.createPersistenceServiceUnit(JobInstanceEntity.class.getClassLoader(), entityClasses.toArray(new String[0]));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private synchronized PersistenceServiceUnit createPsu() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", new Object[0]);
        }
        if (this.psu != null) {
            PersistenceServiceUnit persistenceServiceUnit = this.psu;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                persistenceServiceUnit = persistenceServiceUnit;
                logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", persistenceServiceUnit);
            }
            return persistenceServiceUnit;
        }
        PersistenceServiceUnit retMe = this.createLatestPsu();
        this.instanceVersion = 3;
        this.executionVersion = 3;
        this.partitionVersion = 2;
        this.setPartitionEntityVersion(retMe);
        if (this.partitionVersion < 2) {
            logger.fine("The REMOTABLEPARTITION table could not be found. The persistence service unit will exclude the remotable partition entity.");
            retMe.close();
            retMe = this.createPsu(this.instanceVersion, this.executionVersion, this.partitionVersion);
        }
        this.setJobInstanceEntityVersion(retMe);
        if (this.instanceVersion < 3) {
            logger.fine("The GROUPNAMES column could not be found. The persistence service unit will exclude the V3 instance entity.");
            retMe.close();
            retMe = this.createPsu(this.instanceVersion, this.executionVersion, this.partitionVersion);
        }
        this.setJobExecutionEntityVersion(retMe);
        if (this.executionVersion < 2) {
            logger.fine("The JOBPARAMETERS table could not be found. The persistence service unit will exclude the V2 execution entity.");
            retMe.close();
            retMe = this.createPsu(this.instanceVersion, this.executionVersion, this.partitionVersion);
        }
        WSStartupRecoveryServiceImpl startupRecovery = new WSStartupRecoveryServiceImpl().setIPersistenceManagerService(this).setPersistenceServiceUnit(retMe).recoverLocalJobsInInflightStates();
        if (this.partitionVersion >= 2) {
            startupRecovery.recoverLocalPartitionsInInflightStates();
        }
        PersistenceServiceUnit persistenceServiceUnit = this.psu = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getDisplayId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDisplayId", new Object[0]);
        }
        Pattern pattern = Pattern.compile(".*\\[(.*)\\]");
        Matcher matcher = pattern.matcher(this.databaseStoreDisplayId);
        matcher.find();
        String string = matcher.group(1);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDisplayId", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPersistenceType() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPersistenceType", new Object[0]);
        }
        String string = "JPA";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPersistenceType", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity createJobInstance(String appName, String jobXMLName, String submitter, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", new Object[]{appName, jobXMLName, submitter, createTime});
        }
        JobInstanceEntity jobInstanceEntity = this.createJobInstance(appName, jobXMLName, null, submitter, createTime);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity createJobInstance(final String appName, final String jobXMLName, final String jsl, final String submitter, final Date createTime) {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", new Object[]{appName, jobXMLName, jsl, submitter, createTime});
            }
            em = this.getPsu().createEntityManager();
            JobInstanceEntity instance = (JobInstanceEntity)new TranRequest<JobInstanceEntity>(em){
                static final long serialVersionUID = 5317654804964555255L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstanceEntity call() {
                    JobInstanceEntity jobInstance = JPAPersistenceManagerImpl.this.instanceVersion == 2 ? new JobInstanceEntityV2() : (JPAPersistenceManagerImpl.this.instanceVersion >= 3 ? new JobInstanceEntityV3() : new JobInstanceEntity());
                    jobInstance.setAmcName(appName);
                    jobInstance.setJobXmlName(jobXMLName);
                    jobInstance.setJobXml(jsl);
                    jobInstance.setSubmitter(submitter);
                    jobInstance.setCreateTime(createTime);
                    jobInstance.setLastUpdatedTime(createTime);
                    jobInstance.setInstanceState(InstanceState.SUBMITTED);
                    jobInstance.setBatchStatus(BatchStatus.STARTING);
                    this.entityMgr.persist((Object)jobInstance);
                    return jobInstance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$1", 1.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            IdentifierValidator.validatePersistedJobInstanceIds(instance);
            JobInstanceEntity jobInstanceEntity2 = instance;
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity getJobInstance(final long jobInstanceId) throws NoSuchJobInstanceException {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstance", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            JobInstanceEntity instance = (JobInstanceEntity)new TranRequest<JobInstanceEntity>(em){
                static final long serialVersionUID = -433648543874992769L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstanceEntity call() {
                    return (JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)jobInstanceId);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$2", 2.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            if (instance == null) {
                throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
            }
            JobInstanceEntity jobInstanceEntity2 = instance;
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity getJobInstanceFromExecutionId(final long jobExecutionId) throws NoSuchJobExecutionException {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceFromExecutionId", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity exec = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = -712351542445849202L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() {
                    return (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)jobExecutionId);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$3", 3.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            if (exec == null) {
                throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
            }
            JobInstanceEntity jobInstanceEntity2 = exec.getJobInstance();
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceFromExecutionId", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(final String jobName, final int start, final int count) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{jobName, start, count});
            }
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<JobInstanceEntity>>(em){
                static final long serialVersionUID = 4349683036412404729L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<JobInstanceEntity> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameQuery", JobInstanceEntity.class);
                    query.setParameter("name", (Object)jobName);
                    List ids = query.setFirstResult(start).setMaxResults(count).getResultList();
                    if (ids == null) {
                        return new ArrayList<JobInstanceEntity>();
                    }
                    return ids;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$4", 4.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(final String jobName, final String submitter, final int start, final int count) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{jobName, submitter, start, count});
            }
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<JobInstanceEntity>>(em){
                static final long serialVersionUID = -2237896161326774084L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<JobInstanceEntity> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameAndSubmitterQuery", JobInstanceEntity.class);
                    query.setParameter("name", (Object)jobName);
                    query.setParameter("submitter", (Object)submitter);
                    List ids = query.setFirstResult(start).setMaxResults(count).getResultList();
                    if (ids == null) {
                        return new ArrayList<JobInstanceEntity>();
                    }
                    return ids;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$5", 5.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(final int page, final int pageSize) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{page, pageSize});
            }
            final ArrayList result = new ArrayList();
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<JobInstanceEntity>>(em){
                static final long serialVersionUID = -3568476401881002658L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<JobInstanceEntity> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortIdAllQuery", JobInstanceEntity.class);
                    List jobList = query.setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
                    if (jobList != null) {
                        for (JobInstanceEntity instance : jobList) {
                            result.add(instance);
                        }
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$6", 6.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(final IJPAQueryHelper queryHelper, final int page, final int pageSize) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{queryHelper, page, pageSize});
            }
            final ArrayList result = new ArrayList();
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<JobInstanceEntity>>(em){
                static final long serialVersionUID = 8196895902124109858L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<JobInstanceEntity> call() throws Exception {
                    String jpaQueryString = queryHelper.getQuery();
                    TypedQuery query = em.createQuery(jpaQueryString, JobInstanceEntity.class);
                    queryHelper.setQueryParameters((TypedQuery<JobInstanceEntity>)query);
                    List jobList = query.setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
                    if (jobList != null) {
                        for (JobInstanceEntity instance : jobList) {
                            result.add(instance);
                        }
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$7", 7.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(final int page, final int pageSize, final String submitter) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{page, pageSize, submitter});
            }
            final ArrayList result = new ArrayList();
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<JobInstanceEntity>>(em){
                static final long serialVersionUID = 2003544863530129159L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<JobInstanceEntity> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortIdBySubmitterQuery", JobInstanceEntity.class);
                    query.setParameter("submitter", (Object)submitter);
                    List jobList = query.setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
                    if (jobList != null) {
                        for (JobInstanceEntity instance : jobList) {
                            result.add(instance);
                        }
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$8", 8.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNamesSet() {
        Set set;
        EntityManager em;
        block4: {
            Set exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", new Object[0]);
            }
            em = this.getPsu().createEntityManager();
            Set set2 = exec = (Set)new TranRequest<Set<String>>(em){
                static final long serialVersionUID = -4700735503667832634L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Set<String> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobNamesSetQuery", String.class);
                    List result = query.getResultList();
                    if (result == null) {
                        return new HashSet<String>();
                    }
                    return JPAPersistenceManagerImpl.this.cleanUpResult(new HashSet(result));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$9", 9.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            set = set2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            set = set;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", set);
        }
        return set;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNamesSet(final String submitter) {
        Set set;
        EntityManager em;
        block4: {
            Set exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", new Object[]{submitter});
            }
            em = this.getPsu().createEntityManager();
            Set set2 = exec = (Set)new TranRequest<Set<String>>(em){
                static final long serialVersionUID = -7718349759457505406L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Set<String> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobNamesSetBySubmitterQuery", String.class);
                    query.setParameter("submitter", (Object)submitter);
                    List result = query.getResultList();
                    if (result == null) {
                        return new HashSet<String>();
                    }
                    return JPAPersistenceManagerImpl.this.cleanUpResult(new HashSet(result));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$10", 10.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            set = set2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            set = set;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", set);
        }
        return set;
        finally {
            em.close();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Set<String> cleanUpResult(Set<String> s) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "cleanUpResult", new Object[]{s});
        }
        s.remove(null);
        Set<String> set = s;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "cleanUpResult", set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceCount(final String jobName) {
        int n;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", new Object[]{jobName});
            }
            em = this.getPsu().createEntityManager();
            Integer exec = (Integer)new TranRequest<Integer>(em){
                static final long serialVersionUID = -2619355047420031249L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Integer call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstanceCountByJobNameQuery", Long.class);
                    query.setParameter("name", (Object)jobName);
                    Long result = (Long)query.getSingleResult();
                    if (result > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("More than MAX_INTEGER results found.");
                    }
                    return result.intValue();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$11", 11.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            int n2 = exec;
            n = n2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", n);
        }
        return n;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceCount(final String jobName, final String submitter) {
        int n;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", new Object[]{jobName, submitter});
            }
            em = this.getPsu().createEntityManager();
            Integer exec = (Integer)new TranRequest<Integer>(em){
                static final long serialVersionUID = -1281838092039849195L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Integer call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstanceCountByJobNameAndSubmitterQuery", Long.class);
                    query.setParameter("name", (Object)jobName);
                    query.setParameter("submitter", (Object)submitter);
                    Long result = (Long)query.getSingleResult();
                    if (result > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("More than MAX_INTEGER results found.");
                    }
                    return result.intValue();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$12", 12.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            int n2 = exec;
            n = n2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", n);
        }
        return n;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity updateJobInstanceWithInstanceState(final long jobInstanceId, final InstanceState state, final Date lastUpdated) {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceState", new Object[]{jobInstanceId, state, lastUpdated});
            }
            em = this.getPsu().createEntityManager();
            JobInstanceEntity jobInstanceEntity2 = (JobInstanceEntity)new TranRequest<JobInstanceEntity>(em){
                static final long serialVersionUID = 8481485842086159630L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobInstanceEntity call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, state);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$13", (String)"749", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    instance.setInstanceState(state);
                    instance.setLastUpdatedTime(lastUpdated);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$13", 13.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceState", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceOnRestart(final long jobInstanceId, final Date lastUpdated) {
        JobInstance jobInstance;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceOnRestart", new Object[]{jobInstanceId, lastUpdated});
            }
            em = this.getPsu().createEntityManager();
            String BASE_UPDATE = "UPDATE JobInstanceEntity x SET x.instanceState = :instanceState,x.batchStatus = :batchStatus";
            if (this.instanceVersion >= 2) {
                BASE_UPDATE = BASE_UPDATE.replace("JobInstanceEntity", "JobInstanceEntityV2").concat(",x.lastUpdatedTime = :lastUpdatedTime");
            }
            StringBuilder query = new StringBuilder().append(BASE_UPDATE);
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("x.instanceId = :instanceId");
            whereClause.append(" AND x.instanceState IN (com.ibm.jbatch.container.ws.InstanceState.STOPPED,");
            whereClause.append(" com.ibm.jbatch.container.ws.InstanceState.FAILED)");
            query.append(" WHERE " + whereClause);
            final String FINAL_UPDATE = query.toString();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = 6359743790957856850L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, InstanceState.SUBMITTED);
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(instance, BatchStatus.STARTING);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$14", (String)"791", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    Query jpaQuery = this.entityMgr.createQuery(FINAL_UPDATE);
                    jpaQuery.setParameter("instanceState", (Object)InstanceState.SUBMITTED);
                    jpaQuery.setParameter("instanceId", (Object)jobInstanceId);
                    if (JPAPersistenceManagerImpl.this.instanceVersion >= 2) {
                        jpaQuery.setParameter("lastUpdatedTime", (Object)lastUpdated);
                    }
                    jpaQuery.setParameter("batchStatus", (Object)BatchStatus.STARTING);
                    int count = jpaQuery.executeUpdate();
                    if (count <= 0) {
                        String msg = "The job instance " + jobInstanceId + " cannot be restarted because it is still in a non-final state.";
                        throw new JobRestartException(msg);
                    }
                    this.entityMgr.refresh((Object)instance);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$14", 14.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceOnRestart", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity updateJobInstanceStateOnConsumed(final long jobInstanceId) throws BatchIllegalJobStatusTransitionException, JobInstanceNotQueuedException {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceStateOnConsumed", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            String BASE_UPDATE = "UPDATE JobInstanceEntity x SET x.instanceState = com.ibm.jbatch.container.ws.InstanceState.JMS_CONSUMED";
            if (this.instanceVersion >= 2) {
                BASE_UPDATE = BASE_UPDATE.replace("JobInstanceEntity", "JobInstanceEntityV2").concat(",x.lastUpdatedTime = :lastUpdatedTime");
            }
            StringBuilder query = new StringBuilder().append(BASE_UPDATE);
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("x.instanceId = :instanceId");
            whereClause.append(" AND x.instanceState = com.ibm.jbatch.container.ws.InstanceState.JMS_QUEUED");
            query.append(" WHERE " + whereClause);
            final String FINAL_UPDATE = query.toString();
            JobInstanceEntity jobInstanceEntity2 = (JobInstanceEntity)new TranRequest<JobInstanceEntity>(em){
                static final long serialVersionUID = -5250703517507516364L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstanceEntity call() throws JobInstanceNotQueuedException {
                    int count;
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    Query jpaQuery = this.entityMgr.createQuery(FINAL_UPDATE);
                    jpaQuery.setParameter("instanceId", (Object)jobInstanceId);
                    if (JPAPersistenceManagerImpl.this.instanceVersion >= 2) {
                        jpaQuery.setParameter("lastUpdatedTime", (Object)new Date());
                    }
                    if ((count = jpaQuery.executeUpdate()) <= 0) {
                        logger.finer("No match on updateJobInstanceStateOnConsumed query for instance =  " + jobInstanceId);
                        throw new JobInstanceNotQueuedException();
                    }
                    logger.finer("Match on updateJobInstanceStateOnConsumed query for instance =  " + jobInstanceId);
                    this.entityMgr.refresh((Object)instance);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$15", 15.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceStateOnConsumed", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity updateJobInstanceStateOnQueued(final long jobInstanceId) {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceStateOnQueued", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            String BASE_UPDATE = "UPDATE JobInstanceEntity x SET x.instanceState = com.ibm.jbatch.container.ws.InstanceState.JMS_QUEUED";
            if (this.instanceVersion >= 2) {
                BASE_UPDATE = BASE_UPDATE.replace("JobInstanceEntity", "JobInstanceEntityV2").concat(",x.lastUpdatedTime = :lastUpdatedTime");
            }
            StringBuilder query = new StringBuilder().append(BASE_UPDATE);
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("x.instanceId = :instanceId");
            whereClause.append(" AND x.instanceState = com.ibm.jbatch.container.ws.InstanceState.SUBMITTED");
            query.append(" WHERE " + whereClause);
            final String FINAL_UPDATE = query.toString();
            JobInstanceEntity jobInstanceEntity2 = (JobInstanceEntity)new TranRequest<JobInstanceEntity>(em){
                static final long serialVersionUID = 998635574125202312L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobInstanceEntity call() {
                    int count;
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, InstanceState.JMS_QUEUED);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$16", (String)"892", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    Query jpaQuery = this.entityMgr.createQuery(FINAL_UPDATE);
                    jpaQuery.setParameter("instanceId", (Object)jobInstanceId);
                    if (JPAPersistenceManagerImpl.this.instanceVersion >= 2) {
                        jpaQuery.setParameter("lastUpdatedTime", (Object)new Date());
                    }
                    if ((count = jpaQuery.executeUpdate()) > 0) {
                        logger.finer("Match on updateJobInstanceStateOnQueued query for instance =  " + jobInstanceId);
                        this.entityMgr.refresh((Object)instance);
                    } else {
                        logger.finer("No match on updateJobInstanceStateOnQueued query for instance =  " + jobInstanceId);
                    }
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$16", 16.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceStateOnQueued", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceNullOutRestartOn(final long jobInstanceId) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceNullOutRestartOn", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = 1693864566960401582L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    instance.setRestartOn(null);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$17", 17.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceNullOutRestartOn", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithRestartOn(final long jobInstanceId, final String restartOn) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithRestartOn", new Object[]{jobInstanceId, restartOn});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = -7278675380216242973L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    instance.setRestartOn(restartOn);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$18", 18.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithRestartOn", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithJobNameAndJSL(final long jobInstanceId, final String jobName, final String jobXml) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithJobNameAndJSL", new Object[]{jobInstanceId, jobName, jobXml});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = -8255647764908289988L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    instance.setJobName(jobName);
                    instance.setJobXml(jobXml);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$19", 19.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithJobNameAndJSL", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithInstanceStateAndBatchStatus(final long jobInstanceId, final InstanceState state, final BatchStatus batchStatus, final Date lastUpdated) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", new Object[]{jobInstanceId, state, batchStatus, lastUpdated});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = 703808009145867075L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, state);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$20", (String)"994", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    instance.setInstanceState(state);
                    instance.setBatchStatus(batchStatus);
                    instance.setLastUpdatedTime(lastUpdated);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$20", 20.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStarted(final long jobExecutionId, final Date startedTime) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            JobExecution exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStarted", new Object[]{jobExecutionId, startedTime});
            }
            em = this.getPsu().createEntityManager();
            JobExecution jobExecution2 = exec = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = 4716856640969592771L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(exec, BatchStatus.STARTED);
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(exec.getJobInstance(), InstanceState.DISPATCHED);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$21", (String)"1024", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    exec.setBatchStatus(BatchStatus.STARTED);
                    exec.getJobInstance().setInstanceState(InstanceState.DISPATCHED);
                    exec.getJobInstance().setBatchStatus(BatchStatus.STARTED);
                    exec.getJobInstance().setLastUpdatedTime(startedTime);
                    exec.setStartTime(startedTime);
                    exec.setLastUpdatedTime(startedTime);
                    return exec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$21", 21.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStarted", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStatusChange(final long jobExecutionId, final BatchStatus newBatchStatus, final Date updateTime) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStatusChange", new Object[]{jobExecutionId, newBatchStatus, updateTime});
            }
            em = this.getPsu().createEntityManager();
            JobExecution jobExecution2 = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = 2396379063804501913L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(exec, newBatchStatus);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$22", (String)"1060", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    exec.setBatchStatus(newBatchStatus);
                    exec.getJobInstance().setBatchStatus(newBatchStatus);
                    exec.getJobInstance().setLastUpdatedTime(updateTime);
                    exec.setLastUpdatedTime(updateTime);
                    return exec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$22", 22.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStatusChange", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStopBeforeServerAssigned(final long jobExecutionId, final Date updateTime) throws NoSuchJobExecutionException, ExecutionAssignedToServerException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStopBeforeServerAssigned", new Object[]{jobExecutionId, updateTime});
            }
            em = this.getPsu().createEntityManager();
            JobExecution jobExecution2 = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = -2447590533169927817L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() throws ExecutionAssignedToServerException {
                    TypedQuery query = em.createNamedQuery("JobExecutionEntity.updateJobExecutionAndInstanceServerNotSet", JobExecutionEntity.class);
                    query.setParameter("batchStatus", (Object)BatchStatus.STOPPED);
                    query.setParameter("jobExecId", (Object)jobExecutionId);
                    query.setParameter("lastUpdatedTime", (Object)updateTime);
                    JobExecutionEntity execution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId, LockModeType.PESSIMISTIC_WRITE);
                    if (execution == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)execution.getInstanceId());
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + execution.getInstanceId());
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(execution, BatchStatus.STOPPED);
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, InstanceState.STOPPED);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$23", (String)"1102", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    if (instance.getInstanceState() == InstanceState.STOPPED) {
                        logger.finer("Returning since instance = " + instance.getInstanceId() + " is already STOPPED.");
                        return execution;
                    }
                    instance.setBatchStatus(BatchStatus.STOPPED);
                    instance.setInstanceState(InstanceState.STOPPED);
                    instance.setLastUpdatedTime(updateTime);
                    int count = query.executeUpdate();
                    if (count <= 0) {
                        String msg = "Job execution " + jobExecutionId + " is in an invalid state";
                        throw new ExecutionAssignedToServerException(msg);
                    }
                    this.entityMgr.refresh((Object)execution);
                    return execution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$23", 23.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStopBeforeServerAssigned", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnEnd(long jobExecutionId, BatchStatus finalBatchStatus, String finalExitStatus, Date endTime) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnEnd", new Object[]{jobExecutionId, finalBatchStatus, finalExitStatus, endTime});
        }
        JobExecution jobExecution = this.updateJobExecutionAndInstanceFinalStatus(this.getPsu(), jobExecutionId, finalBatchStatus, finalExitStatus, endTime);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnEnd", jobExecution);
        }
        return jobExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceFinalStatus(PersistenceServiceUnit psu, final long jobExecutionId, final BatchStatus finalBatchStatus, final String finalExitStatus, final Date endTime) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceFinalStatus", new Object[]{psu, jobExecutionId, finalBatchStatus, finalExitStatus, endTime});
            }
            em = psu.createEntityManager();
            JobExecution jobExecution2 = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = 6770833762770849388L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(exec, finalBatchStatus);
                        exec.setBatchStatus(finalBatchStatus);
                        exec.getJobInstance().setBatchStatus(finalBatchStatus);
                        exec.setExitStatus(finalExitStatus);
                        exec.getJobInstance().setExitStatus(finalExitStatus);
                        exec.getJobInstance().setLastUpdatedTime(endTime);
                        if (AbstractPersistenceManager.isFinalBatchStatus(finalBatchStatus)) {
                            InstanceState newInstanceState = InstanceState.valueOf(finalBatchStatus.toString());
                            JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(exec.getJobInstance(), newInstanceState);
                            exec.getJobInstance().setInstanceState(newInstanceState);
                        }
                        exec.setLastUpdatedTime(endTime);
                        exec.setEndTime(endTime);
                        return exec;
                    }
                    catch (BatchIllegalJobStatusTransitionException newInstanceState) {
                        void e;
                        FFDCFilter.processException((Throwable)newInstanceState, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$24", (String)"1180", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$24", 24.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceFinalStatus", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity createJobExecution(final long jobInstanceId, Properties jobParameters, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobExecution", new Object[]{jobInstanceId, jobParameters, createTime});
        }
        final JobExecutionEntity jobExecution = this.executionVersion >= 3 ? new JobExecutionEntityV3() : (this.executionVersion == 2 ? new JobExecutionEntityV2() : new JobExecutionEntity());
        jobExecution.setCreateTime(createTime);
        jobExecution.setLastUpdatedTime(createTime);
        jobExecution.setBatchStatus(BatchStatus.STARTING);
        jobExecution.setJobParameters(jobParameters);
        jobExecution.setRestUrl(this.batchLocationService.getBatchRestUrl());
        try (EntityManager em = this.getPsu().createEntityManager();){
            new TranRequest<Void>(em){
                static final long serialVersionUID = -3809302132497624699L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void call() {
                    JobInstanceEntity jobInstance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (jobInstance == null) {
                        throw new IllegalStateException("Didn't find JobInstanceEntity associated with value: " + jobInstanceId);
                    }
                    int currentNumExecutionsPreviously = jobInstance.getNumberOfExecutions();
                    jobExecution.setExecutionNumberForThisInstance(currentNumExecutionsPreviously);
                    jobInstance.setNumberOfExecutions(currentNumExecutionsPreviously + 1);
                    jobInstance.getJobExecutions().add(0, jobExecution);
                    jobExecution.setJobInstance(jobInstance);
                    this.entityMgr.persist((Object)jobExecution);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$25", 25.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            IdentifierValidator.validatePersistedJobExecution(jobExecution);
        }
        JobExecutionEntity jobExecutionEntity = jobExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity getJobExecution(final long jobExecutionId) throws NoSuchJobExecutionException {
        JobExecutionEntity jobExecutionEntity;
        EntityManager em;
        block4: {
            JobExecutionEntity exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecution", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity jobExecutionEntity2 = exec = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = -6484118241666626318L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() throws Exception {
                    JobExecutionEntity execution = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (execution == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    return execution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$26", 26.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecutionEntity = jobExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobExecutionEntity> getJobExecutionsFromJobInstanceId(final long jobInstanceId) throws NoSuchJobInstanceException {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsFromJobInstanceId", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<JobExecutionEntity>>(em){
                static final long serialVersionUID = -2176941687273409793L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<JobExecutionEntity> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsMostToLeastRecentByInstanceQuery", JobExecutionEntity.class);
                    query.setParameter("instanceId", (Object)jobInstanceId);
                    List result = query.getResultList();
                    if (result == null || result.size() == 0) {
                        JPAPersistenceManagerImpl.this.getJobInstance(jobInstanceId);
                        if (result == null) {
                            return new ArrayList<JobExecutionEntity>();
                        }
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$27", 27.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsFromJobInstanceId", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected List<Long> getJobInstancesRunning(final String jobName) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstancesRunning", new Object[]{jobName});
            }
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<Long>>(em){
                static final long serialVersionUID = 9023424404628046809L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<Long> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesByNameAndStatus", Long.class);
                    query.setParameter("name", (Object)jobName);
                    query.setParameter("status", AbstractPersistenceManager.RUNNING_STATUSES);
                    List result = query.getResultList();
                    if (result == null) {
                        return new ArrayList<Long>();
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$28", 28.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstancesRunning", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getJobExecutionsRunning(String jobName) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunning", new Object[]{jobName});
            }
            final List<Long> runningInstances = this.getJobInstancesRunning(jobName);
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<Long>>(em){
                static final long serialVersionUID = 8927742627429888685L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<Long> call() throws Exception {
                    List result = null;
                    if (runningInstances.size() > 0) {
                        TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsByJobInstanceIdAndStatuses", Long.class);
                        query.setParameter("instanceList", (Object)runningInstances);
                        query.setParameter("status", AbstractPersistenceManager.RUNNING_STATUSES);
                        result = query.getResultList();
                    }
                    if (result == null) {
                        return new ArrayList<Long>();
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$29", 29.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunning", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobExecutionEntity> getJobExecutionsRunningLocalToServer(PersistenceServiceUnit psu) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunningLocalToServer", new Object[]{psu});
            }
            em = psu.createEntityManager();
            List list2 = exec = (List)new TranRequest<List<JobExecutionEntity>>(em){
                static final long serialVersionUID = 8414754270402112795L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<JobExecutionEntity> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsByServerIdAndStatusesQuery", JobExecutionEntity.class);
                    query.setParameter("serverid", (Object)JPAPersistenceManagerImpl.this.batchLocationService.getServerId());
                    query.setParameter("status", AbstractPersistenceManager.RUNNING_STATUSES);
                    List result = query.getResultList();
                    if (result == null) {
                        return new ArrayList<JobExecutionEntity>();
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$30", 30.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunningLocalToServer", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Integer> getRemotablePartitionsRecoveredForStepExecution(final long topLevelStepExecutionId) {
        List list;
        EntityManager em;
        block6: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsRecoveredForStepExecution", new Object[]{topLevelStepExecutionId});
            }
            em = this.psu.createEntityManager();
            if (this.partitionVersion < 2) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    arrayList = arrayList;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsRecoveredForStepExecution", arrayList);
                }
                return arrayList;
            }
            List list2 = exec = (List)new TranRequest<List<Integer>>(em){
                static final long serialVersionUID = 776117483789526305L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<Integer> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("RemotablePartitionEntity.getRecoveredRemotablePartitions", Integer.class);
                    query.setParameter("topLevelStepExecutionId", (Object)topLevelStepExecutionId);
                    List result = query.getResultList();
                    if (result == null) {
                        return new ArrayList<Integer>();
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$31", 31.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsRecoveredForStepExecution", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<RemotablePartitionEntity> getRemotablePartitionsRunningLocalToServer(PersistenceServiceUnit psu) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsRunningLocalToServer", new Object[]{psu});
            }
            em = psu.createEntityManager();
            List list2 = exec = (List)new TranRequest<List<RemotablePartitionEntity>>(em){
                static final long serialVersionUID = 7211403743865239743L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<RemotablePartitionEntity> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("RemotablePartitionEntity.getPartitionStepExecutionByServerIdAndStatusesQuery", RemotablePartitionEntity.class);
                    query.setParameter("serverid", (Object)JPAPersistenceManagerImpl.this.batchLocationService.getServerId());
                    query.setParameter("status", AbstractPersistenceManager.RUNNING_STATUSES);
                    List result = query.getResultList();
                    if (result == null) {
                        return new ArrayList<RemotablePartitionEntity>();
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$32", 32.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsRunningLocalToServer", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity getJobExecutionFromJobExecNum(final long jobInstanceId, final int jobExecNum) throws NoSuchJobInstanceException, IllegalArgumentException {
        JobExecutionEntity jobExecutionEntity;
        EntityManager em;
        block4: {
            JobExecutionEntity exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionFromJobExecNum", new Object[]{jobInstanceId, jobExecNum});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity jobExecutionEntity2 = exec = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = 1401159679515312549L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() {
                    TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsByJobInstanceIdAndJobExecNumberQuery", JobExecutionEntity.class);
                    query.setParameter("instanceId", (Object)jobInstanceId);
                    query.setParameter("jobExecNum", (Object)jobExecNum);
                    List jobExec = query.getResultList();
                    if (jobExec.size() > 1) {
                        throw new IllegalStateException("Found more than one result for jobInstanceId: " + jobInstanceId + ", jobExecNum: " + jobExecNum);
                    }
                    if (jobExec == null || jobExec.size() == 0) {
                        JPAPersistenceManagerImpl.this.getJobInstance(jobInstanceId);
                        throw new IllegalArgumentException("Didn't find any job execution entries at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum);
                    }
                    return (JobExecutionEntity)jobExec.get(0);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$33", 33.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecutionEntity = jobExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionFromJobExecNum", jobExecutionEntity);
        }
        return jobExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity updateJobExecutionLogDir(final long jobExecutionId, final String logDirPath) {
        JobExecutionEntity jobExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionLogDir", new Object[]{jobExecutionId, logDirPath});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity jobExecutionEntity2 = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = 1415640977828028472L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    exec.setLogpath(logDirPath);
                    return exec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$34", 34.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecutionEntity = jobExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionLogDir", jobExecutionEntity);
        }
        return jobExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity updateJobExecutionServerIdAndRestUrlForStartingJob(final long jobExecutionId) throws NoSuchJobExecutionException, JobStoppedException {
        JobExecutionEntity jobExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionServerIdAndRestUrlForStartingJob", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity jobExecutionEntity2 = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = -4301759897515798637L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() throws JobStoppedException {
                    TypedQuery query = em.createNamedQuery("JobExecutionEntity.updateJobExecutionServerIdAndRestUrlForStartingJob", JobExecutionEntity.class);
                    query.setParameter("serverId", (Object)JPAPersistenceManagerImpl.this.batchLocationService.getServerId());
                    query.setParameter("restUrl", (Object)JPAPersistenceManagerImpl.this.batchLocationService.getBatchRestUrl());
                    query.setParameter("jobExecId", (Object)jobExecutionId);
                    JobExecutionEntity execution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId, LockModeType.PESSIMISTIC_WRITE);
                    if (execution == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    int count = query.executeUpdate();
                    if (count <= 0) {
                        String msg = "No job execution found for id = " + jobExecutionId + " and status = STARTING";
                        throw new JobStoppedException(msg);
                    }
                    this.entityMgr.refresh((Object)execution);
                    return execution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$35", 35.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecutionEntity = jobExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionServerIdAndRestUrlForStartingJob", jobExecutionEntity);
        }
        return jobExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionAndNewThreadInstance(final long jobExecutionId, final StepThreadInstanceKey instanceKey, final boolean isPartitioned) {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionAndNewThreadInstance", new Object[]{jobExecutionId, instanceKey, isPartitioned});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity stepExecution = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = -8271701643333663402L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    JobInstanceEntity jobInstance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)instanceKey.getJobInstance());
                    if (jobInstance == null) {
                        throw new IllegalStateException("Didn't find JobInstanceEntity associated with step thread key value: " + instanceKey.getJobInstance());
                    }
                    JobExecutionEntity jobExecution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (jobExecution == null) {
                        throw new IllegalStateException("Didn't find JobExecutionEntity associated with value: " + jobExecutionId);
                    }
                    TopLevelStepInstanceEntity stepInstance = new TopLevelStepInstanceEntity(jobInstance, instanceKey.getStepName(), isPartitioned);
                    TopLevelStepExecutionEntity stepExecution = new TopLevelStepExecutionEntity(jobExecution, instanceKey.getStepName(), isPartitioned);
                    stepInstance.setLatestStepThreadExecution(stepExecution);
                    this.entityMgr.persist((Object)stepExecution);
                    this.entityMgr.persist((Object)stepInstance);
                    return stepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$36", 36.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            IdentifierValidator.validatePersistedStepExecution(stepExecution);
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = stepExecution;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionAndNewThreadInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity createRemotablePartition(final RemotablePartitionKey remotablePartitionKey) {
        RemotablePartitionEntity remotablePartitionEntity;
        EntityManager em;
        block6: {
            RemotablePartitionEntity remotablePartition;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createRemotablePartition", new Object[]{remotablePartitionKey});
            }
            if (this.partitionVersion < 2) {
                RemotablePartitionEntity remotablePartitionEntity2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    remotablePartitionEntity2 = remotablePartitionEntity2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createRemotablePartition", remotablePartitionEntity2);
                }
                return remotablePartitionEntity2;
            }
            em = this.getPsu().createEntityManager();
            RemotablePartitionEntity remotablePartitionEntity3 = remotablePartition = (RemotablePartitionEntity)new TranRequest<RemotablePartitionEntity>(em){
                static final long serialVersionUID = -8684357289320952238L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RemotablePartitionEntity call() {
                    JobExecutionEntity jobExecution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)remotablePartitionKey.getJobExec());
                    if (jobExecution == null) {
                        throw new IllegalArgumentException("Didn't find JobExecutionEntity associated with value: " + remotablePartitionKey.getJobExec());
                    }
                    RemotablePartitionEntity remotablePartition = new RemotablePartitionEntity(jobExecution, remotablePartitionKey);
                    remotablePartition.setInternalStatus(WSRemotablePartitionState.QUEUED);
                    remotablePartition.setLastUpdated(new Date());
                    this.entityMgr.persist((Object)remotablePartition);
                    return remotablePartition;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$37", 37.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            remotablePartitionEntity = remotablePartitionEntity3;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createRemotablePartition", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity createPartitionStepExecutionAndNewThreadInstance(final long jobExecutionId, final StepThreadInstanceKey instanceKey, final boolean isRemoteDispatch) {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionAndNewThreadInstance", new Object[]{jobExecutionId, instanceKey, isRemoteDispatch});
            }
            em = this.getPsu().createEntityManager();
            StepThreadExecutionEntity stepExecution = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = 7065407675822461715L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadExecutionEntity call() {
                    RemotablePartitionKey remotablePartitionKey;
                    JobInstanceEntity jobInstance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)instanceKey.getJobInstance());
                    if (jobInstance == null) {
                        throw new IllegalStateException("Didn't find JobInstanceEntity associated with step thread key value: " + instanceKey.getJobInstance());
                    }
                    JobExecutionEntity jobExecution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (jobExecution == null) {
                        throw new IllegalStateException("Didn't find JobExecutionEntity associated with value: " + jobExecutionId);
                    }
                    TypedQuery query = this.entityMgr.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionByJobExecAndStepNameQuery", TopLevelStepExecutionEntity.class);
                    query.setParameter("jobExecId", (Object)jobExecutionId);
                    query.setParameter("stepName", (Object)instanceKey.getStepName());
                    TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)query.getSingleResult();
                    StepThreadInstanceEntity stepInstance = new StepThreadInstanceEntity(jobInstance, instanceKey.getStepName(), instanceKey.getPartitionNumber());
                    StepThreadExecutionEntity stepExecution = JPAPersistenceManagerImpl.this.partitionVersion >= 2 ? new StepThreadExecutionEntityV2(jobExecution, instanceKey.getStepName(), instanceKey.getPartitionNumber()) : new StepThreadExecutionEntity(jobExecution, instanceKey.getStepName(), instanceKey.getPartitionNumber());
                    stepInstance.setLatestStepThreadExecution(stepExecution);
                    stepExecution.setTopLevelStepExecution(topLevelStepExecution);
                    RemotablePartitionEntity remotablePartition = null;
                    if (isRemoteDispatch && JPAPersistenceManagerImpl.this.partitionVersion >= 2 && (remotablePartition = (RemotablePartitionEntity)this.entityMgr.find(RemotablePartitionEntity.class, (Object)(remotablePartitionKey = new RemotablePartitionKey(jobExecution.getExecutionId(), instanceKey.getStepName(), instanceKey.getPartitionNumber())))) != null) {
                        remotablePartition.setStepExecution(stepExecution);
                        remotablePartition.setRestUrl(JPAPersistenceManagerImpl.this.batchLocationService.getBatchRestUrl());
                        remotablePartition.setServerId(JPAPersistenceManagerImpl.this.batchLocationService.getServerId());
                        remotablePartition.setInternalStatus(WSRemotablePartitionState.CONSUMED);
                        remotablePartition.setLastUpdated(new Date());
                    }
                    this.entityMgr.persist((Object)stepInstance);
                    this.entityMgr.persist((Object)stepExecution);
                    if (isRemoteDispatch && remotablePartition != null) {
                        this.entityMgr.persist(remotablePartition);
                    }
                    return stepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$38", 38.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            IdentifierValidator.validatePersistedStepExecution(stepExecution);
            StepThreadExecutionEntity stepThreadExecutionEntity2 = stepExecution;
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionAndNewThreadInstance", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionOnRestartFromPreviousStepInstance(final long jobExecutionId, final TopLevelStepInstanceEntity stepInstance) throws NoSuchJobExecutionException {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartFromPreviousStepInstance", new Object[]{jobExecutionId, stepInstance});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity stepExecution = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = -6507774665775780894L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    JobExecutionEntity newJobExecution = JPAPersistenceManagerImpl.this.getJobExecution(jobExecutionId);
                    StepThreadExecutionEntity lastStepExecution = stepInstance.getLatestStepThreadExecution();
                    TopLevelStepExecutionEntity newStepExecution = new TopLevelStepExecutionEntity(newJobExecution, stepInstance.getStepName(), stepInstance.isPartitionedStep());
                    newStepExecution.setPersistentUserDataBytes(lastStepExecution.getPersistentUserDataBytes());
                    stepInstance.incrementStartCount();
                    stepInstance.setLatestStepThreadExecution(newStepExecution);
                    this.entityMgr.persist((Object)newStepExecution);
                    this.entityMgr.merge((Object)stepInstance);
                    return newStepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$39", 39.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            IdentifierValidator.validatePersistedStepExecution(stepExecution);
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = stepExecution;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartFromPreviousStepInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity createPartitionStepExecutionOnRestartFromPreviousStepInstance(final long jobExecutionId, final StepThreadInstanceEntity stepThreadInstance, final boolean isRemoteDispatch) throws NoSuchJobExecutionException {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionOnRestartFromPreviousStepInstance", new Object[]{jobExecutionId, stepThreadInstance, isRemoteDispatch});
            }
            em = this.getPsu().createEntityManager();
            StepThreadExecutionEntity stepExecution = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = 1290897711271791016L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadExecutionEntity call() {
                    RemotablePartitionKey remotablePartitionKey;
                    JobExecutionEntity newJobExecution = JPAPersistenceManagerImpl.this.getJobExecution(jobExecutionId);
                    StepThreadExecutionEntity lastStepExecution = stepThreadInstance.getLatestStepThreadExecution();
                    TypedQuery query = this.entityMgr.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionByJobExecAndStepNameQuery", TopLevelStepExecutionEntity.class);
                    query.setParameter("jobExecId", (Object)jobExecutionId);
                    query.setParameter("stepName", (Object)stepThreadInstance.getStepName());
                    TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)query.getSingleResult();
                    StepThreadExecutionEntity newStepExecution = JPAPersistenceManagerImpl.this.partitionVersion >= 2 ? new StepThreadExecutionEntityV2(newJobExecution, stepThreadInstance.getStepName(), stepThreadInstance.getPartitionNumber()) : new StepThreadExecutionEntity(newJobExecution, stepThreadInstance.getStepName(), stepThreadInstance.getPartitionNumber());
                    newStepExecution.setPersistentUserDataBytes(lastStepExecution.getPersistentUserDataBytes());
                    stepThreadInstance.setLatestStepThreadExecution(newStepExecution);
                    newStepExecution.setTopLevelStepExecution(topLevelStepExecution);
                    RemotablePartitionEntity remotablePartition = null;
                    if (isRemoteDispatch && (remotablePartition = (RemotablePartitionEntity)this.entityMgr.find(RemotablePartitionEntity.class, (Object)(remotablePartitionKey = new RemotablePartitionKey(newJobExecution.getExecutionId(), stepThreadInstance.getStepName(), stepThreadInstance.getPartitionNumber())))) != null) {
                        remotablePartition.setStepExecution(newStepExecution);
                        remotablePartition.setRestUrl(JPAPersistenceManagerImpl.this.batchLocationService.getBatchRestUrl());
                        remotablePartition.setServerId(JPAPersistenceManagerImpl.this.batchLocationService.getServerId());
                        remotablePartition.setInternalStatus(WSRemotablePartitionState.CONSUMED);
                        remotablePartition.setLastUpdated(new Date());
                    }
                    this.entityMgr.persist((Object)newStepExecution);
                    this.entityMgr.merge((Object)stepThreadInstance);
                    if (isRemoteDispatch && remotablePartition != null) {
                        this.entityMgr.persist(remotablePartition);
                    }
                    return newStepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$40", 40.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            IdentifierValidator.validatePersistedStepExecution(stepExecution);
            StepThreadExecutionEntity stepThreadExecutionEntity2 = stepExecution;
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionOnRestartFromPreviousStepInstance", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionOnRestartAndCleanStepInstance(final long jobExecutionId, final TopLevelStepInstanceEntity stepInstance) throws NoSuchJobExecutionException {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartAndCleanStepInstance", new Object[]{jobExecutionId, stepInstance});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity stepExecution = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = -1626437710973708535L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    JobExecutionEntity newJobExecution = JPAPersistenceManagerImpl.this.getJobExecution(jobExecutionId);
                    TopLevelStepExecutionEntity newStepExecution = new TopLevelStepExecutionEntity(newJobExecution, stepInstance.getStepName(), stepInstance.isPartitionedStep());
                    stepInstance.incrementStartCount();
                    stepInstance.deleteCheckpointData();
                    stepInstance.setLatestStepThreadExecution(newStepExecution);
                    this.entityMgr.persist((Object)newStepExecution);
                    this.entityMgr.merge((Object)stepInstance);
                    return newStepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$41", 41.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            IdentifierValidator.validatePersistedStepExecution(stepExecution);
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = stepExecution;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartAndCleanStepInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadInstanceEntity getStepThreadInstance(final StepThreadInstanceKey stepInstanceKey) {
        StepThreadInstanceEntity stepThreadInstanceEntity;
        EntityManager em;
        block4: {
            StepThreadInstanceEntity exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstance", new Object[]{stepInstanceKey});
            }
            em = this.getPsu().createEntityManager();
            StepThreadInstanceEntity stepThreadInstanceEntity2 = exec = (StepThreadInstanceEntity)new TranRequest<StepThreadInstanceEntity>(em){
                static final long serialVersionUID = 5098779733164232167L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadInstanceEntity call() throws Exception {
                    return (StepThreadInstanceEntity)em.find(StepThreadInstanceEntity.class, (Object)stepInstanceKey);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$42", 42.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadInstanceEntity = stepThreadInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadInstanceEntity = stepThreadInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstance", stepThreadInstanceEntity);
        }
        return stepThreadInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Integer> getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions(final StepThreadInstanceKey topLevelKey) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions", new Object[]{topLevelKey});
            }
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<Integer>>(em){
                static final long serialVersionUID = 2861802182748811328L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<Integer> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("TopLevelStepInstanceEntity.getRelatedPartitionLevelCompletedPartitionNumbersQuery", Integer.class);
                    query.setParameter("instanceId", (Object)topLevelKey.getJobInstance());
                    query.setParameter("stepName", (Object)topLevelKey.getStepName());
                    return query.getResultList();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$43", 43.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadInstanceEntity updateStepThreadInstanceWithCheckpointData(final StepThreadInstanceEntity stepThreadInstance) {
        StepThreadInstanceEntity stepThreadInstanceEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithCheckpointData", new Object[]{stepThreadInstance});
            }
            em = this.getPsu().createEntityManager();
            StepThreadInstanceEntity stepThreadInstanceEntity2 = (StepThreadInstanceEntity)new TranRequest<StepThreadInstanceEntity>(em){
                static final long serialVersionUID = -6056749254128769758L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadInstanceEntity call() {
                    this.entityMgr.merge((Object)stepThreadInstance);
                    return stepThreadInstance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$44", 44.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadInstanceEntity = stepThreadInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadInstanceEntity = stepThreadInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithCheckpointData", stepThreadInstanceEntity);
        }
        return stepThreadInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepInstanceEntity updateStepThreadInstanceWithPartitionPlanSize(final StepThreadInstanceKey stepInstanceKey, final int numCurrentPartitions) {
        TopLevelStepInstanceEntity topLevelStepInstanceEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithPartitionPlanSize", new Object[]{stepInstanceKey, numCurrentPartitions});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepInstanceEntity topLevelStepInstanceEntity2 = (TopLevelStepInstanceEntity)new TranRequest<TopLevelStepInstanceEntity>(em){
                static final long serialVersionUID = 4506430977034482757L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepInstanceEntity call() {
                    TopLevelStepInstanceEntity stepInstance = (TopLevelStepInstanceEntity)em.find(TopLevelStepInstanceEntity.class, (Object)stepInstanceKey);
                    if (stepInstance == null) {
                        throw new IllegalStateException("No step thread instance found for key = " + stepInstanceKey);
                    }
                    stepInstance.setPartitionPlanSize(numCurrentPartitions);
                    return stepInstance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$45", 45.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            topLevelStepInstanceEntity = topLevelStepInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepInstanceEntity = topLevelStepInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithPartitionPlanSize", topLevelStepInstanceEntity);
        }
        return topLevelStepInstanceEntity;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deleteStepThreadInstanceOfRelatedPartitions(final TopLevelStepInstanceKey instanceKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deleteStepThreadInstanceOfRelatedPartitions", new Object[]{instanceKey});
        }
        try (EntityManager em = this.getPsu().createEntityManager();){
            new TranRequest<Void>(em){
                static final long serialVersionUID = 8060544187887470706L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void call() {
                    TypedQuery query = this.entityMgr.createNamedQuery("TopLevelStepInstanceEntity.getRelatedPartitionLevelStepThreadInstancesQuery", StepThreadInstanceEntity.class);
                    query.setParameter("instanceId", (Object)instanceKey.getJobInstance());
                    query.setParameter("stepName", (Object)instanceKey.getStepName());
                    List relatedPartitionInstances = query.getResultList();
                    for (StepThreadInstanceEntity partitionInstance : relatedPartitionInstances) {
                        this.entityMgr.remove((Object)partitionInstance);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$46", 46.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deleteStepThreadInstanceOfRelatedPartitions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity getStepThreadExecution(final long stepExecutionId) {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            StepThreadExecutionEntity exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecution", new Object[]{stepExecutionId});
            }
            em = this.getPsu().createEntityManager();
            StepThreadExecutionEntity stepThreadExecutionEntity2 = exec = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = 7467338742086912706L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadExecutionEntity call() throws Exception {
                    return (StepThreadExecutionEntity)em.find(StepThreadExecutionEntity.class, (Object)stepExecutionId);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$47", 47.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecution", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<StepExecution> getStepExecutionsTopLevelFromJobExecutionId(final long jobExecutionId) throws NoSuchJobExecutionException {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionsTopLevelFromJobExecutionId", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            List list2 = exec = (List)new TranRequest<List<StepExecution>>(em){
                static final long serialVersionUID = 9091194438691781143L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<StepExecution> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionsByJobExecSortByStartTimeAscQuery", StepExecution.class);
                    query.setParameter("jobExecId", (Object)jobExecutionId);
                    ArrayList<StepExecution> result = query.getResultList();
                    if (result == null) {
                        result = new ArrayList<StepExecution>();
                    }
                    if (result.isEmpty()) {
                        JPAPersistenceManagerImpl.this.getJobExecution(jobExecutionId);
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$48", 48.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionsTopLevelFromJobExecutionId", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionNumberAndStepName(final long jobInstanceId, final int jobExecNum, final String stepName) throws NoSuchJobInstanceException, IllegalArgumentException {
        WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl;
        EntityManager em;
        block4: {
            WSStepThreadExecutionAggregateImpl exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", new Object[]{jobInstanceId, jobExecNum, stepName});
            }
            final WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
            em = this.getPsu().createEntityManager();
            WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl2 = exec = (WSStepThreadExecutionAggregateImpl)new TranRequest<WSStepThreadExecutionAggregateImpl>(em){
                static final long serialVersionUID = -2056283350414407529L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public WSStepThreadExecutionAggregateImpl call() throws Exception {
                    if (JPAPersistenceManagerImpl.this.partitionVersion >= 2) {
                        Query query = em.createQuery("SELECT s,r FROM StepThreadExecutionEntity s LEFT JOIN RemotablePartitionEntity r ON r.stepExecutionEntity = s WHERE (s.jobExec.jobInstance.instanceId = :jobInstanceId AND s.jobExec.executionNumberForThisInstance = :jobExecNum AND s.stepName = :stepName) ORDER BY s.partitionNumber ASC ");
                        query.setParameter("jobInstanceId", (Object)jobInstanceId);
                        query.setParameter("jobExecNum", (Object)jobExecNum);
                        query.setParameter("stepName", (Object)stepName);
                        List stepExecs = query.getResultList();
                        if (stepExecs == null || stepExecs.size() == 0) {
                            JPAPersistenceManagerImpl.this.getJobInstance(jobInstanceId);
                            throw new IllegalArgumentException("Didn't find any step thread exec entries at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum + ", and stepName: " + stepName);
                        }
                        try {
                            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)((Object[])stepExecs.get(0))[0];
                            retVal.setTopLevelStepExecution(topLevelStepExecution);
                        }
                        catch (ClassCastException topLevelStepExecution) {
                            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$49", (String)"2121", (Object)this, (Object[])new Object[0]);
                            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum + ", and stepName: " + stepName);
                        }
                        ArrayList<WSPartitionStepAggregate> partitionSteps = new ArrayList<WSPartitionStepAggregate>(stepExecs.size());
                        ArrayList<WSPartitionStepThreadExecution> partitionLevelStepExecutions = new ArrayList<WSPartitionStepThreadExecution>(stepExecs.size());
                        for (int i = 1; i < stepExecs.size(); ++i) {
                            WSPartitionStepAggregateImpl partitionStepAggregate = new WSPartitionStepAggregateImpl((Object[])stepExecs.get(i));
                            partitionSteps.add(partitionStepAggregate);
                            partitionLevelStepExecutions.add(partitionStepAggregate.getPartitionStepThread());
                        }
                        retVal.setPartitionAggregate(partitionSteps);
                        retVal.setPartitionLevelStepExecutions(partitionLevelStepExecutions);
                    } else {
                        Query query = em.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionByJobInstanceJobExecNumAndStepNameQuery");
                        query.setParameter("jobInstanceId", (Object)jobInstanceId);
                        query.setParameter("jobExecNum", (Object)jobExecNum);
                        query.setParameter("stepName", (Object)stepName);
                        List stepExecs = query.getResultList();
                        if (stepExecs == null || stepExecs.size() == 0) {
                            JPAPersistenceManagerImpl.this.getJobInstance(jobInstanceId);
                            throw new IllegalArgumentException("Didn't find any step thread exec entries at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum + ", and stepName: " + stepName);
                        }
                        try {
                            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)stepExecs.get(0);
                            retVal.setTopLevelStepExecution(topLevelStepExecution);
                        }
                        catch (ClassCastException topLevelStepExecution) {
                            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$49", (String)"2160", (Object)this, (Object[])new Object[0]);
                            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum + ", and stepName: " + stepName);
                        }
                        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(stepExecs.subList(1, stepExecs.size())));
                    }
                    return retVal;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$49", 49.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", wSStepThreadExecutionAggregateImpl);
        }
        return wSStepThreadExecutionAggregateImpl;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity updateStepExecution(final RuntimeStepExecution runtimeStepExecution) {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecution", new Object[]{runtimeStepExecution});
            }
            em = this.getPsu().createEntityManager();
            TranSynchronization tranSynch = new TranSynchronization(runtimeStepExecution);
            try {
                Transaction tran = this.tranMgr.getTransaction();
                if (tran != null) {
                    UOWCurrent uowCurrent = (UOWCurrent)this.tranMgr;
                    this.tranMgr.registerSynchronization(uowCurrent.getUOWCoord(), (Synchronization)tranSynch, 1);
                }
            }
            catch (Throwable tran) {
                void t;
                FFDCFilter.processException((Throwable)tran, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"2189", (Object)this, (Object[])new Object[]{runtimeStepExecution});
                throw new IllegalStateException("TranSync messed up! Sync = " + tranSynch + " Exception: " + t.toString());
            }
            StepThreadExecutionEntity stepThreadExecutionEntity2 = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = -3376425629588366520L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadExecutionEntity call() {
                    StepThreadExecutionEntity stepExec = (StepThreadExecutionEntity)this.entityMgr.find(StepThreadExecutionEntity.class, (Object)runtimeStepExecution.getInternalStepThreadExecutionId());
                    if (stepExec == null) {
                        throw new IllegalStateException("StepThreadExecEntity with id =" + runtimeStepExecution.getInternalStepThreadExecutionId() + " should be persisted at this point, but didn't find.");
                    }
                    JPAPersistenceManagerImpl.this.updateStepExecutionStatusTimeStampsUserDataAndMetrics(stepExec, runtimeStepExecution);
                    return stepExec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$50", 50.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecution", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity updateRemotablePartitionOnRecovery(PersistenceServiceUnit psu, final RemotablePartitionEntity partition) {
        RemotablePartitionEntity remotablePartitionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionOnRecovery", new Object[]{psu, partition});
            }
            em = psu.createEntityManager();
            RemotablePartitionEntity remotablePartitionEntity2 = (RemotablePartitionEntity)new TranRequest<RemotablePartitionEntity>(em){
                static final long serialVersionUID = -5149627997164890202L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RemotablePartitionEntity call() {
                    RemotablePartitionKey key = new RemotablePartitionKey(partition);
                    RemotablePartitionEntity remotablePartition = (RemotablePartitionEntity)this.entityMgr.find(RemotablePartitionEntity.class, (Object)key);
                    remotablePartition.setInternalStatus(WSRemotablePartitionState.RECOVERED);
                    remotablePartition.setLastUpdated(new Date());
                    return remotablePartition;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$51", 51.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            remotablePartitionEntity = remotablePartitionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionOnRecovery", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity updateStepExecutionOnRecovery(PersistenceServiceUnit psu, final long stepExecutionId, final BatchStatus newStepBatchStatus, final String newStepExitStatus, final Date endTime) throws IllegalArgumentException {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionOnRecovery", new Object[]{psu, stepExecutionId, newStepBatchStatus, newStepExitStatus, endTime});
            }
            em = psu.createEntityManager();
            StepThreadExecutionEntity stepThreadExecutionEntity2 = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = 3868174547712076180L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public StepThreadExecutionEntity call() {
                    StepThreadExecutionEntity stepExec = (StepThreadExecutionEntity)this.entityMgr.find(StepThreadExecutionEntity.class, (Object)stepExecutionId);
                    if (stepExec == null) {
                        throw new IllegalArgumentException("StepThreadExecEntity with id =" + stepExecutionId + " should be persisted at this point, but didn't find it.");
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyThreadStatusTransitionIsValid(stepExec, newStepBatchStatus);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$52", (String)"2265", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException((Throwable)e);
                    }
                    stepExec.setBatchStatus(newStepBatchStatus);
                    stepExec.setExitStatus(newStepExitStatus);
                    stepExec.setEndTime(endTime);
                    return stepExec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$52", 52.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionOnRecovery", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity updateStepExecutionWithPartitionAggregate(final RuntimeStepExecution runtimeStepExecution) {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionWithPartitionAggregate", new Object[]{runtimeStepExecution});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = 613104312421764904L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    TopLevelStepExecutionEntity stepExec = (TopLevelStepExecutionEntity)this.entityMgr.find(TopLevelStepExecutionEntity.class, (Object)runtimeStepExecution.getInternalStepThreadExecutionId());
                    if (stepExec == null) {
                        throw new IllegalArgumentException("StepThreadExecEntity with id =" + runtimeStepExecution.getInternalStepThreadExecutionId() + " should be persisted at this point, but didn't find.");
                    }
                    JPAPersistenceManagerImpl.this.updateStepExecutionStatusTimeStampsUserDataAndMetrics(stepExec, runtimeStepExecution);
                    for (StepThreadExecutionEntity stepThreadExec : stepExec.getTopLevelAndPartitionStepExecutions()) {
                        if (stepThreadExec instanceof TopLevelStepExecutionEntity) continue;
                        stepExec.addMetrics(stepThreadExec);
                    }
                    return stepExec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$53", 53.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionWithPartitionAggregate", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionId(final long jobExecutionId, final String stepName) throws NoSuchJobExecutionException {
        WSStepThreadExecutionAggregate wSStepThreadExecutionAggregate;
        EntityManager em;
        block4: {
            WSStepThreadExecutionAggregate exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionId", new Object[]{jobExecutionId, stepName});
            }
            final WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
            em = this.getPsu().createEntityManager();
            WSStepThreadExecutionAggregate wSStepThreadExecutionAggregate2 = exec = (WSStepThreadExecutionAggregate)new TranRequest<WSStepThreadExecutionAggregate>(em){
                static final long serialVersionUID = 4254842961920223128L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public WSStepThreadExecutionAggregate call() throws Exception {
                    if (JPAPersistenceManagerImpl.this.partitionVersion >= 2) {
                        Query query = em.createQuery("SELECT s,r FROM StepThreadExecutionEntity s LEFT JOIN RemotablePartitionEntity r ON r.stepExecutionEntity = s WHERE s.jobExec.jobExecId = :jobExecId AND s.stepName = :stepName  ORDER BY s.partitionNumber ASC");
                        query.setParameter("jobExecId", (Object)jobExecutionId);
                        query.setParameter("stepName", (Object)stepName);
                        List stepExecs = query.getResultList();
                        if (stepExecs == null || stepExecs.size() == 0) {
                            throw new IllegalArgumentException("Didn't find any step thread exec entries at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
                        }
                        try {
                            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)((Object[])stepExecs.get(0))[0];
                            retVal.setTopLevelStepExecution(topLevelStepExecution);
                        }
                        catch (ClassCastException topLevelStepExecution) {
                            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$54", (String)"2335", (Object)this, (Object[])new Object[0]);
                            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
                        }
                        ArrayList<WSPartitionStepAggregate> partitionSteps = new ArrayList<WSPartitionStepAggregate>();
                        ArrayList<WSPartitionStepThreadExecution> partitionLevelStepExecutions = new ArrayList<WSPartitionStepThreadExecution>();
                        for (int i = 1; i < stepExecs.size(); ++i) {
                            WSPartitionStepAggregateImpl partitionStepAggregate = new WSPartitionStepAggregateImpl((Object[])stepExecs.get(i));
                            partitionSteps.add(partitionStepAggregate);
                            partitionLevelStepExecutions.add(partitionStepAggregate.getPartitionStepThread());
                        }
                        retVal.setPartitionAggregate(partitionSteps);
                        retVal.setPartitionLevelStepExecutions(partitionLevelStepExecutions);
                    } else {
                        Query query = em.createNamedQuery("TopLevelStepExecutionEntity.getAllRelatedStepThreadExecsByJobExecAndStepNameSortByPartNumAscQuery");
                        query.setParameter("jobExecId", (Object)jobExecutionId);
                        query.setParameter("stepName", (Object)stepName);
                        List stepExecs = query.getResultList();
                        if (stepExecs == null || stepExecs.size() == 0) {
                            throw new IllegalArgumentException("Didn't find any step thread exec entries at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
                        }
                        try {
                            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)stepExecs.get(0);
                            retVal.setTopLevelStepExecution(topLevelStepExecution);
                        }
                        catch (ClassCastException topLevelStepExecution) {
                            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$54", (String)"2367", (Object)this, (Object[])new Object[0]);
                            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
                        }
                        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(stepExecs.subList(1, stepExecs.size())));
                    }
                    return retVal;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$54", 54.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            wSStepThreadExecutionAggregate = wSStepThreadExecutionAggregate2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            wSStepThreadExecutionAggregate = wSStepThreadExecutionAggregate;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionId", wSStepThreadExecutionAggregate);
        }
        return wSStepThreadExecutionAggregate;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregate(final long topLevelStepExecutionId) throws IllegalArgumentException {
        WSStepThreadExecutionAggregate wSStepThreadExecutionAggregate;
        EntityManager em;
        block4: {
            WSStepThreadExecutionAggregate exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregate", new Object[]{topLevelStepExecutionId});
            }
            final WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
            em = this.getPsu().createEntityManager();
            WSStepThreadExecutionAggregate wSStepThreadExecutionAggregate2 = exec = (WSStepThreadExecutionAggregate)new TranRequest<WSStepThreadExecutionAggregate>(em){
                static final long serialVersionUID = -314602300114841642L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public WSStepThreadExecutionAggregate call() throws Exception {
                    if (JPAPersistenceManagerImpl.this.partitionVersion >= 2) {
                        Query query = em.createQuery("SELECT s,r FROM StepThreadExecutionEntity s LEFT JOIN RemotablePartitionEntity r ON r.stepExecutionEntity = s WHERE s.topLevelStepExecution.stepExecutionId = :topLevelStepExecutionId ORDER BY s.partitionNumber ASC");
                        query.setParameter("topLevelStepExecutionId", (Object)topLevelStepExecutionId);
                        List stepExecs = query.getResultList();
                        if (stepExecs == null || stepExecs.size() == 0) {
                            throw new IllegalArgumentException("Didn't find any step thread exec entries at id: " + topLevelStepExecutionId);
                        }
                        try {
                            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)((Object[])stepExecs.get(0))[0];
                            retVal.setTopLevelStepExecution(topLevelStepExecution);
                        }
                        catch (ClassCastException topLevelStepExecution) {
                            void e;
                            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$55", (String)"2413", (Object)this, (Object[])new Object[0]);
                            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at id: " + topLevelStepExecutionId, (Throwable)e);
                        }
                        ArrayList<WSPartitionStepAggregate> partitionSteps = new ArrayList<WSPartitionStepAggregate>(stepExecs.size());
                        ArrayList<WSPartitionStepThreadExecution> partitionLevelStepExecutions = new ArrayList<WSPartitionStepThreadExecution>(stepExecs.size());
                        for (int i = 1; i < stepExecs.size(); ++i) {
                            WSPartitionStepAggregateImpl partitionStepAggregate = new WSPartitionStepAggregateImpl((Object[])stepExecs.get(i));
                            partitionSteps.add(partitionStepAggregate);
                            partitionLevelStepExecutions.add(partitionStepAggregate.getPartitionStepThread());
                        }
                        retVal.setPartitionAggregate(partitionSteps);
                        retVal.setPartitionLevelStepExecutions(partitionLevelStepExecutions);
                    } else {
                        Query query = em.createNamedQuery("TopLevelStepExecutionEntity.getAllRelatedStepThreadExecsSortByPartNumAscQuery");
                        query.setParameter("topLevelStepExecutionId", (Object)topLevelStepExecutionId);
                        List stepExecs = query.getResultList();
                        if (stepExecs == null || stepExecs.size() == 0) {
                            throw new IllegalArgumentException("Didn't find any step thread exec entries at id: " + topLevelStepExecutionId);
                        }
                        try {
                            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)stepExecs.get(0);
                            retVal.setTopLevelStepExecution(topLevelStepExecution);
                        }
                        catch (ClassCastException topLevelStepExecution) {
                            void e;
                            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$55", (String)"2443", (Object)this, (Object[])new Object[0]);
                            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at id: " + topLevelStepExecutionId, (Throwable)e);
                        }
                        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(stepExecs.subList(1, stepExecs.size())));
                    }
                    return retVal;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$55", 55.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            wSStepThreadExecutionAggregate = wSStepThreadExecutionAggregate2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            wSStepThreadExecutionAggregate = wSStepThreadExecutionAggregate;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregate", wSStepThreadExecutionAggregate);
        }
        return wSStepThreadExecutionAggregate;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<StepExecution> getStepThreadExecutionsRunning(PersistenceServiceUnit psu, final long jobExecutionId) {
        List list;
        EntityManager em;
        block4: {
            List exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecutionsRunning", new Object[]{psu, jobExecutionId});
            }
            em = psu.createEntityManager();
            List list2 = exec = (List)new TranRequest<List<StepExecution>>(em){
                static final long serialVersionUID = 7061932755993039202L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public List<StepExecution> call() throws Exception {
                    TypedQuery query = em.createNamedQuery("StepThreadExecutionEntity.getStepThreadExecutionsByJobExecIdAndStatusesQuery", StepExecution.class);
                    query.setParameter("jobExecutionId", (Object)jobExecutionId);
                    query.setParameter("status", AbstractPersistenceManager.RUNNING_STATUSES);
                    List result = query.getResultList();
                    if (result == null) {
                        return new ArrayList<StepExecution>();
                    }
                    return result;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$56", 56.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecutionsRunning", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity updateRemotablePartitionLogDir(final RemotablePartitionKey key, final String logDirPath) {
        RemotablePartitionEntity remotablePartitionEntity;
        EntityManager em;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionLogDir", new Object[]{key, logDirPath});
            }
            if (this.partitionVersion < 2) {
                RemotablePartitionEntity remotablePartitionEntity2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    remotablePartitionEntity2 = remotablePartitionEntity2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionLogDir", remotablePartitionEntity2);
                }
                return remotablePartitionEntity2;
            }
            em = this.getPsu().createEntityManager();
            RemotablePartitionEntity remotablePartitionEntity3 = (RemotablePartitionEntity)new TranRequest<RemotablePartitionEntity>(em){
                static final long serialVersionUID = -3273626255677870969L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RemotablePartitionEntity call() {
                    RemotablePartitionEntity partitionEntity = (RemotablePartitionEntity)this.entityMgr.find(RemotablePartitionEntity.class, (Object)key);
                    if (partitionEntity == null) {
                        return null;
                    }
                    partitionEntity.setLogpath(logDirPath);
                    return partitionEntity;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$57", 57.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            remotablePartitionEntity = remotablePartitionEntity3;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionLogDir", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void purgeInGlassfish(String submitter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeInGlassfish", new Object[]{submitter});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeInGlassfish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean purgeJobInstanceAndRelatedData(final long jobInstanceId) {
        boolean bl;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeJobInstanceAndRelatedData", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            new TranRequest<Void>(em){
                static final long serialVersionUID = 3599965304829366687L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void call() {
                    JobInstanceEntity instance = (JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    this.entityMgr.remove((Object)instance);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$58", 58.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            boolean bl2 = true;
            bl = bl2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeJobInstanceAndRelatedData", bl);
        }
        return bl;
        finally {
            em.close();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void generate(Writer out) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "generate", new Object[]{out});
        }
        PersistenceServiceUnit ddlGen = this.createLatestPsu();
        ddlGen.generateDDL(out);
        ddlGen.close();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "generate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getDDLFileName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDDLFileName", new Object[0]);
        }
        String string = this.databaseStoreDisplayId + "_batchPersistence";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDDLFileName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Integer getJobExecutionEntityVersionField() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionEntityVersionField", new Object[0]);
        }
        Integer n = this.executionVersion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionEntityVersionField", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobExecutionEntityVersion() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionEntityVersion", new Object[0]);
        }
        if (this.executionVersion != null) {
            this.setJobExecutionEntityVersion(this.getPsu());
        }
        int n = this.executionVersion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionEntityVersion", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={PersistenceException.class})
    private void setJobExecutionEntityVersion(PersistenceServiceUnit psu) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setJobExecutionEntityVersion", new Object[]{psu});
        }
        if (this.partitionVersion == 2) {
            this.executionVersion = 3;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setJobExecutionEntityVersion");
            }
            return;
        }
        try (final EntityManager em = psu.createEntityManager();){
            Integer n = (Integer)new TranRequest<Integer>(em){
                static final long serialVersionUID = 6364765807717696488L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Integer call() throws Exception {
                    String queryString = "SELECT COUNT(e.jobParameterElements) FROM JobExecutionEntityV2 e";
                    TypedQuery query = em.createQuery(queryString, Long.class);
                    query.getSingleResult();
                    logger.fine("The JOBPARAMETER table exists, job execution entity version = 2");
                    JPAPersistenceManagerImpl.this.executionVersion = 2;
                    return JPAPersistenceManagerImpl.this.executionVersion;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$59", 59.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setJobExecutionEntityVersion");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Integer getJobInstanceEntityVersionField() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceEntityVersionField", new Object[0]);
        }
        Integer n = this.instanceVersion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceEntityVersionField", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceEntityVersion() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceEntityVersion", new Object[0]);
        }
        if (this.instanceVersion == null) {
            this.setJobInstanceEntityVersion(this.getPsu());
        }
        int n = this.instanceVersion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceEntityVersion", n);
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={PersistenceException.class})
    private void setJobInstanceEntityVersion(PersistenceServiceUnit psu) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[FORLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity updateJobInstanceWithGroupNames(final long jobInstanceID, final Set<String> groupNames) {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithGroupNames", new Object[]{jobInstanceID, groupNames});
            }
            em = this.getPsu().createEntityManager();
            JobInstanceEntity jobInstanceEntity2 = (JobInstanceEntity)new TranRequest<JobInstanceEntityV3>(em){
                static final long serialVersionUID = 3120509873809305466L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstanceEntityV3 call() {
                    JobInstanceEntityV3 instance = (JobInstanceEntityV3)this.entityMgr.find(JobInstanceEntityV3.class, (Object)jobInstanceID);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceID);
                    }
                    instance.setGroupNames(groupNames);
                    this.entityMgr.merge((Object)instance);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$62", 62.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithGroupNames", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={PersistenceException.class})
    private void setPartitionEntityVersion(PersistenceServiceUnit psu) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setPartitionEntityVersion", new Object[]{psu});
        }
        try (final EntityManager em = psu.createEntityManager();){
            Integer n = (Integer)new TranRequest<Integer>(em){
                static final long serialVersionUID = -1445357652419308181L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Integer call() throws Exception {
                    String queryString = "SELECT COUNT(e) FROM RemotablePartitionEntity e";
                    TypedQuery query = em.createQuery(queryString, Long.class);
                    query.getSingleResult();
                    logger.fine("The REMOTABLEPARTITION table exists, partition entity version = 2");
                    JPAPersistenceManagerImpl.this.partitionVersion = 2;
                    return JPAPersistenceManagerImpl.this.partitionVersion;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$63", 63.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setPartitionEntityVersion");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Integer getStepThreadExecutionEntityVersionField() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecutionEntityVersionField", new Object[0]);
        }
        Integer n = this.partitionVersion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecutionEntityVersionField", n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSRemotablePartitionState getRemotablePartitionInternalState(final RemotablePartitionKey remotablePartitionKey) {
        WSRemotablePartitionState wSRemotablePartitionState;
        EntityManager em;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionInternalState", new Object[]{remotablePartitionKey});
            }
            if (this.partitionVersion < 2) {
                WSRemotablePartitionState wSRemotablePartitionState2 = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    wSRemotablePartitionState2 = wSRemotablePartitionState2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionInternalState", (Object)wSRemotablePartitionState2);
                }
                return wSRemotablePartitionState2;
            }
            em = this.getPsu().createEntityManager();
            RemotablePartitionEntity rp = (RemotablePartitionEntity)new TranRequest<RemotablePartitionEntity>(em){
                static final long serialVersionUID = 3389009160740859377L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RemotablePartitionEntity call() throws Exception {
                    RemotablePartitionEntity rp = (RemotablePartitionEntity)em.find(RemotablePartitionEntity.class, (Object)remotablePartitionKey);
                    if (rp == null) {
                        logger.finer("No RemotablePartition found for key = " + remotablePartitionKey + ", maybe because it was dispatched from a JVM configured to use the older table/entity versions.");
                        return null;
                    }
                    return rp;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$64", 64.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            WSRemotablePartitionState wSRemotablePartitionState3 = rp != null ? rp.getInternalStatus() : null;
            wSRemotablePartitionState = wSRemotablePartitionState3;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            wSRemotablePartitionState = wSRemotablePartitionState;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionInternalState", (Object)wSRemotablePartitionState);
        }
        return wSRemotablePartitionState;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WSRemotablePartitionExecution> getRemotablePartitionsForJobExecution(final long jobExecutionId) {
        ArrayList<WSRemotablePartitionExecution> arrayList;
        EntityManager em;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsForJobExecution", new Object[]{jobExecutionId});
            }
            if (this.partitionVersion < 2) {
                List<WSRemotablePartitionExecution> list = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    list = list;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsForJobExecution", list);
                }
                return list;
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity exec = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = 5320608105639250069L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() {
                    JobExecutionEntity je = (JobExecutionEntity)em.find(JobExecutionEntityV3.class, (Object)jobExecutionId);
                    if (je == null) {
                        logger.finer("No job execution found with execution id = " + jobExecutionId);
                        return null;
                    }
                    return je;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$65", 65.class, (String)"wsbatch", null);
                }
            }.runInNewOrExistingGlobalTran();
            ArrayList<WSRemotablePartitionExecution> arrayList2 = new ArrayList<WSRemotablePartitionExecution>(exec.getRemotablePartitions());
            arrayList = arrayList2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getRemotablePartitionsForJobExecution", arrayList);
        }
        return arrayList;
        finally {
            em.close();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private abstract class TranRequest<T> {
        EntityManager entityMgr;
        boolean newTran = false;
        private LocalTransactionCoordinator suspendedLTC;
        static final long serialVersionUID = 8000910619062293170L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public TranRequest(EntityManager em) {
            this.entityMgr = em;
        }

        /*
         * WARNING - void declaration
         */
        public T runInNewOrExistingGlobalTran() {
            T retVal = null;
            try {
                this.beginOrJoinTran();
                retVal = this.call();
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2788", (Object)this, (Object[])new Object[0]);
                this.rollbackIfNewTranWasStarted((Throwable)t);
            }
            this.commitIfNewTranWasStarted();
            return retVal;
        }

        public abstract T call() throws Exception;

        protected void beginOrJoinTran() throws SystemException, NotSupportedException {
            int tranStatus = JPAPersistenceManagerImpl.this.tranMgr.getStatus();
            if (tranStatus == 6) {
                logger.fine("Suspending current LTC and beginning new transaction");
                this.suspendedLTC = JPAPersistenceManagerImpl.this.localTranCurrent.suspend();
                JPAPersistenceManagerImpl.this.tranMgr.begin();
                this.newTran = true;
            } else {
                if (JPAPersistenceManagerImpl.this.tranMgr.getTransaction() == null) {
                    throw new IllegalStateException("Didn't find active transaction but tranStatus = " + tranStatus);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Joining existing tran: " + JPAPersistenceManagerImpl.this.tranMgr.getTransaction());
                }
            }
            this.entityMgr.joinTransaction();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void commitIfNewTranWasStarted() {
            if (!this.newTran) {
                logger.fine("Exiting without committing previously-active transaction.");
                return;
            }
            logger.fine("Committing new transaction we started.");
            try {
                JPAPersistenceManagerImpl.this.tranMgr.commit();
            }
            catch (Throwable t) {
                try {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2829", (Object)this, (Object[])new Object[0]);
                    throw new PersistenceException(t);
                }
                catch (Throwable throwable) {
                    try {
                        this.resumeAnyExistingLTC();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        void t2;
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2834", (Object)this, (Object[])new Object[0]);
                        throw new PersistenceException("Caught throwable on resume of previous LTC.  Might mask earlier throwable, so check logs.", (Throwable)t2);
                    }
                }
            }
            try {
                this.resumeAnyExistingLTC();
                return;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2834", (Object)this, (Object[])new Object[0]);
                throw new PersistenceException("Caught throwable on resume of previous LTC.  Might mask earlier throwable, so check logs.", (Throwable)t);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void rollbackIfNewTranWasStarted(Throwable caughtThrowable) throws PersistenceException {
            if (this.newTran) {
                logger.fine("Rollback new transaction we started.");
                try {
                    JPAPersistenceManagerImpl.this.tranMgr.rollback();
                }
                catch (Throwable t2) {
                    try {
                        void t1;
                        FFDCFilter.processException((Throwable)t2, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2848", (Object)this, (Object[])new Object[]{caughtThrowable});
                        logger.fine("Tried to rollback, caught a new exception, throwing new PersistenceException with this new exception chained");
                        throw new PersistenceException("Caught throwable on rollback after previous throwable: " + caughtThrowable, (Throwable)t1);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.resumeAnyExistingLTC();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            void t22;
                            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2854", (Object)this, (Object[])new Object[]{caughtThrowable});
                            logger.fine("Tried to resume LTC, caught a new exception, throwing new PersistenceException with this new exception chained");
                            throw new PersistenceException("Caught throwable on resume of previous LTC.  Original throwable: " + caughtThrowable, (Throwable)t22);
                        }
                    }
                }
                try {
                    this.resumeAnyExistingLTC();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2854", (Object)this, (Object[])new Object[]{caughtThrowable});
                    logger.fine("Tried to resume LTC, caught a new exception, throwing new PersistenceException with this new exception chained");
                    throw new PersistenceException("Caught throwable on resume of previous LTC.  Original throwable: " + caughtThrowable, (Throwable)t2);
                }
            }
            logger.fine("We didn't start a new transaction so simply let the exception get thrown back.");
            logger.fine("No exception encountered, throwing new PersistenceException with original exception chained");
            throw new PersistenceException(caughtThrowable);
        }

        @Trivial
        protected void resumeAnyExistingLTC() {
            logger.fine("Will resume any LTC");
            if (this.suspendedLTC != null) {
                JPAPersistenceManagerImpl.this.localTranCurrent.resume(this.suspendedLTC);
                logger.fine("LTC resumed");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", TranRequest.class, (String)"wsbatch", null);
        }
    }
}

