/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.extra.spath;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.taglibs.standard.extra.spath.AttributePredicate;
import org.apache.taglibs.standard.extra.spath.ParseException;
import org.apache.taglibs.standard.extra.spath.Path;
import org.apache.taglibs.standard.extra.spath.Predicate;
import org.apache.taglibs.standard.extra.spath.SPathParser;
import org.apache.taglibs.standard.extra.spath.Step;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class SPathFilter
extends XMLFilterImpl {
    protected List steps;
    private int depth;
    private Stack acceptedDepths;
    private int excludedDepth;
    private static final boolean DEBUG = false;

    public static void main(String[] args) throws ParseException, IOException, SAXException {
        System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        String expr = args[0];
        SPathParser s = new SPathParser(expr);
        Path p = s.expression();
        XMLReader r = XMLReaderFactory.createXMLReader();
        SPathFilter f1 = new SPathFilter(p);
        XMLFilterImpl f2 = new XMLFilterImpl();
        f1.setParent(r);
        f2.setParent(f1);
        Serializer sz = SerializerFactory.getSerializer((Properties)OutputPropertiesFactory.getDefaultMethodProperties((String)"xml"));
        sz.setOutputStream((OutputStream)System.out);
        f2.setContentHandler(sz.asContentHandler());
        f2.parse(new InputSource(System.in));
        System.out.println();
    }

    public SPathFilter(Path path) {
        this.init();
        this.steps = path.getSteps();
    }

    private void init() {
        this.depth = 0;
        this.excludedDepth = -1;
        this.acceptedDepths = new Stack();
    }

    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        ++this.depth;
        if (this.isAccepted()) {
            this.getContentHandler().startElement(uri, localName, qName, a);
            return;
        }
        if (this.isExcluded()) {
            return;
        }
        Step currentStep = (Step)this.steps.get(this.acceptedDepths.size());
        if (SPathFilter.nodeMatchesStep(currentStep, uri, localName, qName, a)) {
            this.acceptedDepths.push(new Integer(this.depth - 1));
            if (this.isAccepted()) {
                this.getContentHandler().startElement(uri, localName, qName, a);
            }
        } else if (!currentStep.isDepthUnlimited()) {
            this.excludedDepth = this.depth - 1;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        if (this.isExcluded()) {
            if (this.excludedDepth == this.depth) {
                this.excludedDepth = -1;
            }
            return;
        }
        if (this.isAccepted()) {
            this.getContentHandler().endElement(uri, localName, qName);
        }
        if (this.acceptedDepths.size() > 0 && (Integer)this.acceptedDepths.peek() == this.depth) {
            this.acceptedDepths.pop();
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().ignorableWhitespace(ch, start, length);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.isAccepted()) {
            this.getContentHandler().skippedEntity(name);
        }
    }

    public void startDocument() {
        this.init();
    }

    public static boolean nodeMatchesStep(Step s, String uri, String localName, String qName, Attributes a) {
        if (!s.isMatchingName(uri, localName)) {
            return false;
        }
        List l = s.getPredicates();
        for (int i = 0; l != null && i < l.size(); ++i) {
            Predicate p = (Predicate)l.get(i);
            if (!(p instanceof AttributePredicate)) {
                throw new UnsupportedOperationException("only attribute predicates are supported by filter");
            }
            if (((AttributePredicate)p).isMatchingAttribute(a)) continue;
            return false;
        }
        return true;
    }

    private boolean isAccepted() {
        return this.acceptedDepths.size() >= this.steps.size();
    }

    private boolean isExcluded() {
        return this.excludedDepth != -1;
    }
}

