/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.orb.OB.Net;
import org.apache.yoko.orb.OB.ProtocolPolicy;
import org.apache.yoko.orb.OB.ProtocolPolicyHelper;
import org.apache.yoko.orb.OCI.ConnectCB;
import org.apache.yoko.orb.OCI.Connector;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.IIOP.ConnectorInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.Exceptions;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.Transport_impl;
import org.apache.yoko.orb.OCI.IIOP.UnifiedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ProfileInfoHolder;
import org.apache.yoko.orb.OCI.ProfileInfoSeqHolder;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.orb.exceptions.Transients;
import org.apache.yoko.util.Factory;
import org.apache.yoko.util.HexConverter;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.IOP.Codec;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;

final class Connector_impl
extends LocalObject
implements Connector {
    static final Logger logger = Logger.getLogger(Connector_impl.class.getName());
    private final IOR ior_;
    private final Policy[] policies_;
    private final boolean keepAlive_;
    private final ConnectorInfo_impl info_;
    private Socket socket_;
    private final ListenerMap listenMap_;
    private final UnifiedConnectionHelper connectionHelper;
    private final byte[] transportInfo;
    private final Codec codec_;

    private void close() {
        logger.fine("Closing connection to host=" + this.info_.getHost() + ", port=" + this.info_.getPort());
        try {
            this.socket_.close();
            this.socket_ = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public Transport connect() {
        Transport_impl tr;
        if (this.socket_ != null) {
            this.close();
        }
        String targetDesc = "host=" + this.info_.getHost() + ", port=" + this.info_.getPort();
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Connecting to " + targetDesc);
            }
            this.socket_ = this.connectionHelper.createSocket(this.info_.getHost(), this.info_.getPort(), this.ior_, this.policies_);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Connection created with socket " + this.socket_);
            }
        }
        catch (ConnectException ex) {
            throw (TRANSIENT)VerboseLogging.wrapped((Logger)VerboseLogging.CONN_LOG, (Exception)ex, (String)("Error connecting to " + targetDesc), (Factory)Transients.CONNECT_FAILED);
        }
        catch (IOException ex) {
            throw (COMM_FAILURE)VerboseLogging.logged((Logger)VerboseLogging.CONN_LOG, (Throwable)Exceptions.asCommFailure(ex, 1095974917), (String)("Error connecting to " + targetDesc));
        }
        try {
            this.socket_.setTcpNoDelay(true);
            if (this.keepAlive_) {
                this.socket_.setKeepAlive(true);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Exceptions.asCommFailure(ex);
        }
        try {
            tr = new Transport_impl(this.socket_, this.listenMap_);
            this.socket_ = null;
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Transport creation error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        TransportInfo trInfo = tr.get_info();
        try {
            this.info_._OB_callConnectCB(trInfo);
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Connection callback error", ex);
            tr.close();
            throw ex;
        }
        return tr;
    }

    @Override
    public Transport connect_timeout(int t) {
        Transport_impl tr;
        if (null != this.socket_) {
            this.close();
        }
        try {
            ConnectTimeout connectTimeout = new ConnectTimeout();
            connectTimeout.start();
            this.socket_ = connectTimeout.waitForConnect(t);
            if (null == this.socket_) {
                return null;
            }
        }
        catch (ConnectException ex) {
            throw (TRANSIENT)VerboseLogging.wrapped((Logger)VerboseLogging.CONN_OUT_LOG, (Exception)ex, (String)"Socket connection error", (Factory)Transients.CONNECT_FAILED);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket I/O error", ex);
            throw Exceptions.asCommFailure(ex, 1095974917);
        }
        try {
            this.socket_.setTcpNoDelay(true);
            if (this.keepAlive_) {
                this.socket_.setKeepAlive(true);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Exceptions.asCommFailure(ex);
        }
        try {
            tr = new Transport_impl(this.socket_, this.listenMap_);
            this.socket_ = null;
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Transport setup error", ex);
            try {
                this.socket_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
        TransportInfo trInfo = tr.get_info();
        try {
            this.info_._OB_callConnectCB(trInfo);
        }
        catch (SystemException ex) {
            logger.log(Level.FINE, "Callback setup error", ex);
            tr.close();
            throw ex;
        }
        return tr;
    }

    @Override
    public ProfileInfo[] get_usable_profiles(IOR ior, Policy[] policies) {
        for (Policy policy : policies) {
            ProtocolPolicy protocolPolicy;
            if (policy.policy_type() != 1330577410 || (protocolPolicy = ProtocolPolicyHelper.narrow((Object)policy)).contains("iiop")) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Protocol policy exists but does not allow expected transport. policy = " + Arrays.toString(protocolPolicy.value()) + "\t expected transport = " + "iiop");
            }
            return new ProfileInfo[0];
        }
        ProfileInfoSeqHolder profileInfoSeq = new ProfileInfoSeqHolder();
        profileInfoSeq.value = new ProfileInfo[0];
        String host = this.info_.getHost();
        if (Util.isEncodedHost(host)) {
            host = Util.decodeHost(host);
        }
        Util.extractAllProfileInfos(ior, profileInfoSeq, true, host, this.info_.getPort(), false, this.codec_);
        for (ProfileInfo profileInfo : profileInfoSeq.value) {
            byte[] otherTransportInfo = new byte[]{};
            for (TaggedComponent component : profileInfo.components) {
                if (component.tag != 33) continue;
                otherTransportInfo = component.component_data;
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Found CSI_SEC_MECH_LIST: " + HexConverter.octetsToAscii((byte[])otherTransportInfo));
                break;
            }
            if (Arrays.equals(this.transportInfo, otherTransportInfo)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Transport info does not match CSI_SEC_MECH_LIST: " + HexConverter.octetsToAscii((byte[])otherTransportInfo));
            }
            return new ProfileInfo[0];
        }
        return profileInfoSeq.value;
    }

    @Override
    public boolean equal(Connector con) {
        return con instanceof Connector_impl && this.equal0((Connector_impl)con);
    }

    private boolean equal0(Connector_impl that) {
        if (this.info_.getPort() != that.info_.getPort()) {
            return false;
        }
        return Net.CompareHosts(this.info_.getHost(), that.info_.getHost()) && Arrays.equals(this.transportInfo, that.transportInfo);
    }

    private byte[] extractTransportInfo(IOR ior) {
        ProfileInfoHolder holder = new ProfileInfoHolder();
        if (Util.extractProfileInfo(ior, holder)) {
            ProfileInfo profileInfo = holder.value;
            for (TaggedComponent component : profileInfo.components) {
                if (component.tag != 33) continue;
                return component.component_data;
            }
        }
        return new byte[0];
    }

    @Override
    public ConnectorInfo get_info() {
        return this.info_;
    }

    Connector_impl(IOR ior, Policy[] policies, String host, int port, boolean keepAlive, ConnectCB[] cb, ListenerMap lm, UnifiedConnectionHelper helper, Codec codec) {
        this.ior_ = ior;
        this.policies_ = policies;
        this.keepAlive_ = keepAlive;
        this.info_ = new ConnectorInfo_impl(host, port, cb);
        this.listenMap_ = lm;
        this.connectionHelper = Objects.requireNonNull(helper);
        this.codec_ = codec;
        this.transportInfo = this.extractTransportInfo(ior);
    }

    protected void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        super.finalize();
    }

    public String toString() {
        return "-> " + this.info_;
    }

    private class ConnectTimeout
    extends Thread {
        private final CompletableFuture<Socket> socketFuture = new CompletableFuture();

        private ConnectTimeout() {
        }

        @Override
        public void run() {
            try {
                Socket so_ = Connector_impl.this.connectionHelper.createSocket(Connector_impl.this.info_.getHost(), Connector_impl.this.info_.getPort(), Connector_impl.this.ior_, Connector_impl.this.policies_);
                if (this.socketFuture.complete(so_)) {
                    return;
                }
                try {
                    so_.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                this.socketFuture.completeExceptionally(e);
            }
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        synchronized Socket waitForConnect(int t) throws IOException {
            while (true) {
                try {
                    return this.socketFuture.get(t, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (TimeoutException e) {
                    if (this.socketFuture.cancel(false)) return null;
                    continue;
                }
                break;
            }
            catch (ExecutionException e) {
                throw (IOException)e.getCause();
            }
        }
    }
}

