/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.resource;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl;
import com.ibm.ws.jsp.translator.resource.ResourceUtil;
import com.ibm.ws.jsp.translator.resource.ResourcesImpl;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspResourcesContainerImpl
extends ResourcesImpl
implements JspResources {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.resource.JspResourcesImpl";
    private JspInputSourceContainerImpl inputSource;
    private String packageName;
    private String webinfClassRelativeUrl;
    private Container container;
    private long sourceFileTimestamp;
    static final long serialVersionUID = 4567242470036349761L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspResourcesContainerImpl(JspInputSource inputSource, JspOptions options, JspCoreContext context) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "<init>", new Object[]{inputSource, options, context});
        }
        this.inputSource = (JspInputSourceContainerImpl)inputSource;
        this.container = this.inputSource.getContainer();
        String jspUri = inputSource.getRelativeURL();
        try {
            URL outURL = options.getOutputDir().toURL();
            String outURI = outURL.toString();
            if (jspUri.charAt(0) != '/') {
                jspUri = "/" + jspUri;
            }
            File generatedSourceDir = null;
            String convertedName = null;
            Object webinfClassFilePath = null;
            if (!options.isUseFullPackageNames()) {
                this.packageName = "com.ibm._jsp";
                String unmangledOutURI = outURI;
                unmangledOutURI = unmangledOutURI.endsWith("/") ? unmangledOutURI + jspUri.substring(1, jspUri.lastIndexOf("/") + 1) : unmangledOutURI + jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                URL unmangledOutURL = new URL(unmangledOutURI);
                generatedSourceDir = new File(unmangledOutURL.getFile());
                this.className = NameMangler.mangleClassName(jspUri);
                convertedName = generatedSourceDir.getPath() + File.separator + this.className;
                this.generatedSourceFile = new File(convertedName + ".java");
                this.classFile = new File(convertedName + ".class");
                this.webinfClassRelativeUrl = "/WEB-INF/classes" + jspUri.substring(0, jspUri.lastIndexOf("/") + 1) + "/" + this.className + ".class";
            } else {
                this.packageName = jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                if (!this.packageName.equals("/")) {
                    this.packageName = NameMangler.handlePackageName(this.packageName);
                    this.packageName = "_ibmjsp." + this.packageName.substring(0, this.packageName.length() - 1);
                } else {
                    this.packageName = "_ibmjsp";
                }
                String packageDir = this.packageName.replace('.', '/');
                outURI = outURI.endsWith("/") ? outURI + packageDir : outURI + "/" + packageDir;
                outURL = new URL(outURI);
                generatedSourceDir = new File(outURL.getFile());
                this.className = NameMangler.mangleClassName(jspUri);
                convertedName = generatedSourceDir.getPath() + File.separator + this.className;
                this.generatedSourceFile = new File(convertedName + ".java");
                this.classFile = new File(convertedName + ".class");
                this.webinfClassRelativeUrl = "/WEB-INF/classes/" + packageDir + "/" + this.className + ".class";
            }
            this.keepgenerated = options.isKeepGenerated();
            this.keepGeneratedclassfiles = options.isKeepGeneratedclassfiles();
            this.sourceFileTimestamp = inputSource.getLastModified();
        }
        catch (MalformedURLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jsp.translator.utils.JspFilesImpl.init", (String)"45", (Object)this);
            logger.logp(Level.WARNING, CLASS_NAME, "JspResourcesImpl", "Error creating temp directory for jsp [" + jspUri + "]", e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getClassName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getClassName", new Object[0]);
        }
        String string = this.className;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getClassName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public File getGeneratedSourceFile() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getGeneratedSourceFile", new Object[0]);
        }
        File file = this.generatedSourceFile;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            file = file;
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getGeneratedSourceFile", file);
        }
        return file;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSource getInputSource() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getInputSource", new Object[0]);
        }
        JspInputSourceContainerImpl jspInputSourceContainerImpl = this.inputSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspInputSourceContainerImpl = jspInputSourceContainerImpl;
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getInputSource", jspInputSourceContainerImpl);
        }
        return jspInputSourceContainerImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPackageName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getPackageName", new Object[0]);
        }
        String string = this.packageName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "getPackageName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isExternallyTranslated() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "isExternallyTranslated", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "isExternallyTranslated", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isOutdated() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "isOutdated", new Object[0]);
        }
        File nullSourceFile = null;
        Entry containerEntry = this.inputSource.getInputSourceEntry();
        Entry webinfClassEntry = this.container.getEntry(this.webinfClassRelativeUrl);
        if (containerEntry == null) {
            long lastModified = this.inputSource.getLastModified();
            boolean bl = ResourceUtil.isOutdated(lastModified, null, nullSourceFile, this.generatedSourceFile, this.classFile, webinfClassEntry, null);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "isOutdated", bl);
            }
            return bl;
        }
        boolean bl = ResourceUtil.isOutdated(containerEntry, nullSourceFile, this.generatedSourceFile, this.classFile, webinfClassEntry, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "isOutdated", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setCurrentRequest(HttpServletRequest arg0) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "setCurrentRequest", new Object[]{arg0});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "setCurrentRequest");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void sync() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "sync", new Object[0]);
        }
        Entry e = this.container.getEntry(this.inputSource.getRelativeURL());
        if (e != null) {
            this.sourceFileTimestamp = e.getLastModified();
        }
        ResourceUtil.sync(this.sourceFileTimestamp, this.generatedSourceFile, this.classFile, this.className, this.keepgenerated, this.keepGeneratedclassfiles);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.translator.resource.JspResourcesContainerImpl", "sync");
        }
    }
}

