/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.callback.IJobExecutionEndCallbackService;
import com.ibm.jbatch.container.callback.IJobExecutionStartCallbackService;
import com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl;
import com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.BatchStatus;
import jakarta.transaction.TransactionManager;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BatchPartitionWorkUnit
extends BatchWorkUnit {
    private final PartitionPlanConfig partitionPlanConfig;
    private final PartitionReplyQueue partitionReplyQueue;
    static final long serialVersionUID = -3343170849289861477L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BatchPartitionWorkUnit(IBatchKernelService batchKernelService, RuntimePartitionExecution runtimePartitionExecution, PartitionPlanConfig config, List<IJobExecutionStartCallbackService> beforeCallbacks, List<IJobExecutionEndCallbackService> afterCallbacks, PartitionReplyQueue partitionReplyQueue, TransactionManager tranMgr) {
        super(batchKernelService, runtimePartitionExecution, beforeCallbacks, afterCallbacks, tranMgr, true);
        this.partitionReplyQueue = partitionReplyQueue;
        this.partitionPlanConfig = config;
        this.controller = new WorkUnitThreadControllerImpl(runtimePartitionExecution, partitionReplyQueue);
    }

    @Override
    protected void threadEnd() {
        super.threadEnd();
        boolean finalStatusSent = ((RuntimePartitionExecution)this.getRuntimeWorkUnitExecution()).isFinalStatusSent();
        if (!finalStatusSent) {
            try {
                this.partitionReplyQueue.add(new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_FINAL_STATUS).setBatchStatus(BatchStatus.FAILED).setExitStatus(BatchStatus.FAILED.toString()).setPartitionPlanConfig(this.partitionPlanConfig));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.util.BatchPartitionWorkUnit", (String)"93", (Object)this, (Object[])new Object[0]);
            }
            finally {
                this.partitionReplyQueue.close();
            }
        }
    }

    public String toString() {
        if (this.partitionPlanConfig == null) {
            return "PartitionWorkUnit <not initialized>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionWorkUnit with ");
        sb.append("jobExecutionId =" + this.partitionPlanConfig.getTopLevelExecutionId());
        sb.append(",stepName =" + this.partitionPlanConfig.getStepName());
        sb.append(",partitionNumber =" + this.partitionPlanConfig.getPartitionNumber());
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.util.BatchPartitionWorkUnit", BatchPartitionWorkUnit.class, null, null);
    }
}

