/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.concurrent;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import org.apache.yoko.util.KeyedFactory;
import org.apache.yoko.util.Sequential;
import org.apache.yoko.util.concurrent.ConcurrentFifo;
import org.apache.yoko.util.concurrent.Head;
import org.apache.yoko.util.concurrent.NNode;
import org.apache.yoko.util.concurrent.PNode;
import org.apache.yoko.util.concurrent.VNode;
import org.apache.yoko.util.concurrent.WeakNode;

public class WeakConcurrentFifo<T>
extends ConcurrentFifo<T> {
    private final ReferenceQueue<T> refQueue = new ReferenceQueue();
    private final KeyedFactory<? super T, Runnable> cleanupFactory;

    WeakConcurrentFifo(KeyedFactory<? super T, Runnable> cleanupFactory) {
        this.cleanupFactory = Objects.requireNonNull(cleanupFactory);
    }

    @Override
    public int size() {
        this.cleanup();
        return super.size();
    }

    @Override
    public T peek() {
        return this.getNextUncollectedValue(false);
    }

    @Override
    public Sequential.Place<T> put(T elem) {
        this.cleanup();
        return super.put(elem);
    }

    @Override
    public T remove() {
        return this.getNextUncollectedValue(true);
    }

    @Override
    protected VNode<T> createNode(T elem) {
        return new WeakNode<T>(elem, this.refQueue, this.cleanupFactory.create(elem));
    }

    private void cleanup() {
        this.peek();
    }

    private void processQ() {
        while (this.processStaleRef(this.refQueue.poll())) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processStaleRef(Reference<? extends T> ref) {
        if (ref == null) {
            return false;
        }
        WeakNode wn = (WeakNode)ref;
        PNode prev;
        while ((prev = wn.prev()) != null) {
            PNode pNode = prev;
            synchronized (pNode) {
                if (wn.prev() == prev) {
                    WeakNode weakNode = wn;
                    synchronized (weakNode) {
                        wn.delete();
                        this.size.decrementAndGet();
                        wn.cleanup.run();
                        return true;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private T getNextUncollectedValue(boolean removeNode) {
        Object elem;
        WeakNode curr;
        while (true) {
            this.processQ();
            Head head = this.head;
            // MONITORENTER : head
            NNode next = this.head.next();
            if (next == this.foot) {
                // MONITOREXIT : head
                return null;
            }
            NNode nNode = next;
            // MONITORENTER : nNode
            curr = (WeakNode)next;
            elem = curr.get();
            if (elem != null) break;
            curr.enqueue();
            // MONITOREXIT : nNode
            // MONITOREXIT : head
        }
        if (removeNode) {
            curr.delete();
            this.size.decrementAndGet();
        }
        // MONITOREXIT : nNode
        // MONITOREXIT : head
        return elem;
    }
}

