/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.net.Socket;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Net;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.ConnectorInfo;
import org.apache.yoko.orb.OCI.IIOP.ConnectorInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.TransportInfo;
import org.apache.yoko.orb.OCI.IIOP.Transport_impl;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;

public final class TransportInfo_impl
extends LocalObject
implements TransportInfo {
    private final Socket socket;
    private final Origin origin;
    private final ListenerMap listenMap_;
    private volatile ListenPoint[] listenPoints_ = null;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public short origin() {
        return this.origin.value;
    }

    @Override
    public String describe() {
        return String.format("%s %s:%d -> %s:%d", "iiop", this.addr(), TransportInfo_impl.unsigned(this.port()), this.remote_addr(), TransportInfo_impl.unsigned(this.remote_port()));
    }

    private static int unsigned(short s) {
        return 0xFFFF & s;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public String addr() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    @Override
    public short port() {
        return (short)this.socket.getLocalPort();
    }

    @Override
    public String remote_addr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public short remote_port() {
        return (short)this.socket.getPort();
    }

    @Override
    public ServiceContexts get_service_contexts(Policy[] policies) {
        for (Policy policy : policies) {
            BidirectionalPolicy p;
            if (policy.policy_type() != 37 || (p = BidirectionalPolicyHelper.narrow((Object)policy)).value() != 1) continue;
            BiDirIIOPServiceContext biDirCtxt = new BiDirIIOPServiceContext();
            biDirCtxt.listen_points = this.listenMap_.getListenPoints();
            try (OutputStream out = new OutputStream();){
                out._OB_writeEndian();
                BiDirIIOPServiceContextHelper.write((org.omg.CORBA.portable.OutputStream)out, (BiDirIIOPServiceContext)biDirCtxt);
                ServiceContexts serviceContexts = ServiceContexts.unmodifiable(new ServiceContext(5, out.copyWrittenBytes()));
                return serviceContexts;
            }
        }
        return ServiceContexts.EMPTY;
    }

    @Override
    public void handle_service_contexts(ServiceContexts contexts) {
        ServiceContext context = contexts.get(5);
        if (context == null) {
            return;
        }
        InputStream in = new InputStream(context.context_data);
        in._OB_readEndian();
        BiDirIIOPServiceContext biDirCtxt = BiDirIIOPServiceContextHelper.read((org.omg.CORBA.portable.InputStream)in);
        this._OB_setListenPoints(biDirCtxt.listen_points);
    }

    @Override
    public synchronized boolean received_bidir_service_context() {
        return this.listenPoints_ != null && this.listenPoints_.length > 0;
    }

    @Override
    public synchronized boolean endpoint_alias_match(ConnectorInfo connInfo) {
        ConnectorInfo_impl infoImpl;
        try {
            infoImpl = (ConnectorInfo_impl)connInfo;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (this.listenPoints_ == null) {
            return false;
        }
        short port = infoImpl.remote_port();
        String host = infoImpl.remote_addr();
        for (ListenPoint aListenPoints_ : this.listenPoints_) {
            if (aListenPoints_.port != port || !Net.CompareHosts(aListenPoints_.host, host)) continue;
            return true;
        }
        return false;
    }

    private synchronized void _OB_setListenPoints(ListenPoint[] lp) {
        this.listenPoints_ = lp;
    }

    private TransportInfo_impl(Socket socket, Origin origin, ListenerMap lm) {
        this.socket = socket;
        this.origin = origin;
        this.listenMap_ = lm;
    }

    TransportInfo_impl(Transport_impl transport, ListenerMap lm) {
        this(transport.socket_, Origin.CLIENT, lm);
    }

    TransportInfo_impl(Transport_impl transport, Acceptor acceptor, ListenerMap lm) {
        this(transport.socket_, Origin.SERVER, lm);
    }

    public String toString() {
        return this.describe();
    }

    private static enum Origin {
        CLIENT(0),
        SERVER(1);

        final short value;

        private Origin(int v) {
            this.value = (short)v;
        }
    }
}

