/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaUserDetails;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import jakarta.resource.spi.ConnectionRequestInfo;

final class JmsJcaConnectionRequestInfo
implements ConnectionRequestInfo,
Cloneable {
    private SICoreConnection _coreConnection;
    private final JmsJcaUserDetails _userDetails;
    private int _requestCounter;
    private static TraceComponent TRACE = SibTr.register(JmsJcaConnectionRequestInfo.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");

    JmsJcaConnectionRequestInfo(SICoreConnection coreConnection, String userName, String password) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo", (Object)new Object[]{coreConnection, userName, password == null ? null : "*****"});
        }
        this._coreConnection = coreConnection;
        this._userDetails = new JmsJcaUserDetails(userName, password);
        this._requestCounter = 0;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo");
        }
    }

    JmsJcaConnectionRequestInfo(SICoreConnection coreConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo", (Object)coreConnection);
        }
        this._coreConnection = coreConnection;
        this._userDetails = null;
        this._requestCounter = 0;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo");
        }
    }

    JmsJcaConnectionRequestInfo(String userName, String password) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo", (Object)new Object[]{userName, password == null ? null : "*****"});
        }
        this._userDetails = new JmsJcaUserDetails(userName, password);
        this._requestCounter = 0;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo");
        }
    }

    JmsJcaConnectionRequestInfo() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo");
        }
        this._userDetails = null;
        this._requestCounter = 0;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaConnectionRequestInfo");
        }
    }

    String getUserName() {
        return this._userDetails.getUserName();
    }

    String getPassword() {
        return this._userDetails.getPassword();
    }

    SICoreConnection getSICoreConnection() {
        return this._coreConnection;
    }

    void setSICoreConnection(SICoreConnection connection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"setSICoreConnection", (Object)connection);
        }
        this._coreConnection = connection;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"setSICoreConnection");
        }
    }

    JmsJcaUserDetails getUserDetails() {
        return this._userDetails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JmsJcaConnectionRequestInfo)) {
            return false;
        }
        JmsJcaConnectionRequestInfo otherInfo = (JmsJcaConnectionRequestInfo)other;
        boolean retVal = true;
        if (this._userDetails == null && otherInfo._userDetails != null) {
            retVal = false;
        }
        if (retVal && this._userDetails != null) {
            retVal = this._userDetails.equals(otherInfo._userDetails);
        }
        if (retVal && this._requestCounter != otherInfo._requestCounter) {
            retVal = false;
        }
        if (otherInfo.getSICoreConnection() != null && this.getSICoreConnection() != null && retVal) {
            retVal = otherInfo.getSICoreConnection().isEquivalentTo(this.getSICoreConnection());
        }
        return retVal;
    }

    public int hashCode() {
        int hashcode = this._userDetails == null ? 0 : this._userDetails.hashCode();
        return hashcode += this._requestCounter;
    }

    public void incrementRequestCounter() {
        ++this._requestCounter;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClass().getName());
        sb.append("@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("> <userDetails=");
        sb.append(this._userDetails);
        sb.append("> <coreConnection=");
        sb.append(this._coreConnection);
        sb.append("> <request counter=");
        sb.append(this._requestCounter);
        sb.append(">]");
        return sb.toString();
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo.clone", (String)"1:358:1.37", (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)e);
            }
            SibTr.error((TraceComponent)TRACE, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo.clone", "1:366:1.37"});
            throw new SIErrorException(NLS.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo.clone", "1:373:1.37", e}, null), (Throwable)e);
        }
        return clone;
    }
}

