/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.faces.flow.FlowScoped;
import org.apache.myfaces.flow.FlowReference;
import org.apache.myfaces.flow.cdi.FlowScopeBeanHolder;
import org.apache.myfaces.flow.cdi.FlowScopedContextImpl;

public class FlowScopeCDIExtension
implements Extension {
    private FlowScopedContextImpl flowScopedContext;
    private Map<Class, FlowReference> flowBeanReferences = new ConcurrentHashMap<Class, FlowReference>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addScope(FlowScoped.class, true, true);
        AnnotatedType bean = beanManager.createAnnotatedType(FlowScopeBeanHolder.class);
        event.addAnnotatedType(bean, bean.getJavaClass().getName());
    }

    void onProcessBean(@Observes ProcessBean event, BeanManager manager) {
        FlowScoped flowScoped;
        String flowId;
        if (event.getAnnotated().isAnnotationPresent(FlowScoped.class) && (flowId = (flowScoped = (FlowScoped)event.getAnnotated().getAnnotation(FlowScoped.class)).value()) != null) {
            this.flowBeanReferences.put(event.getBean().getBeanClass(), new FlowReference(flowScoped.definingDocumentId(), flowId));
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        this.flowScopedContext = new FlowScopedContextImpl(manager, this.flowBeanReferences);
        event.addContext((Context)this.flowScopedContext);
    }

    void initializeFlowContexts(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
    }
}

