/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.globalhandler;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerLogicalMsgCtxt;
import com.ibm.ws.jaxws.globalhandler.GlobalhandlerSOAPMessageContextImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.webservices.handler.GlobalHandlerMessageContext;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GlobalHandlerJaxWsMessageContext
extends WrappedMessageContext
implements GlobalHandlerMessageContext {
    private final Message message;
    static final TraceComponent tc = Tr.register(GlobalHandlerJaxWsMessageContext.class, null, null);
    static final long serialVersionUID = 3808063578617673642L;

    public GlobalHandlerJaxWsMessageContext(Message m) {
        super(m);
        this.message = m;
    }

    public <T> T adapt(Class<T> clazz) {
        Object messageContext = null;
        if (SOAPMessageContext.class.isAssignableFrom(clazz)) {
            messageContext = new GlobalhandlerSOAPMessageContextImpl(this.message);
            return clazz.cast(messageContext);
        }
        if (LogicalMessageContext.class.isAssignableFrom(clazz)) {
            messageContext = new GlobalHandlerLogicalMsgCtxt(this.message);
            return clazz.cast(messageContext);
        }
        return null;
    }

    public boolean containsProperty(String name) {
        return this.containsKey(name);
    }

    public String getEngineType() {
        return "JAX_WS";
    }

    public String getFlowType() {
        Exchange ex = this.message.getExchange();
        if (this.message == ex.getOutMessage()) {
            return "OUT";
        }
        if (this.message == ex.getInMessage()) {
            return "IN";
        }
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        HttpServletRequest request = (HttpServletRequest)this.message.get((Object)"HTTP.REQUEST");
        return request;
    }

    public HttpServletResponse getHttpServletResponse() {
        HttpServletResponse response = (HttpServletResponse)this.message.get((Object)"HTTP.RESPONSE");
        return response;
    }

    public Object getProperty(String name) {
        return this.get(name);
    }

    public Iterator<String> getPropertyNames() {
        Iterator<String> it = this.message.keySet().iterator();
        return it;
    }

    public boolean isClientSide() {
        return MessageUtils.isRequestor((Message)this.message);
    }

    public boolean isServerSide() {
        return !MessageUtils.isRequestor((Message)this.message);
    }

    public void removeProperty(String name) {
        this.remove(name);
    }

    public void setProperty(String name, Object value) {
        this.put(name, value);
    }
}

