/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.JBatchUtilityTask;
import com.ibm.ws.jbatch.utility.utils.ResourceBundleUtils;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.util.Collections;
import java.util.List;

public abstract class BaseCommandTask
implements JBatchUtilityTask {
    protected final String NL = System.getProperty("line.separator");
    protected final String scriptName;
    protected final String taskName;
    private TaskIO taskIO;

    public BaseCommandTask(String taskName, String scriptName) {
        this.taskName = taskName;
        this.scriptName = scriptName;
    }

    protected String getMessage(String key, Object ... args) {
        return ResourceBundleUtils.getMessage(key, args);
    }

    protected String getOption(String key, Object ... args) {
        return ResourceBundleUtils.getOption(key, args);
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public String getTaskDescription() {
        return this.getOption(this.getTaskName() + ".desc", new Object[0]);
    }

    protected void setTaskIO(TaskIO taskIO) {
        this.taskIO = taskIO;
    }

    protected TaskIO getTaskIO() {
        return this.taskIO;
    }

    protected String buildOptionsMessage(String optionKeyPrefix, String optionDescPrefix) {
        List<String> optionKeys;
        StringBuilder scriptOptions = new StringBuilder();
        if (!StringUtils.isEmpty(optionKeyPrefix) && !StringUtils.isEmpty(optionDescPrefix) && (optionKeys = this.getNlsOptionKeys(optionKeyPrefix)).size() > 0) {
            for (String optionKey : optionKeys) {
                String option = optionKey.substring(optionKeyPrefix.length());
                scriptOptions.append(this.NL);
                scriptOptions.append(ResourceBundleUtils.getOptions().getString(optionKey));
                scriptOptions.append(this.NL);
                scriptOptions.append(ResourceBundleUtils.getOptions().getString(optionDescPrefix + option));
                scriptOptions.append(this.NL);
            }
        }
        return scriptOptions.toString();
    }

    public List<String> getNlsOptionKeys(String nlsOptionKeyPrefix) {
        return StringUtils.filterPrefix(Collections.list(ResourceBundleUtils.getOptions().getKeys()), nlsOptionKeyPrefix);
    }

    public List<String> getNlsOptionNames(String nlsOptionKeyPrefix) {
        return StringUtils.trimPrefix(this.getNlsOptionKeys(nlsOptionKeyPrefix), nlsOptionKeyPrefix);
    }

    protected String getUsage(String usageMsgKey, Object ... args) {
        return this.getOption("global.usage", new Object[0]) + this.NL + this.getOption(usageMsgKey, args) + this.NL;
    }

    protected String getDesc(String descMsgKey) {
        return this.getOption("global.description", new Object[0]) + this.NL + this.getOption(descMsgKey, new Object[0]) + this.NL;
    }

    protected String collateRequiredOptions(List<String> formattedOptionMsgs) {
        StringBuilder sb = new StringBuilder().append(this.getOption("global.required", new Object[0]));
        for (String msg : formattedOptionMsgs) {
            sb.append(msg);
        }
        return sb.toString();
    }

    protected String collateOptionalOptions(List<String> formattedOptionMsgs) {
        StringBuilder sb = new StringBuilder().append(this.getOption("global.options", new Object[0]));
        for (String msg : formattedOptionMsgs) {
            sb.append(msg);
        }
        return sb.toString();
    }

    protected String joinMsgs(String ... msgs) {
        StringBuilder sb = new StringBuilder();
        for (String msg : msgs) {
            sb.append(msg).append(this.NL);
        }
        return sb.toString();
    }
}

